/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.updatev2.restart;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.jdownloader.logging.LogController;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.restart.LinuxRestarter;
import org.jdownloader.updatev2.restart.MacRestarter;
import org.jdownloader.updatev2.restart.WindowsRestarter;

public abstract class Restarter {
    private LogSource logger = LogController.getInstance().getLogger(this.getClass().getName());
    private RestartController controller;

    protected Restarter() {
        this.logger.setInstantFlush(true);
        this.logger.info("Create Restarter");
    }

    public LogSource getLogger() {
        return this.logger;
    }

    public void restart(File root, List<String> parameters) {
        try {
            if (parameters.contains("-norestart")) {
                this.logger.info("Do not restart due to -norestart parameter");
                return;
            }
            this.logger.info("RestartIt");
            List<String> lst = this.getApplicationStartCommands(root);
            this.logger.info("appcommands");
            this.logger.info("appcmd " + lst);
            lst.addAll(parameters);
            this.logger.info("cmdline " + lst);
            ProcessBuilder p = ProcessBuilderFactory.create(lst);
            p.directory(this.getRunInDirectory(root));
            this.logger.info("Start process");
            Process process = p.start();
            this.logger.info("Read errorstream");
            this.logger.logAsynch(process.getErrorStream());
            this.logger.info("Read inputstream");
            this.logger.logAsynch(process.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLogger().log(e);
        }
    }

    protected File getRunInDirectory(File root) {
        return root;
    }

    protected abstract List<String> getApplicationStartCommands(File var1);

    protected abstract List<String> getJVMApplicationStartCommands(File var1);

    public static Restarter getInstance(RestartController restartController) {
        Restarter restarter = CrossSystem.isWindows() ? new WindowsRestarter() : (CrossSystem.isMac() ? new MacRestarter() : new LinuxRestarter());
        super.setController(restartController);
        return restarter;
    }

    private void setController(RestartController restartController) {
        this.controller = restartController;
    }

    public RestartController getController() {
        return this.controller;
    }
}

