/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.updatev2;

import org.appwork.shutdown.BasicShutdownRequest;
import org.appwork.shutdown.ShutdownVetoException;
import org.appwork.shutdown.ShutdownVetoListener;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.RestartRequest;

public class SmartRlyRestartRequest
extends BasicShutdownRequest
implements RestartRequest {
    private volatile boolean alreadyAsked = false;
    private volatile boolean gotVeto = false;
    private String[] restartParams;

    public SmartRlyRestartRequest(boolean alreadyAsked, String[] arguments) {
        this.alreadyAsked = alreadyAsked;
        this.restartParams = arguments;
    }

    public SmartRlyRestartRequest(boolean alreadyAsked) {
        this.alreadyAsked = alreadyAsked;
        this.restartParams = new String[0];
    }

    public SmartRlyRestartRequest() {
        this(false);
    }

    @Override
    public boolean askForVeto(ShutdownVetoListener listener) {
        if (listener instanceof RestartController) {
            if (this.alreadyAsked) {
                return false;
            }
            this.alreadyAsked = true;
            return true;
        }
        return !this.gotVeto;
    }

    @Override
    public void addVeto(ShutdownVetoException e) {
        super.addVeto(e);
        this.gotVeto = true;
    }

    @Override
    public String[] getArguments() {
        return this.restartParams;
    }
}

