/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.updatev2;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.appwork.app.launcher.parameterparser.CommandSwitch;
import org.appwork.app.launcher.parameterparser.ParameterParser;
import org.appwork.resources.AWUTheme;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.shutdown.ShutdownVetoException;
import org.appwork.shutdown.ShutdownVetoListener;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Application;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.logging.LogController;
import org.jdownloader.updatev2.InstallUpdatesOnExitRestartRequest;
import org.jdownloader.updatev2.NoRestartException;
import org.jdownloader.updatev2.RestartRequest;
import org.jdownloader.updatev2.SmartRlyExitRequest;
import org.jdownloader.updatev2.UpdateController;
import org.jdownloader.updatev2.UpdateSettings;
import org.jdownloader.updatev2._UPDATE;
import org.jdownloader.updatev2.restart.Restarter;

public class RestartController
implements ShutdownVetoListener {
    private static final RestartController INSTANCE = new RestartController();
    private static final HashSet<String> IGNORE_COMMAND_SWITCHES = new HashSet();
    private ParameterParser startupParameters;
    private File root = Application.getTemp().getParentFile();
    private LogSource logger = LogController.getInstance().getLogger(RestartController.class.getName());

    public static RestartController getInstance() {
        return INSTANCE;
    }

    public void setRoot(File root) {
        if (root == null) {
            root = Application.getTemp().getParentFile();
        }
        this.log("Set Root: " + root.getAbsolutePath());
        this.root = root;
    }

    protected RestartController() {
        final Restarter restarter = Restarter.getInstance(this);
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){
            {
                this.setHookPriority(Integer.MIN_VALUE);
            }

            @Override
            public void onShutdown(ShutdownRequest shutdownRequest) {
                if (shutdownRequest instanceof RestartRequest) {
                    try {
                        String[] arguments = ((RestartRequest)shutdownRequest).getArguments();
                        restarter.restart(RestartController.this.getRoot(), RestartController.this.getFilteredRestartParameters(arguments));
                    }
                    catch (NoRestartException noRestartException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private File getRoot() {
        return this.root;
    }

    public List<String> getFilteredRestartParameters(String ... arguments) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.startupParameters != null) {
            for (Map.Entry entry : this.startupParameters.getMap().entrySet()) {
                if (IGNORE_COMMAND_SWITCHES.contains(entry.getKey() == null ? null : ((String)entry.getKey()).toLowerCase(Locale.ENGLISH))) continue;
                if (entry.getKey() != null) {
                    ret.add("-" + (String)entry.getKey());
                }
                for (String p : ((CommandSwitch)entry.getValue()).getParameters()) {
                    ret.add(p);
                }
            }
        }
        if (arguments != null) {
            for (String s : arguments) {
                if (s == null) continue;
                ret.add(s);
            }
        }
        return ret;
    }

    public void directRestart(RestartRequest request) {
        this.log("Direct Restart: ");
        ShutdownController.getInstance().requestShutdown(request);
    }

    public void asyncRestart(final RestartRequest request) {
        this.log("Asynch Restart: ");
        new Thread("RestartAsynch"){

            @Override
            public void run() {
                RestartController.this.log("Synch Restart NOW");
                ShutdownController.getInstance().requestShutdown(request);
            }
        }.start();
    }

    protected void log(String string) {
        try {
            System.out.println(string);
            this.logger.info(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void exitAsynch(final ShutdownRequest filter) {
        UpdateSettings cfg;
        if (filter == null) {
            throw new NullPointerException();
        }
        if (Application.isJared(null) && !Application.isHeadless() && SmartRlyExitRequest.class == filter.getClass() && (cfg = JsonConfig.create(UpdateSettings.class)).isInstallUpdatesOnExitEnabled() && UpdateController.getInstance().hasPendingUpdates()) {
            this.asyncRestart(new InstallUpdatesOnExitRestartRequest(filter));
            return;
        }
        new Thread("ExitAsynch"){

            @Override
            public void run() {
                ShutdownController.getInstance().requestShutdown(filter);
            }
        }.start();
    }

    public synchronized ParameterParser getParameterParser(String[] args) {
        if (this.startupParameters == null) {
            if (args == null) {
                throw new IllegalStateException();
            }
            this.startupParameters = new ParameterParser(args);
        }
        if (args != null) {
            this.startupParameters.setRawArguments(args);
        }
        return this.startupParameters;
    }

    @Override
    public void onShutdownVetoRequest(ShutdownRequest shutdownVetoExceptions) throws ShutdownVetoException {
        if (shutdownVetoExceptions.hasVetos()) {
            return;
        }
        if (shutdownVetoExceptions.isSilent()) {
            return;
        }
        try {
            if (shutdownVetoExceptions instanceof RestartRequest) {
                new ConfirmDialog(548, _UPDATE.T.RestartController_confirmTorestart_title(), _UPDATE.T.RestartController_confirmTorestart_msg(), AWUTheme.I().getIcon("restart", 32), null, null){

                    @Override
                    public String getDontShowAgainKey() {
                        return "Exit - Are you sure?";
                    }
                }.show().throwCloseExceptions();
            } else {
                new ConfirmDialog(548, _UPDATE.T.RestartController_confirmToExit_(), _UPDATE.T.RestartController_confirmToExit_msg(), AWUTheme.I().getIcon("exit", 32), null, null){

                    @Override
                    public String getDontShowAgainKey() {
                        return "Exit - Are you sure?";
                    }
                }.show().throwCloseExceptions();
            }
        }
        catch (DialogNoAnswerException e) {
            throw new ShutdownVetoException("Really Exit question denied", this);
        }
    }

    @Override
    public long getShutdownVetoPriority() {
        return 0L;
    }

    @Override
    public void onShutdown(ShutdownRequest request) {
    }

    @Override
    public void onShutdownVeto(ShutdownRequest request) {
    }

    static {
        IGNORE_COMMAND_SWITCHES.add("update");
        IGNORE_COMMAND_SWITCHES.add("selftest");
        IGNORE_COMMAND_SWITCHES.add("selfupdateerror");
        IGNORE_COMMAND_SWITCHES.add("afterupdate");
        IGNORE_COMMAND_SWITCHES.add("restart");
        IGNORE_COMMAND_SWITCHES.add("forceupdate");
    }
}

