/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.updatev2;

import java.util.ArrayList;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.defaults.AbstractDefaultFactory;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Application;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.jdownloader.updatev2.ProxyData;

public interface InternetConnectionSettings
extends ConfigInterface {
    public static final String PATH = "cfg/org.jdownloader.settings.InternetConnectionSettings";

    @AboutConfig
    @DescriptionForConfigEntry(value="List of all external Proxies")
    public void setCustomProxyList(ArrayList<ProxyData> var1);

    public ArrayList<ProxyData> getCustomProxyList();

    @AboutConfig
    @DescriptionForConfigEntry(value="Set preferred IP version to use")
    @DefaultEnumValue(value="SYSTEM")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public HTTPConnectionUtils.IPVERSION getPreferredIPVersion();

    public void setPreferredIPVersion(HTTPConnectionUtils.IPVERSION var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Timeout for connecting to a httpserver")
    @SpinnerValidator(min=0L, max=600000L)
    @DefaultIntValue(value=20000)
    @RequiresRestart(value="A JDownloader Restart is Required")
    public int getHttpConnectTimeout();

    @AboutConfig
    @DescriptionForConfigEntry(value="Timeout for reading from a httpserver")
    @SpinnerValidator(min=0L, max=600000L)
    @DefaultIntValue(value=60000)
    @RequiresRestart(value="A JDownloader Restart is Required")
    public int getHttpReadTimeout();

    public void setHttpConnectTimeout(int var1);

    public void setHttpReadTimeout(int var1);

    @AboutConfig
    public void setRouterIPCheckConnectTimeout(int var1);

    @DefaultIntValue(value=2000)
    public int getRouterIPCheckConnectTimeout();

    @AboutConfig
    public void setRouterIPCheckReadTimeout2(int var1);

    @DefaultIntValue(value=10000)
    public int getRouterIPCheckReadTimeout2();

    public void setLatestProfile(String var1);

    public String getLatestProfile();

    @AboutConfig
    public void setLocalPacScript(String var1);

    public String getLocalPacScript();

    @AboutConfig
    @DefaultFactory(value=ProxyVoleAutodetectionFactory.class)
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="Proxy Vole is used to autodetect your proxy settings. If you know how to setup your proxy, you can disable this.")
    public boolean isProxyVoleAutodetectionEnabled();

    public void setProxyVoleAutodetectionEnabled(boolean var1);

    public static class ProxyVoleAutodetectionFactory
    extends AbstractDefaultFactory<Boolean> {
        @Override
        public Boolean getDefaultValue(KeyHandler<Boolean> keyHandler) {
            return !Application.isHeadless();
        }
    }
}

