/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.updatev2;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;

public class InstallLog {
    private final HashSet<String> sourcePackages;
    private final Collection<String> modifiedFiles;
    private final Collection<String> modifiedPlugins;
    private final Collection<String> modifiedDirects = new HashSet<String>();
    private final Collection<String> modifiedRestartRequiredFiles;
    private final Collection<String> modifiedExtensionFiles;
    public static final String FILE_EXT_JARSIGNATURE = ".jarSignature";
    public static final String FILE_EXT_UPDATESIGNATURE = ".updateSignature";
    public static final String FILE_EXT_REMOVEDFILE = ".removed";
    public static final String FILE_EXT_JAR = ".jar";
    public static final String CLIENT_OPTIONS = ".clientOptions";
    public static final String SERVER_OPTIONS = ".serverOptions";

    public InstallLog() {
        this.modifiedFiles = new HashSet<String>();
        this.modifiedPlugins = new HashSet<String>();
        this.modifiedExtensionFiles = new HashSet<String>();
        this.modifiedRestartRequiredFiles = new HashSet<String>();
        this.sourcePackages = new HashSet();
    }

    public HashSet<String> getSourcePackages() {
        return this.sourcePackages;
    }

    public Collection<String> getModifiedFiles() {
        return this.modifiedFiles;
    }

    public Collection<String> getModifiedPlugins() {
        return this.modifiedPlugins;
    }

    public Collection<String> getModifiedDirects() {
        return this.modifiedDirects;
    }

    public Collection<String> getModifiedRestartRequiredFiles() {
        return this.modifiedRestartRequiredFiles;
    }

    public Collection<String> getModifiedExtensionFiles() {
        return this.modifiedExtensionFiles;
    }

    public void add(String relPath) {
        if (relPath.endsWith(FILE_EXT_UPDATESIGNATURE)) {
            return;
        }
        if (relPath.endsWith(FILE_EXT_JARSIGNATURE)) {
            return;
        }
        this.modifiedFiles.add(relPath);
        String check = relPath;
        if (check.endsWith(CLIENT_OPTIONS)) {
            check = relPath.substring(0, relPath.length() - CLIENT_OPTIONS.length());
        } else if (check.endsWith(SERVER_OPTIONS)) {
            check = relPath.substring(0, relPath.length() - SERVER_OPTIONS.length());
        } else if (check.endsWith(FILE_EXT_REMOVEDFILE)) {
            check = relPath.substring(0, relPath.length() - FILE_EXT_REMOVEDFILE.length());
        }
        if (check.equals("build.json")) {
            this.modifiedDirects.add(relPath);
        } else if (check.endsWith(".lng")) {
            this.modifiedDirects.add(relPath);
        } else if (check.endsWith(".class") && check.toLowerCase(Locale.ENGLISH).startsWith("jd/plugins")) {
            this.modifiedPlugins.add(relPath);
        } else if (relPath.startsWith("extensions/")) {
            this.modifiedExtensionFiles.add(relPath);
            this.modifiedRestartRequiredFiles.add(relPath);
        } else {
            this.modifiedRestartRequiredFiles.add(relPath);
        }
    }

    public void merge(InstallLog installLog) {
        this.modifiedDirects.addAll(installLog.modifiedDirects);
        this.modifiedFiles.addAll(installLog.modifiedFiles);
        this.modifiedPlugins.addAll(installLog.modifiedPlugins);
        this.modifiedExtensionFiles.addAll(installLog.modifiedExtensionFiles);
        this.modifiedRestartRequiredFiles.addAll(installLog.modifiedRestartRequiredFiles);
    }
}

