/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.lastchance.lastchances;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.appwork.storage.config.JsonConfig;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.defaultimpl.http.HttpBackend;
import org.appwork.updatesys.client.defaultimpl.http.HttpClientImpl;
import org.appwork.updatesys.client.lastchance.LastChanceFailedException;
import org.appwork.updatesys.client.lastchance.LastChanceInterface;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.update.ProxySelector;
import org.jdownloader.update.SelfUpdateClient;
import org.jdownloader.update.UpdateManager;
import org.jdownloader.update.launcher.SecondLevelLauncher;
import org.jdownloader.updatev2.InternetConnectionSettings;

public class UpdaterBug4July2017
implements LastChanceInterface {
    @Override
    public void runInternal(Object ... parameters) throws LastChanceFailedException {
        UpdaterBug4July2017.fix();
    }

    public static void fix() {
        try {
            Field field = UpdateManager.class.getDeclaredField("selfUpdateClient");
            field.setAccessible(true);
            SelfUpdateClient selfUpdateClient = (SelfUpdateClient)field.get(SecondLevelLauncher.UPDATE_MANAGER);
            UpdaterBug4July2017.fixClient(selfUpdateClient);
            UpdaterBug4July2017.fixClient(SecondLevelLauncher.UPDATE_MANAGER.getClient());
            SecondLevelLauncher.UPDATE_MANAGER.setGuiVisible(true, true);
            SecondLevelLauncher.UPDATE_MANAGER.runUpdateCheck(false);
            SecondLevelLauncher.UPDATE_MANAGER.waitForUpdate();
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
    }

    protected static void fixClient(final UpdateClient client) throws NoSuchFieldException, IllegalAccessException {
        final InternetConnectionSettings config = JsonConfig.create("cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class);
        HttpClientImpl fixedClient = new HttpClientImpl(null){
            {
                super(x0);
                this.setProxySelector(ProxySelector.getInstance());
            }

            @Override
            public LogInterface getLogger() {
                return client.getLogger();
            }

            @Override
            protected HttpBackend createHTTPBackend() {
                return new HttpBackend(this){

                    @Override
                    public int getConnectTimeout() {
                        return Math.max(5000, config.getHttpConnectTimeout());
                    }

                    @Override
                    public int getReadTimeout() {
                        return Math.max(5000, config.getHttpReadTimeout());
                    }
                };
            }
        };
        Field httpClientField = UpdateClient.class.getDeclaredField("httpClient");
        if (Modifier.isFinal(httpClientField.getModifiers())) {
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(httpClientField, httpClientField.getModifiers() & 0xFFFFFFEF);
            httpClientField.setAccessible(true);
        } else {
            httpClientField.setAccessible(true);
        }
        httpClientField.set(client, fixedClient);
    }
}

