/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.gui.bubble;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.ExtJWindow;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.Application;
import org.appwork.utils.ColorUtils;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.images.TransparentIcon;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.update.UpdaterIcon;
import org.jdownloader.update.gui.bubble.AbstractBubbleContentPanel;
import org.jdownloader.update.gui.bubble.Fader;
import org.jdownloader.update.locale.T;
import org.jdownloader.updatev2.gui.LAFOptions;

public abstract class AbstractNotifyWindow<ContentPanelType extends AbstractBubbleContentPanel>
extends ExtJWindow
implements GenericConfigEventListener<Boolean> {
    private static final int BOTTOM_MARGIN = 5;
    private static final int TOP_MARGIN = 20;
    private MigPanel content = new MigPanel("ins 2 5 10 5,wrap 1", "[grow,fill]", "[][grow,fill]"){

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            int width = this.getWidth();
            int height = this.getHeight();
            BufferedImage img = AbstractNotifyWindow.this.getSoftClipWorkaroundImage(g2d, width, height);
            g2d.drawImage((Image)img, 0, 0, null);
            g2d.dispose();
        }
    };
    private Fader fader;
    private Point endLocation;
    private Point startLocation;
    private int round = 10;
    private ContentPanelType contentComponent;
    private boolean disposed;
    private boolean closed;
    private JLabel headerLbl;
    private Color highlightColor;
    private static Boolean setWindowOpaqueSupported = null;
    private static Boolean getWindowOpacitySupported = null;
    private static Boolean setWindowOpacitySupported = null;

    public Point getEndLocation() {
        return this.endLocation;
    }

    public AbstractNotifyWindow(String caption, ContentPanelType comp) {
        ((AbstractBubbleContentPanel)comp).setWindow(this);
        this.setContentPane(this.content);
        this.content.add(this.createHeader(caption));
        this.contentComponent = comp;
        this.content.add((Component)comp);
        this.pack();
        this.round = 0;
        try {
            if (!AbstractNotifyWindow.setWindowOpaque(this)) {
                this.round = 10;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        AbstractNotifyWindow.setWindowOpacity(this, 0.0f);
        this.fader = new Fader(this);
    }

    @Override
    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    @Override
    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                AbstractNotifyWindow.this.updateLayout();
            }
        };
    }

    protected void updateLayout() {
        ((AbstractBubbleContentPanel)this.getContentComponent()).updateLayout();
        this.pack();
    }

    @Override
    public void dispose() {
        try {
            this.disposed = true;
            this.closed = true;
        }
        finally {
            super.dispose();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public ContentPanelType getContentComponent() {
        return this.contentComponent;
    }

    public static boolean setWindowOpaque(Window owner) {
        if (Boolean.FALSE.equals(setWindowOpaqueSupported)) {
            return false;
        }
        try {
            ReflectionUtils.invoke("com.sun.awt.AWTUtilities", "setWindowOpaque", null, Void.TYPE, owner, false);
            setWindowOpaqueSupported = Boolean.TRUE;
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            setWindowOpaqueSupported = Boolean.FALSE;
            return false;
        }
    }

    public static Float getWindowOpacity(Window owner) {
        if (Boolean.FALSE.equals(getWindowOpacitySupported)) {
            return null;
        }
        try {
            Float ret = null;
            ret = Application.getJavaVersion() >= Application.JAVA17 ? Float.valueOf(owner.getOpacity()) : ReflectionUtils.invoke("com.sun.awt.AWTUtilities", "getWindowOpacity", null, Float.TYPE, owner);
            getWindowOpacitySupported = Boolean.TRUE;
            return ret;
        }
        catch (Throwable e) {
            e.printStackTrace();
            getWindowOpacitySupported = Boolean.FALSE;
            return null;
        }
    }

    public static void setWindowOpacity(Window window, float f) {
        if (Boolean.FALSE.equals(setWindowOpacitySupported)) {
            return;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        try {
            if (gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
                if (Application.getJavaVersion() >= Application.JAVA17) {
                    window.setOpacity(f);
                } else {
                    ReflectionUtils.invoke("com.sun.awt.AWTUtilities", "setWindowOpacity", null, Void.TYPE, window, Float.valueOf(f));
                }
                setWindowOpacitySupported = Boolean.TRUE;
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        setWindowOpacitySupported = Boolean.FALSE;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            super.setVisible(b);
            this.fader.fadeIn(this.getFadeSpeed());
        } else {
            this.fader.fadeOut(this.getFadeSpeed());
        }
    }

    protected int getFadeSpeed() {
        return 500;
    }

    public void setHeaderText(String txt) {
        this.headerLbl.setText(txt);
    }

    protected void onHide() {
    }

    private Component createHeader(String caption) {
        MigPanel ret = new MigPanel("ins 0", "[grow,fill][][]", "[]");
        this.headerLbl = new JLabel(caption);
        this.headerLbl.setForeground(ColorUtils.getAlphaInstance(this.headerLbl.getForeground(), 160));
        this.headerLbl.setHorizontalAlignment(2);
        ret.add(SwingUtils.toBold(this.headerLbl));
        SwingUtils.setOpaque(ret, false);
        SwingUtils.setOpaque(this.headerLbl, false);
        ExtButton settings = new ExtButton(){
            private static final long serialVersionUID = 1L;
            final AbstractIcon icon;
            {
                this.setToolTipText(T.T.installonexitframe_hide());
                this.setRolloverEffectEnabled(true);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractNotifyWindow.this.onHide();
                        this.onRollOut();
                    }
                });
                this.icon = new AbstractIcon(UpdaterIcon.popDownLarge.path(), 16);
            }

            @Override
            protected void onRollOut() {
                this.setContentAreaFilled(false);
                this.setIcon(new TransparentIcon((Icon)this.icon, 0.5f));
            }

            @Override
            protected void onRollOver() {
                this.setIcon((Icon)this.icon);
            }
        };
        ret.add((Component)settings, "width 16!,height 16!");
        ExtButton closeButton = new ExtButton(){
            private static final long serialVersionUID = 1L;
            final AbstractIcon icon;
            {
                this.setToolTipText(T.T.installonexitframe_cancel());
                this.setRolloverEffectEnabled(true);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractNotifyWindow.this.onClose();
                        this.onRollOut();
                    }
                });
                this.icon = new AbstractIcon(UpdaterIcon.BUBBLE_CLOSE.path(), 16);
            }

            @Override
            protected void onRollOut() {
                this.setContentAreaFilled(false);
                this.setIcon(new TransparentIcon((Icon)this.icon, 0.5f));
            }

            @Override
            protected void onRollOver() {
                this.setIcon((Icon)this.icon);
            }
        };
        ret.add((Component)closeButton, "width 16!,height 16!");
        SwingUtils.setOpaque(ret, false);
        SwingUtils.setOpaque(this.headerLbl, false);
        SwingUtils.setOpaque(closeButton, false);
        return ret;
    }

    public void onClose() {
        this.closed = true;
        this.setVisible(false);
        Timer disposeTimer = new Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractNotifyWindow.this.dispose();
            }
        });
        disposeTimer.setRepeats(false);
        disposeTimer.start();
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
        this.repaint();
    }

    protected BufferedImage getSoftClipWorkaroundImage(Graphics2D g2d, int width, int height) {
        GraphicsConfiguration gc = g2d.getDeviceConfiguration();
        BufferedImage img = gc.createCompatibleImage(width, height, 3);
        Graphics2D g2 = img.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, width, height);
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.round, this.round);
        g2.setComposite(AlphaComposite.SrcAtop);
        GradientPaint p = null;
        if (this.highlightColor == null) {
            p = new GradientPaint(0.0f, 0.0f, LAFOptions.getInstance().getColorForPanelHeaderBackground(), 0.0f, 20.0f, LAFOptions.getInstance().getColorForScrollbarsMouseOverState());
            g2.setPaint(p);
        } else {
            p = new GradientPaint(0.0f, 0.0f, this.highlightColor, 0.0f, 20.0f, this.highlightColor.brighter());
            g2.setPaint(p);
        }
        g2.fillRoundRect(0, 0, width, height, this.round, this.round);
        p = new GradientPaint(0.0f, 0.0f, LAFOptions.getInstance().getColorForPanelBackground(), 0.0f, 20.0f, LAFOptions.getInstance().getColorForPanelBackground().brighter());
        g2.setPaint(p);
        g2.fillRect(0, 20, width, height - 20 - 5);
        g2.setColor(LAFOptions.getInstance().getColorForPanelBorders());
        g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.round, this.round);
        g2.dispose();
        return img;
    }

    public void setPreferedLocation(int x, int y) {
        this.fader.moveTo(x, y, this.getFadeSpeed());
    }

    public void setEndLocation(Point p) {
        this.endLocation = p;
    }

    public void setStartLocation(Point point) {
        if (this.startLocation == null) {
            this.setLocation(point);
            this.startLocation = point;
        }
    }

    public Point getStartLocation() {
        return this.startLocation;
    }

    public float getFinalTransparency() {
        return 0.85f;
    }

    public void setHighlightColor(Object object) {
    }
}

