/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.appwork.utils.swing.EDTRunner;

public class ProgressLogo
extends JLabel {
    private static final long serialVersionUID = 1L;
    private final Icon icon;
    private float progress = 0.0f;
    private final Dimension prefsize;
    private final Icon iconBorder;

    public ProgressLogo(Icon iconEnd, Icon iconStart) {
        super(iconStart);
        this.icon = iconEnd;
        this.iconBorder = iconStart;
        this.prefsize = new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
    }

    public float getProgress() {
        return this.progress;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setClip(new Rectangle(this.prefsize.width, this.prefsize.height));
        this.iconBorder.paintIcon(this, g2, 0, 0);
        int step = 3;
        int pixel = (int)((float)(this.prefsize.width * this.prefsize.height) * this.progress) / step;
        int height = (int)Math.floor(pixel / this.prefsize.width) * step;
        int rest = pixel % this.prefsize.width;
        Polygon p = new Polygon();
        p.addPoint(0, this.prefsize.height);
        p.addPoint(this.prefsize.width, this.prefsize.height);
        if (rest > 0) {
            p.addPoint(this.prefsize.width, this.prefsize.height - height);
            p.addPoint(rest, this.prefsize.height - height);
            p.addPoint(Math.max(0, rest - step), this.prefsize.height - height - step);
            p.addPoint(0, this.prefsize.height - height - step);
        } else {
            p.addPoint(this.prefsize.width, this.prefsize.height - height);
            p.addPoint(0, this.prefsize.height - height);
        }
        p.addPoint(0, this.prefsize.height);
        g2.setClip(p);
        this.icon.paintIcon(this, g2, 0, 0);
    }

    public void setProgress(float prg) {
        this.progress = prg;
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ProgressLogo.this.setToolTipText("Update Installation Progress: " + (int)(ProgressLogo.this.progress * 100.0f) + "%");
                ProgressLogo.this.repaint();
            }
        };
    }
}

