/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update;

import java.awt.Window;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ImageIcon;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.handler.DefaultFactoryInterface;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.updatesys.client.AbsoluteFile;
import org.appwork.updatesys.client.DeduplicationException;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.ImplBuilder;
import org.appwork.updatesys.client.InstallException;
import org.appwork.updatesys.client.LastChanceException;
import org.appwork.updatesys.client.PackageCreateException;
import org.appwork.updatesys.client.PathBuilder;
import org.appwork.updatesys.client.ServerLockedException;
import org.appwork.updatesys.client.Setup;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.UrlFactoryInterface;
import org.appwork.updatesys.client.defaultimpl.UrlFactoryImpl;
import org.appwork.updatesys.client.defaultimpl.http.HttpBackend;
import org.appwork.updatesys.client.defaultimpl.http.HttpClientImpl;
import org.appwork.updatesys.client.http.HttpClientInterface;
import org.appwork.updatesys.client.http.ProxySelectorException;
import org.appwork.updatesys.client.jardelta.JarMergeException;
import org.appwork.updatesys.transport.Pkg;
import org.appwork.updatesys.transport.TransportException;
import org.appwork.updatesys.transport.exchange.PackageResponse;
import org.appwork.updatesys.transport.exchange.ResponseStatus;
import org.appwork.updatesys.transport.exchange.UpdateOptions;
import org.appwork.updatesys.transport.exchange.interfaces.PackageResponseInterface;
import org.appwork.updatesys.transport.exchange.interfaces.WaitResponseInterface;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.NonInterruptibleRunnable;
import org.appwork.utils.NonInterruptibleRunnableException;
import org.appwork.utils.NonInterruptibleRunnableReturn;
import org.appwork.utils.NonInterruptibleRunnableSimple;
import org.appwork.utils.StringUtils;
import org.appwork.utils.crypto.SignatureViolationException;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.locator.Locator;
import org.jdownloader.logging.LogController;
import org.jdownloader.update.AWFUpdatePackage;
import org.jdownloader.update.CanceledException;
import org.jdownloader.update.DefaultCallbackHandler;
import org.jdownloader.update.DialogHook;
import org.jdownloader.update.HeadlessUpdateGuiWrapper;
import org.jdownloader.update.Info;
import org.jdownloader.update.JDUpdateClient;
import org.jdownloader.update.LaunchState;
import org.jdownloader.update.PathBuilderImpl;
import org.jdownloader.update.PendingUpdate;
import org.jdownloader.update.ProxySelector;
import org.jdownloader.update.SelfRunner;
import org.jdownloader.update.SelfUpdateClient;
import org.jdownloader.update.SelfUpdateException;
import org.jdownloader.update.UIInterface;
import org.jdownloader.update.UpdateThread;
import org.jdownloader.update.awf.AWFArchive;
import org.jdownloader.update.gui.PollCallback;
import org.jdownloader.update.gui.UpdateGuiWrapper;
import org.jdownloader.update.gui.UpdateOnExitGuiWrapper;
import org.jdownloader.update.lastchance.LastChanceManager;
import org.jdownloader.update.launcher.Timeout;
import org.jdownloader.update.locale.T;
import org.jdownloader.updatev2.ForcedRestartRequest;
import org.jdownloader.updatev2.InstallLog;
import org.jdownloader.updatev2.InternetConnectionSettings;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.UpdateCallbackInterface;
import org.jdownloader.updatev2.UpdateHandler;
import org.jdownloader.updatev2.UpdateSettings;

public class UpdateManager
implements UpdateHandler {
    public static final String RESTART = "restart";
    private final JDUpdateClient client;
    private final UpdateSettings settings;
    private final SelfUpdateClient selfUpdateClient;
    private UIInterface gui;
    private final LogSource logger;
    private final AtomicReference<UpdateCallbackInterface> handler = new AtomicReference<Object>(null);
    private final DefaultCallbackHandler defaultHandler;
    private UpdateThread thread;
    private final Setup clientSetup;
    private long latestUpdateCheck = System.currentTimeMillis();
    private LaunchState launchState = LaunchState.START;
    private boolean runningSelfupdate;
    private boolean runningClientupdate;
    private File packageAWFFile;
    private File packageAWFSelfupdateFile;
    private boolean enabled = true;
    private final AtomicInteger selfUpdaterRevision = new AtomicInteger(-1);
    private final AtomicInteger selfUpdaterSuperRevision = new AtomicInteger(-1);
    private final AtomicInteger clientSuperRevision = new AtomicInteger(-1);
    private Thread intervalChecker;
    private boolean restartEnabled = true;
    private boolean forceUpdateFlag;
    public static final boolean DEBUG_SELFTEST = System.getProperty("DEBUG_SELFTEST") != null;
    public static final String USER_AGENT = "JDownloader/201707061810";
    private List<InstallLog> installLogs = new ArrayList<InstallLog>();
    private boolean updateOnExitFlag;
    private boolean alwaysOnTopExternal;
    private final boolean preExtractFlag = false;

    public UpdateManager(UpdateSettings setup, boolean updateOnExitMode) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        HttpBackend.setGlobalUserAgent(USER_AGENT);
        this.settings = setup;
        this.logger = LogController.getInstance().getLogger(UpdateManager.class.getName());
        long t = System.currentTimeMillis();
        this.clientSetup = JsonConfig.create("cfg/updateclient/Setup", Setup.class);
        final DefaultFactoryInterface ex = this.clientSetup._getStorageHandler().getDefaultFactory();
        this.clientSetup._getStorageHandler().setDefaultFactory(new DefaultFactoryInterface(){

            @Override
            public Object getDefaultValue(KeyHandler<?> handler, Object o) {
                if (handler.getKey().equals("namespace")) {
                    UpdateManager.this.logger.warning("Namspace not set!");
                    return "JD";
                }
                return ex.getDefaultValue(handler, o);
            }
        });
        this.logger.fine("ClientSetup " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        this.client = (JDUpdateClient)new NonInterruptibleRunnable<JDUpdateClient, IOException>(){

            @Override
            public JDUpdateClient run() throws IOException, InterruptedException {
                try {
                    return new JDUpdateClient(UpdateManager.this.clientSetup, UpdateManager.this.createImplBuilder());
                }
                catch (InvalidKeySpecException e) {
                    throw new WTFException(e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new WTFException(e);
                }
            }
        }.startAndWait();
        this.logger.fine("Client " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        this.selfUpdateClient = (SelfUpdateClient)new NonInterruptibleRunnable<SelfUpdateClient, IOException>(){

            @Override
            public SelfUpdateClient run() throws IOException, InterruptedException {
                try {
                    return new SelfUpdateClient(UpdateManager.this.client, UpdateManager.this);
                }
                catch (InvalidKeySpecException e) {
                    throw new WTFException(e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new WTFException(e);
                }
            }
        }.startAndWait();
        this.logger.fine("selfUpdateClient " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        LastChanceManager.getInstance().setClients(this.client, this.selfUpdateClient);
        this.logger.fine("LastChanceInit " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        this.setUpdateOnExitFlag(updateOnExitMode);
        this.logger.fine("setUpdateOnExitFlag " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        this.gui = this.createGui();
        this.logger.fine("CreateGui " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        this.defaultHandler = new DefaultCallbackHandler(this);
        this.defaultHandler.setDoNotAsk(updateOnExitMode);
        this.logger.fine("DefaultHandler " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        this.handler.set(this.defaultHandler);
        this.logger.fine("SetDefaultHandler " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        ProxySelector.getInstance().setUpdateManager(this);
        this.logger.fine("ProxySelector " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
    }

    protected double avg(double client, double self) {
        if (this.runningClientupdate && this.runningSelfupdate) {
            return (client + self) / 2.0;
        }
        if (this.runningClientupdate) {
            return client;
        }
        if (this.runningSelfupdate) {
            return self;
        }
        return -1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstallLog createAWFInstallLog() throws InterruptedException, IOException {
        try {
            this.gui.startPoll(new PollCallback(){

                @Override
                public void run() {
                    UpdateManager.this.gui.setProgress(UpdateManager.this.client.getModuleProgressValue());
                }
            });
            InstallLog installLog = new InstallLog();
            for (AWFUpdatePackage awf : this.client.getAWFFilesToInstall()) {
                File file = awf.getFile();
                installLog.getSourcePackages().add(file.getAbsolutePath());
                if (file.length() <= 0L) continue;
                AWFArchive archive = new AWFArchive(this.client, awf);
                archive.setProgress(this.client.getModuleProgress());
                archive.getProgress().setStepVolume(0.1);
                for (String f : archive.list()) {
                    installLog.add(f);
                }
            }
            InstallLog installLog2 = installLog;
            return installLog2;
        }
        finally {
            this.gui.stopPoll();
        }
    }

    private UIInterface createGui() {
        if (Application.isHeadless()) {
            return new HeadlessUpdateGuiWrapper(this);
        }
        if (this.isUpdateOnExitFlag()) {
            return new UpdateOnExitGuiWrapper(this);
        }
        return new UpdateGuiWrapper(this);
    }

    private ImplBuilder createImplBuilder() {
        final InternetConnectionSettings config = JsonConfig.create("cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class);
        return new ImplBuilder(){

            @Override
            public HttpClientInterface createHTTPClient(UpdateClient client) {
                HttpClientImpl ret = new HttpClientImpl(client.getLogger()){
                    {
                        this.setProxySelector(ProxySelector.getInstance());
                    }

                    @Override
                    protected HttpBackend createHTTPBackend() {
                        return new HttpBackend(this){

                            @Override
                            public int getConnectTimeout() {
                                return Math.max(5000, config.getHttpConnectTimeout());
                            }

                            @Override
                            public int getReadTimeout() {
                                return Math.max(5000, config.getHttpReadTimeout());
                            }
                        };
                    }
                };
                return ret;
            }

            @Override
            public LogInterface createLogger(UpdateClient o) {
                return UpdateManager.this.logger;
            }

            @Override
            public PathBuilder createPathbuilder(UpdateClient updateClient) {
                return new PathBuilderImpl(updateClient);
            }

            @Override
            public UrlFactoryInterface createUrlBuilder(UpdateClient client) {
                return new UrlFactoryImpl(client){

                    @Override
                    protected void append(StringBuilder sb) throws InterruptedException {
                        try {
                            UpdateClient client = this.getClient();
                            if (client instanceof JDUpdateClient) {
                                JDUpdateClient jdUpdateClient = (JDUpdateClient)client;
                                if (!jdUpdateClient.isUpdaterCheckEnabled()) {
                                    sb.append("&urev=").append(Integer.MAX_VALUE);
                                } else {
                                    sb.append("&urev=").append(UpdateManager.this.selfUpdaterRevision.get());
                                }
                                sb.append("&srev=").append(UpdateManager.this.clientSuperRevision.get());
                                sb.append("&surev=").append(UpdateManager.this.selfUpdaterSuperRevision.get());
                            }
                        }
                        catch (RuntimeException e) {
                            UpdateManager.this.getLogger().log(e);
                        }
                        try {
                            File clienttype = Application.getResource("client.type");
                            if (clienttype.isFile()) {
                                sb.append("&ct=");
                                sb.append(this.encode(this.getClient().getFileSystem().secureReadFileToString(clienttype).trim()));
                            } else {
                                sb.append("&ct=Normal");
                            }
                        }
                        catch (ExtIOException e) {
                            UpdateManager.this.getLogger().log(e);
                        }
                        catch (RuntimeException e) {
                            UpdateManager.this.getLogger().log(e);
                        }
                        try {
                            UpdateManager.this.getHandler().append(sb);
                        }
                        catch (RuntimeException e) {
                            UpdateManager.this.getLogger().log(e);
                        }
                    }
                };
            }
        };
    }

    public void deleteAllAwfs() {
        this.logger.info("Delete all awf files");
        for (final File awf : Application.getTempResource("update").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isFile() && name.endsWith(".awf");
            }
        })) {
            this.logger.info("Delete AWF: " + awf);
            new NonInterruptibleRunnableSimple(){

                @Override
                protected void execute() throws InterruptedException {
                    try {
                        UpdateManager.this.getClient().getFileSystem().deleteFileIfExists(awf);
                    }
                    catch (ExtIOException e) {
                        UpdateManager.this.getLogger().log(e);
                    }
                }
            }.startAndWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void finish(boolean doNotAskAgain) throws ExtIOException {
        block18: {
            String[] list;
            this.logger.info("Current State: ");
            this.logger.info("Do Not ask Flag: " + doNotAskAgain);
            this.logger.info("Settings: " + this.settings);
            this.logger.info("Client Revision: " + this.client.readSuperRevision().getId());
            this.logger.info("Client Revision incl. Pending Installpackages: " + this.client.readRevision().getId());
            this.logger.info("Updater Client Revision: " + this.selfUpdateClient.superReadRevision().getId());
            this.logger.info("Updater Client Revision incl. Pending Installpackages: " + this.selfUpdateClient.readRevision().getId());
            if (!DEBUG_SELFTEST && !Application.isJared(null)) {
                this.logger.info("Do not install Updates on Launch in IDE!!");
                return;
            }
            File tmpRoot = Application.getTempResource("update");
            boolean selfupdate = this.hasPendingSelfupdate();
            if ((!tmpRoot.exists() || (list = tmpRoot.list()) != null && list.length == 0) && !selfupdate) {
                this.logger.info("Nothing to do. return");
                return;
            }
            List<AWFUpdatePackage> filesToInstall = this.client.getAWFFilesToInstall();
            this.logger.info("AWF Packages pending: " + filesToInstall);
            this.logger.info("SelfUpdate pending: " + selfupdate + " (" + this.selfUpdateClient.getPendingLogList() + ")");
            try {
                if (filesToInstall.size() <= 0 && !selfupdate) break block18;
                if (!doNotAskAgain && this.settings.isDoAskMeBeforeInstallingAnUpdateEnabled()) {
                    try {
                        this.logger.info("Ask to install Updates");
                        DialogHook.showConfirmDialog(0, T.T.confirmdialog_new_update_available_frametitle(), T.T.confirmdialog_new_update_available_for_install_message_launcher(), null, T.T.confirmdialog_new_update_available_answer_now_install(), T.T.confirmdialog_new_update_available_answer_later_install());
                        this.logger.info("User Confirmed");
                    }
                    catch (DialogClosedException e) {
                        this.logger.info("User denied Update Installation");
                        this.setGuiVisible(false, false);
                        return;
                    }
                    catch (DialogCanceledException e) {
                        this.logger.info("User denied Update Installation");
                        this.setGuiVisible(false, false);
                        return;
                    }
                }
                UpdateManager e = this;
                synchronized (e) {
                    Runnable runable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                UpdateManager.this.setGuiVisible(true, true);
                                UpdateManager.this.gui.setText(T.T.installframe_statusmsg_checkselfupdate());
                                UpdateManager.this.logger.info("Waiting for Core.jar");
                                UpdateManager.this.gui.setText(T.T.installframe_statusmsg_waitingforapplication());
                                File core = Application.getResource("Core.jar");
                                Timeout timeout = new Timeout(30000);
                                if (core.exists()) {
                                    UpdateManager.this.gui.setProgress(-1.0);
                                    while (!UpdateManager.this.canMove(core)) {
                                        UpdateManager.this.gui.setText(T.T.installframe_statusmsg_waitingforapplication2(core.getAbsolutePath()));
                                        Thread.sleep(1000L);
                                        if (!timeout.hasTimedOut()) continue;
                                        try {
                                            DialogHook.showConfirmDialog(0, T.T.errordialog_frametitle(), T.T.close_jd(core.getAbsolutePath()), null, null, T.T.lit_cancel_install());
                                            timeout.reset();
                                        }
                                        catch (DialogNoAnswerException e) {
                                            UpdateManager.this.thread = null;
                                            return;
                                        }
                                    }
                                }
                                UpdateManager.this.gui.setText(T.T.installframe_statusmsg_installing());
                                timeout = new Timeout(2000);
                                UpdateManager.this.setGuiVisible(true, true);
                                UpdateManager.this.logger.info("Install AWF Files");
                                UpdateManager.this.defaultHandler.setThreadConfirmed(Thread.currentThread(), true);
                                UpdateManager.this.runUpdateLoop();
                                UpdateManager.this.logger.info("Done");
                                UpdateManager.this.gui.onHead();
                                UpdateManager.this.gui.setText(T.T.installframe_statusmsg_complete());
                                UpdateManager.this.gui.setProgress(100.0);
                                if (!timeout.hasTimedOut()) {
                                    Thread.sleep(timeout.getRemainingTime());
                                }
                            }
                            catch (Exception e) {
                                UpdateManager.this.getHandler().handleException(e);
                            }
                            finally {
                                UpdateManager.this.thread = null;
                            }
                        }
                    };
                    if (Thread.currentThread() instanceof UpdateThread) {
                        runable.run();
                    } else {
                        this.thread = new UpdateThread(runable, "Finish Installer");
                        this.thread.start();
                        this.thread.join();
                    }
                    break block18;
                }
                {
                    catch (InterruptedException e2) {
                        LoggerFactory.getDefaultLogger().log(e2);
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.setGuiVisible(false, false);
            }
        }
    }

    private boolean canMove(final File core) {
        final FileAccessHandler fileSystem = this.getClient().getFileSystem();
        return Boolean.TRUE.equals(new NonInterruptibleRunnableReturn<Boolean>(){

            @Override
            protected Boolean execute() throws InterruptedException {
                try {
                    File tmp = new File(core.getAbsolutePath() + "." + System.currentTimeMillis());
                    fileSystem.moveFile(core, tmp, true);
                    fileSystem.moveFile(tmp, core, false);
                    return true;
                }
                catch (ExtIOException e) {
                    UpdateManager.this.getLogger().log(e);
                    return false;
                }
            }
        }.startAndWait());
    }

    @Override
    public String getAppID() {
        return this.client.getSetup().getApplicationIdentifier();
    }

    public JDUpdateClient getClient() {
        return this.client;
    }

    public Setup getClientSetup() {
        return this.clientSetup;
    }

    private int getDestRevision(UpdateClient client) {
        try {
            if (client.getUpdate() == null) {
                return -1;
            }
            return client.getDestRevision().getId();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public UIInterface getGui() {
        return this.gui;
    }

    @Override
    public Window getGuiFrame() {
        return this.gui.getWindow();
    }

    public UpdateCallbackInterface getHandler() {
        return this.handler.get();
    }

    public String getJarName() {
        try {
            return Application.getJarName(null);
        }
        catch (Exception e) {
            return "JDownloader.jar";
        }
    }

    public long getLatestUpdateCheck() {
        return this.latestUpdateCheck;
    }

    public LaunchState getLaunchState() {
        return this.launchState;
    }

    @Override
    public LogSource getLogger() {
        return this.logger;
    }

    private long getPackageSize(UpdateClient client) {
        try {
            return client.getUpdate().getPackageResponse().getSize();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    @Override
    public List<String> getRequestedInstalls() {
        return new ArrayList<String>(this.client.getExtensionManager().getRequestedInstalls());
    }

    @Override
    public List<String> getRequestedUnInstalls() {
        return new ArrayList<String>(this.client.getExtensionManager().getRequestedUninstalls());
    }

    public UpdateSettings getSettings() {
        return this.settings;
    }

    @Override
    public boolean hasPendingClientUpdates() {
        List<AWFUpdatePackage> lst = this.client.getAWFFilesToInstall();
        return lst != null && lst.size() > 0;
    }

    @Override
    public boolean hasPendingSelfupdate() {
        return this.selfUpdateClient.hasPendingUpdate();
    }

    @Override
    public boolean hasPendingUpdates() {
        return this.hasPendingSelfupdate() || this.hasPendingClientUpdates();
    }

    /*
     * Exception decompiling
     */
    public void installAWFFilesInclRetries(List<AWFUpdatePackage> filesToInstall) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installExtension(String ... parameters) throws InterruptedException {
        UpdateManager updateManager = this;
        synchronized (updateManager) {
            UpdateThread thread = this.thread;
            if (thread != null) {
                ((Thread)thread).interrupt();
            }
            for (String s : parameters) {
                this.client.getExtensionManager().requestInstallation(s);
            }
        }
        this.runUpdateCheck(true);
        this.waitForUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstallLog installPendingAWFFiles() throws InterruptedException, InstallException, ExtIOException {
        long startTime = System.currentTimeMillis();
        try {
            final UpdateClient updater = this.runningSelfupdate ? this.selfUpdateClient : this.client;
            this.gui.startPoll(new PollCallback(){

                @Override
                public void run() {
                    if (updater.isReverting()) {
                        UpdateManager.this.gui.setText(T.T.installframe_statusmsg_reverting());
                        UpdateManager.this.gui.setProgress(100.0 - updater.getModuleProgressValue());
                    } else {
                        UpdateManager.this.gui.setProgress(updater.getModuleProgressValue());
                        if (updater.getModuleProgressValue() == 0.0) {
                            UpdateManager.this.gui.setText(T.T.installframe_statusmsg_prepare());
                        } else if (updater.getModuleProgressValue() == 100.0 || updater.getModuleProgressValue() < 0.0) {
                            UpdateManager.this.gui.setText(T.T.installframe_statusmsg_finalizing());
                        } else {
                            UpdateManager.this.gui.setText(T.T.installframe_statusmsg_installing());
                        }
                    }
                }
            });
            FileAccessHandler fileSystem = updater.getFileSystem();
            List<AWFUpdatePackage> filesToInstall = this.client.getAWFFilesToInstall();
            InstallLog installLog = new InstallLog();
            FileOutputStream fos = null;
            Writer output = null;
            try {
                File logFile = Application.getResource("logs/updatehistory/" + filesToInstall.get(0).getsRev() + "_to_" + filesToInstall.get(filesToInstall.size() - 1).getdRev() + ".log");
                fileSystem.mkdirs(logFile.getParentFile());
                int i = 1;
                while (logFile.exists()) {
                    logFile = Application.getResource("logs/updatehistory/" + filesToInstall.get(0).getsRev() + "_to_" + filesToInstall.get(filesToInstall.size() - 1).getdRev() + "_" + i + ".log");
                    ++i;
                }
                fileSystem.deleteFileIfExists(logFile);
                fileSystem.mkdirs(logFile.getParentFile());
                fos = fileSystem.openFileOutputStream(logFile, false);
                output = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                this.log(output, new Date().toString());
                this.log(output, "\r\n");
                for (AWFUpdatePackage file : filesToInstall) {
                    try {
                        this.log(output, "Package: " + file.getFile().getName() + "\r\n");
                        installLog.getSourcePackages().add(file.getFile().getAbsolutePath());
                        if (file.getFile().length() == 0L) {
                            this.log(output, "Empty Package. (Uninstalled extension)\r\n");
                            this.client.writeSuperRevision(file.getdRev());
                            fileSystem.deleteFileIfExists(file.getFile());
                            continue;
                        }
                        if (file.getdRev() < this.client.readSuperRevision().getId()) {
                            this.log(output, "Ignore Package. It's DRev <= CurrentRev " + this.client.readSuperRevision() + "\r\n");
                            fileSystem.deleteFileIfExists(file.getFile());
                            continue;
                        }
                        PackageResponse dummyResponse = new PackageResponse(file.getdRev(), null, file.getFile().length(), file.getFile().length(), file.isEncrypted(), null);
                        Pkg pkg = new Pkg(this.client, dummyResponse);
                        this.client.setUpdate(pkg);
                        this.log(output, "Install\r\n");
                        this.client.runPackageInstallation(file.getFile(), file.isExtracted());
                        this.log(output, "Write Revision: " + file.getdRev() + "\r\n");
                        this.client.writeSuperRevision(file.getdRev());
                        installLog.merge(this.client.getInstallLog());
                        HashSet<String> set = new HashSet<String>();
                        this.log(output, "----------------Plugins----------------\r\n");
                        for (String s : this.sortedList(this.client.getInstallLog().getModifiedPlugins())) {
                            set.add(s);
                            this.log(output, "   " + s + "\r\n");
                        }
                        this.log(output, "----------------Extensions----------------\r\n");
                        for (String s : this.sortedList(this.client.getInstallLog().getModifiedExtensionFiles())) {
                            set.add(s);
                            this.log(output, "   " + s + "\r\n");
                        }
                        this.log(output, "----------------Direct Files----------------\r\n");
                        for (String s : this.sortedList(this.client.getInstallLog().getModifiedDirects())) {
                            set.add(s);
                            this.log(output, "   " + s + "\r\n");
                        }
                        this.log(output, "----------------Core Files----------------\r\n");
                        for (String s : this.sortedList(this.client.getInstallLog().getModifiedFiles())) {
                            if (!set.add(s)) continue;
                            this.log(output, "   " + s + "\r\n");
                        }
                    }
                    catch (InstallException e) {
                        this.log(output, "----------------Exception!----------------\r\n");
                        this.log(output, Exceptions.getStackTrace(e));
                        try {
                            if (Exceptions.getInstanceof(e, JarMergeException.class) != null || Exceptions.getInstanceof(e, DeduplicationException.class) != null || Exceptions.getInstanceof(e, SignatureViolationException.class) != null) {
                                this.deleteAllAwfs();
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        throw e;
                    }
                }
                this.checkInstallLogForCacheInvalidation(installLog);
                this.deleteAllAwfs();
            }
            catch (IOException e) {
                throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
            }
            finally {
                try {
                    output.close();
                }
                catch (Throwable throwable) {}
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
            this.addInstallLog(installLog);
            this.gui.stopPoll();
            long wait = 2000L - (System.currentTimeMillis() - startTime);
            if (this.isUpdateOnExitFlag()) {
                wait = this.getSettings().getCountdownForInstallUpdatesOnExitBubble();
            }
            long endsAt = System.currentTimeMillis() + wait;
            while (endsAt > System.currentTimeMillis()) {
                long interval = Math.min(endsAt - System.currentTimeMillis(), 1000L);
                if (interval > 0L) {
                    Thread.sleep(interval);
                }
                this.getGui().setText(T.T.update_done_close_in_TIME(TimeFormatter.formatMilliSeconds(Math.max(0L, endsAt - System.currentTimeMillis()), 0)));
            }
            InstallLog installLog2 = installLog;
            return installLog2;
        }
        finally {
            this.gui.stopPoll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InstallLog> clearInstallLogs() {
        List<InstallLog> list = this.installLogs;
        synchronized (list) {
            List<InstallLog> ret = Collections.unmodifiableList(new ArrayList<InstallLog>(this.installLogs));
            this.installLogs.clear();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InstallLog> getInstallLogs() {
        List<InstallLog> list = this.installLogs;
        synchronized (list) {
            return Collections.unmodifiableList(this.installLogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstallLog(InstallLog installLog) {
        List<InstallLog> list = this.installLogs;
        synchronized (list) {
            this.installLogs.add(installLog);
        }
    }

    private void log(Writer output, String msg) throws IOException {
        this.logger.info(msg);
        output.write(msg);
    }

    private void checkInstallLogForCacheInvalidation(InstallLog installLog) throws IOException {
        final JDUpdateClient client = this.getClient();
        if (installLog.getModifiedExtensionFiles().size() > 0) {
            final StringBuilder sb = new StringBuilder();
            for (String p : installLog.getModifiedExtensionFiles()) {
                sb.append("\r\n");
                sb.append(p);
            }
            new NonInterruptibleRunnableException<ExtIOException>(){

                @Override
                protected void execute() throws ExtIOException, InterruptedException {
                    File file = Application.getTempResource("invalidextensions");
                    client.getFileSystem().writeToFile(file, sb.toString().getBytes(UpdateClient.UTF8), true);
                }
            }.startAndWait();
        }
        if (installLog.getModifiedPlugins().size() > 0) {
            HashSet<String> updateLastModified = new HashSet<String>();
            for (String path : installLog.getModifiedPlugins()) {
                if (!StringUtils.startsWithCaseInsensitive(path, "jd/plugins")) continue;
                try {
                    String parent;
                    AbsoluteFile file = client.convertRelPath(path);
                    if (!file.isFile() || !updateLastModified.add(parent = file.getParent())) continue;
                    this.getLogger().info("Invalidate plugin cache, update last modified:" + parent + "|" + new File(parent).setLastModified(System.currentTimeMillis()));
                }
                catch (InstallException installException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installPendingUpdates(final InstallLog log) {
        UpdateManager updateManager = this;
        synchronized (updateManager) {
            this.enabled = false;
            try {
                Runnable runable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (UpdateManager.this.hasPendingSelfupdate()) {
                                UpdateManager.this.runFinishSelfUpdate();
                            } else if (log.getModifiedFiles().size() > 0 || log.getSourcePackages().size() > 0) {
                                if (log.getModifiedRestartRequiredFiles().size() > 0) {
                                    RestartController.getInstance().directRestart(new ForcedRestartRequest("-update"));
                                } else {
                                    UpdateManager.this.logger.info(JSonStorage.toString(log));
                                    UpdateManager.this.installAWFFilesInclRetries(UpdateManager.this.client.getAWFFilesToInstall());
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!UpdateManager.this.getHandler().handleException(e)) {
                                UpdateManager.this.runDefaultExceptionHandler(e);
                            }
                        }
                        finally {
                            UpdateManager.this.getHandler().setRunning(false);
                            UpdateManager.this.thread = null;
                        }
                    }
                };
                if (Thread.currentThread() instanceof UpdateThread) {
                    runable.run();
                } else {
                    if (this.thread != null) {
                        throw new WTFException("SOS");
                    }
                    this.thread = new UpdateThread(runable, "UpdaterInstaller");
                    this.thread.start();
                }
            }
            finally {
                this.enabled = true;
            }
        }
    }

    @Override
    public boolean isExtensionInstalled(String id) {
        return this.client.getExtensionManager().isInstalled(id);
    }

    @Override
    public boolean isGuiVisible() {
        return this.gui.isVisible();
    }

    public void lastChance(Exception e1) {
        LastChanceManager.getInstance().run();
    }

    protected long max(long client, long self) {
        if (this.runningClientupdate && this.runningSelfupdate) {
            return Math.max(client, self);
        }
        if (this.runningClientupdate) {
            return client;
        }
        if (this.runningSelfupdate) {
            return self;
        }
        return -1L;
    }

    public void onCanceledByUser() {
        UpdateThread thread = this.thread;
        if (thread != null && thread.isAlive()) {
            ((Thread)thread).interrupt();
        } else {
            this.setGuiVisible(false, false);
        }
    }

    public void onSelfUpdateSuccessful() throws ExtIOException, InterruptedException {
        this.selfUpdateClient.onSelfUpdateSuccessful();
    }

    public void runDefaultExceptionHandler(Exception e) {
        this.defaultHandler.handleException(e);
    }

    public Process runExeAsynch(List<String> call, File root) throws IOException {
        return this.getHandler().runExeAsynch(call, root);
    }

    public void runFinishSelfUpdate() throws SelfUpdateException, InterruptedException {
        this.gui.setIcon(null);
        this.gui.setText(T.T.installframe_statusmsg_selfupdate_validating());
        this.gui.setProgress(-1.0);
        try {
            this.selfUpdateClient.finishSelfUpdate();
        }
        catch (SelfUpdateException e) {
            try {
                this.selfUpdateClient.cleanupTmp();
            }
            catch (ExtIOException e1) {
                this.logger.log(e1);
            }
            throw e;
        }
        this.setGuiVisible(false, false);
    }

    public void runStartUpCheck() {
        if (this.settings.isAutoUpdateCheckEnabled()) {
            this.runUpdateCheck(false);
        } else {
            this.logger.info("Auto UpdateCheck is Disabled");
        }
    }

    @Override
    public void runUpdateCheck(boolean manually) {
        if (!manually && !this.settings.isAutoUpdateCheckEnabled()) {
            System.out.println("No Update. Auto Update is disabled");
            return;
        }
        this.startUpdate(new PendingUpdate(this, manually, this.settings.isJarDiffEnabled()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runUpdateLoop() throws InterruptedException, IOException, TransportException, PackageCreateException, InstallException, URISyntaxException, ServerLockedException, InvalidKeySpecException, NoSuchAlgorithmException, SelfUpdateException, LastChanceException, CanceledException, ProxySelectorException {
        if (!this.getHandler().doContinueLoopStarted()) {
            throw new CanceledException();
        }
        try {
            this.gui.setIcon(null);
            this.gui.setCancelText(T.T.literally_cancel());
            this.gui.setText(T.T.installframe_statusmsg_findupdates());
            this.gui.setProgress(3.0);
            try {
                this.client.setUpdate(null);
                this.selfUpdateClient.setUpdate(null);
                this.client.forceDestRevision(-1);
                this.gui.setProgress(-1.0);
                int clientSrcRevision = this.client.readRevision().getId();
                this.clientSuperRevision.set(this.client.readSuperRevision().getId());
                this.selfUpdaterRevision.set(this.selfUpdateClient.readRevision().getId());
                int selfUpdateSrcRevision = this.selfUpdaterRevision.get();
                this.selfUpdaterSuperRevision.set(this.selfUpdateClient.superReadRevision().getId());
                try {
                    this.client.setUpdaterCheckEnabled(true);
                    this.gui.setText(T.T.installframe_statusmsg_connecting_to_server());
                    this.client.runUpdateCheck();
                }
                finally {
                    this.client.setUpdaterCheckEnabled(false);
                    this.gui.setText(T.T.installframe_statusmsg_findupdates());
                }
                if (this.client.getUpdate() != null && this.client.getUpdate().getResponseStatus() == ResponseStatus.SELFUPDATE) {
                    this.selfUpdateClient.getModuleProgress().reset();
                    this.selfUpdateClient.getModuleProgress().setStepVolume(0.06);
                    this.selfUpdateClient.getModuleProgress().fillStep();
                    this.gui.setText(T.T.installframe_statusmsg_selfupdate());
                    this.selfUpdateClient.runUpdateCheck();
                    this.client.runUpdateCheck();
                }
                this.updateRunningVariables();
                try {
                    File extracted;
                    if (!this.runningSelfupdate && !this.runningClientupdate) {
                        try {
                            this.getHandler().onResults(this.runningClientupdate, this.runningSelfupdate, clientSrcRevision, this.getDestRevision(this.client), selfUpdateSrcRevision, this.getDestRevision(this.selfUpdateClient), this.packageAWFFile, this.packageAWFSelfupdateFile, this.selfUpdateClient.getWorkingDirectory(), this.getLaunchState() != LaunchState.START);
                            return;
                        }
                        catch (Exception e) {
                            if (e instanceof InstallException) {
                                throw (InstallException)e;
                            }
                            if (!(e instanceof SelfUpdateException)) throw new InstallException(null, (Throwable)e);
                            try {
                                this.selfUpdateClient.cleanupTmp();
                                throw (SelfUpdateException)e;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw (SelfUpdateException)e;
                        }
                    }
                    this.gui.setProgress(5.0);
                    this.client.getModuleProgress().reset();
                    this.client.getModuleProgress().setStepVolume(0.05);
                    this.client.getModuleProgress().fillStep();
                    if (!this.getHandler().doContinueUpdateAvailable(this.runningClientupdate, this.runningSelfupdate, this.getPackageSize(this.client), this.getPackageSize(this.selfUpdateClient), clientSrcRevision, selfUpdateSrcRevision, this.getDestRevision(this.client), this.getDestRevision(this.selfUpdateClient))) {
                        throw new CanceledException();
                    }
                    this.gui.setText(T.T.installframe_statusmsg_preparing());
                    this.gui.setProgress(-1.0);
                    this.gui.setIcon(null);
                    this.logger.info("Create Packages");
                    this.gui.startPoll(new PollCallback(){
                        long eta = -1L;
                        boolean started = false;

                        @Override
                        public void run() {
                            if (UpdateManager.this.client.getModuleProgressValue() > 5.0 || UpdateManager.this.selfUpdateClient.getModuleProgressValue() > 5.0) {
                                WaitResponseInterface swr;
                                double minP = Math.min(UpdateManager.this.client.getModuleProgressValue(), UpdateManager.this.selfUpdateClient.getModuleProgressValue());
                                if (!UpdateManager.this.runningClientupdate) {
                                    minP = UpdateManager.this.selfUpdateClient.getModuleProgressValue();
                                } else if (!UpdateManager.this.runningSelfupdate) {
                                    minP = UpdateManager.this.client.getModuleProgressValue();
                                }
                                UpdateManager.this.gui.setProgress(minP);
                                UpdateManager.this.gui.setText(T.T.installframe_statusmsg_preparing());
                                WaitResponseInterface cwr = UpdateManager.this.client.getUpdate() == null ? null : UpdateManager.this.client.getUpdate().getWaitResponse();
                                WaitResponseInterface waitResponseInterface = swr = UpdateManager.this.selfUpdateClient.getUpdate() == null ? null : UpdateManager.this.selfUpdateClient.getUpdate().getWaitResponse();
                                if (cwr != null || swr != null) {
                                    long biggestETA = -1L;
                                    if (cwr != null) {
                                        biggestETA = cwr.getEta();
                                    }
                                    if (swr != null && swr.getEta() > biggestETA) {
                                        biggestETA = swr.getEta();
                                    }
                                    if (this.eta < 0L) {
                                        this.eta = biggestETA;
                                    }
                                    if (biggestETA < this.eta || this.eta > 10000L) {
                                        this.started = true;
                                    }
                                    if (this.started) {
                                        System.out.println(biggestETA / 1000L);
                                        UpdateManager.this.gui.setText(T.T.installframe_statusmsg_preparing() + "\r\n" + T.T.installframe_statusmsg_preparing_eta(TimeFormatter.formatSeconds(biggestETA / 1000L, 0)));
                                    }
                                }
                            }
                        }
                    });
                    try {
                        SelfRunner th = null;
                        if (this.runningSelfupdate) {
                            th = new SelfRunner("SelfUpdatePackageCreator"){

                                @Override
                                public void runit() throws ExtIOException, InterruptedException, TransportException, PackageCreateException, ServerLockedException, LastChanceException, InstallException {
                                    UpdateManager.this.selfUpdateClient.getModuleProgress().setIndeterminated(true);
                                    UpdateManager.this.selfUpdateClient.createPackage();
                                }
                            };
                            th.start();
                        }
                        if (this.runningClientupdate) {
                            this.client.getModuleProgress().setIndeterminated(true);
                            this.client.createPackage();
                        }
                        if (th != null) {
                            th.waitForIt();
                        }
                    }
                    finally {
                        this.gui.stopPoll();
                    }
                    this.updateRunningVariables();
                    if (!this.runningSelfupdate && !this.runningClientupdate) {
                        try {
                            this.getHandler().onResults(this.runningClientupdate, this.runningSelfupdate, clientSrcRevision, this.getDestRevision(this.client), selfUpdateSrcRevision, this.getDestRevision(this.selfUpdateClient), this.packageAWFFile, this.packageAWFSelfupdateFile, this.selfUpdateClient.getWorkingDirectory(), this.getLaunchState() != LaunchState.START);
                            return;
                        }
                        catch (Exception e) {
                            if (e instanceof InstallException) {
                                throw (InstallException)e;
                            }
                            if (!(e instanceof SelfUpdateException)) throw new InstallException(null, (Throwable)e);
                            throw (SelfUpdateException)e;
                        }
                    }
                    if (!this.getHandler().doContinuePackageAvailable(this.runningClientupdate, this.runningSelfupdate, this.getPackageSize(this.client), this.getPackageSize(this.selfUpdateClient), clientSrcRevision, selfUpdateSrcRevision, this.getDestRevision(this.client), this.getDestRevision(this.selfUpdateClient))) {
                        throw new CanceledException();
                    }
                    this.gui.setText(T.T.installframe_statusmsg_download());
                    this.logger.info("Download Packages");
                    this.gui.startPoll(new PollCallback(){

                        @Override
                        public void run() {
                            UpdateManager.this.gui.setProgress(UpdateManager.this.avg(UpdateManager.this.client.getModuleProgressValue(), UpdateManager.this.selfUpdateClient.getModuleProgressValue()));
                            long speed = UpdateManager.this.sum(UpdateManager.this.client.getDownloadSpeedBps(), UpdateManager.this.selfUpdateClient.getDownloadSpeedBps());
                            if (speed >= 0L) {
                                long deat = UpdateManager.this.max(UpdateManager.this.client.getDownloadETA(), UpdateManager.this.selfUpdateClient.getDownloadETA());
                                String timeleft = TimeFormatter.formatSeconds(deat, 0);
                                if (deat < 0L) {
                                    timeleft = T.T.literally_unknown();
                                }
                                UpdateManager.this.gui.setText(T.T.installframe_statusmsg_downloadspeed(SizeFormatter.formatBytes(speed), timeleft));
                            } else {
                                UpdateManager.this.gui.setText(T.T.installframe_statusmsg_download());
                            }
                        }
                    });
                    final AtomicReference packageFileReferenceSelfUpdate = new AtomicReference();
                    AtomicReference<File> packageFileReference = new AtomicReference<File>();
                    try {
                        SelfRunner th;
                        if (this.runningSelfupdate) {
                            th = new SelfRunner("SelfUpdateDownloader"){

                                @Override
                                public void runit() throws InterruptedException, TransportException, PackageCreateException, InstallException, IOException, URISyntaxException, ServerLockedException, LastChanceException, ProxySelectorException {
                                    packageFileReferenceSelfUpdate.set(UpdateManager.this.selfUpdateClient.runPackageDownload());
                                }
                            };
                            th.start();
                        } else {
                            th = null;
                        }
                        if (this.runningClientupdate) {
                            packageFileReference.set(this.client.runPackageDownload());
                        }
                        if (th != null) {
                            th.waitForIt();
                        }
                    }
                    finally {
                        this.gui.stopPoll();
                    }
                    File packageFileSelfUpdate = (File)packageFileReferenceSelfUpdate.get();
                    File packageFile = (File)packageFileReference.get();
                    this.updateRunningVariables();
                    if (packageFile == null && packageFileSelfUpdate == null) {
                        if (this.runningSelfupdate) throw new InstallException(null, "Could not Update");
                        if (this.runningClientupdate) throw new InstallException(null, "Could not Update");
                        try {
                            this.getHandler().onResults(this.runningClientupdate, this.runningSelfupdate, clientSrcRevision, this.getDestRevision(this.client), selfUpdateSrcRevision, this.getDestRevision(this.selfUpdateClient), this.packageAWFFile, this.packageAWFSelfupdateFile, this.selfUpdateClient.getWorkingDirectory(), this.getLaunchState() != LaunchState.START);
                            return;
                        }
                        catch (Exception e) {
                            if (e instanceof InstallException) {
                                throw (InstallException)e;
                            }
                            if (!(e instanceof SelfUpdateException)) throw new InstallException(null, (Throwable)e);
                            throw (SelfUpdateException)e;
                        }
                    }
                    if (!this.getHandler().doContinueReadyForExtracting(this.runningClientupdate, this.runningSelfupdate, packageFile, packageFileSelfUpdate)) {
                        throw new CanceledException();
                    }
                    this.gui.setText(T.T.confirmdialog_new_update_available_frametitle());
                    this.packageAWFFile = null;
                    this.packageAWFSelfupdateFile = null;
                    if (this.runningSelfupdate) {
                        File src;
                        extracted = packageFileSelfUpdate;
                        try {
                            src = this.selfUpdateClient.getDownloadPackageInfoFile(packageFileSelfUpdate);
                            if (!src.isFile()) {
                                // empty if block
                            }
                        }
                        catch (Throwable e) {
                            this.getLogger().log(e);
                        }
                        try {
                            src = this.selfUpdateClient.getPackageInstallationHistoryFile(packageFileSelfUpdate);
                            if (!src.isFile()) {
                                // empty if block
                            }
                        }
                        catch (Throwable e) {
                            this.getLogger().log(e);
                        }
                        this.packageAWFSelfupdateFile = extracted;
                    }
                    if (this.runningClientupdate) {
                        File dest;
                        File src;
                        extracted = packageFile;
                        File dst = Application.getTempResource("update/package_" + System.currentTimeMillis() + ".awf");
                        while (dst.exists()) {
                            dst = Application.getTempResource("update/package_" + System.currentTimeMillis() + ".awf");
                        }
                        File info = new File(dst.getAbsolutePath() + ".info");
                        Pkg pkg = this.client.getUpdate();
                        Info infoData = new Info();
                        infoData.setExtracted(false);
                        infoData.setAppID(this.client.getSetup().getApplicationIdentifier());
                        infoData.setDestRevision(this.getDestRevision(this.client));
                        infoData.setSourceRevision(pkg.getRevUrlParameter());
                        PackageResponseInterface pkgResponse = pkg.getPackageResponse();
                        if (pkgResponse != null) {
                            infoData.setEncrypted(pkgResponse.isEncrypted());
                        }
                        infoData.setTimestamp(System.currentTimeMillis());
                        infoData.setInstalledExtensions(new ArrayList<String>(pkg.getEidList()));
                        infoData.setInstallExtensions(new ArrayList<String>(pkg.getEipList()));
                        infoData.setUninstallExtensions(new ArrayList<String>(pkg.getEirList()));
                        infoData.setFile(dst.getName());
                        FileAccessHandler fileSystem = this.getClient().getFileSystem();
                        fileSystem.mkdirs(dst.getParentFile());
                        fileSystem.moveFile(extracted, dst, true);
                        try {
                            src = this.client.getDownloadPackageInfoFile(packageFile);
                            if (src.isFile()) {
                                dest = this.client.getDownloadPackageInfoFile(dst);
                                this.client.getFileSystem().moveFile(src, dest, true);
                            }
                        }
                        catch (Throwable e) {
                            this.getLogger().log(e);
                        }
                        try {
                            src = this.client.getPackageInstallationHistoryFile(packageFile);
                            if (src.isFile()) {
                                dest = this.client.getPackageInstallationHistoryFile(dst);
                                this.client.getFileSystem().moveFile(src, dest, true);
                            }
                        }
                        catch (Throwable e) {
                            this.getLogger().log(e);
                        }
                        fileSystem.secureWrite(info, JSonStorage.serializeToJson(infoData).getBytes(UpdateClient.UTF8), true);
                        this.getClient().deleteFileOrFolderRecursive(Application.getTempResource("update/" + this.client.getSetup().getApplicationIdentifier()), null, true);
                        this.packageAWFFile = dst;
                    }
                    this.updateRunningVariables();
                    if (this.runningSelfupdate) {
                        try {
                            this.gui.startPoll(new PollCallback(){

                                @Override
                                public void run() {
                                    SelfUpdateClient updater = UpdateManager.this.selfUpdateClient;
                                    if (updater.isReverting()) {
                                        UpdateManager.this.gui.setText(T.T.installframe_statusmsg_reverting());
                                        UpdateManager.this.gui.setProgress(100.0 - updater.getModuleProgressValue());
                                    } else {
                                        UpdateManager.this.gui.setProgress(updater.getModuleProgressValue());
                                        if (updater.getModuleProgressValue() == 0.0) {
                                            UpdateManager.this.gui.setText(T.T.installframe_statusmsg_prepare());
                                        } else if (updater.getModuleProgressValue() == 100.0 || updater.getModuleProgressValue() < 0.0) {
                                            UpdateManager.this.gui.setText(T.T.installframe_statusmsg_finalizing());
                                        } else {
                                            UpdateManager.this.gui.setText(T.T.installframe_statusmsg_installing());
                                        }
                                    }
                                }
                            });
                            this.selfUpdateClient.runPackageInstallation(this.packageAWFSelfupdateFile, false);
                            this.selfUpdateClient.deleteFileOrFolderRecursive(Application.getTempResource("update/" + this.selfUpdateClient.getSetup().getApplicationIdentifier()), null, true);
                            this.selfUpdateClient.getFileSystem().deleteFileIfExists(this.packageAWFSelfupdateFile);
                        }
                        finally {
                            this.gui.stopPoll();
                        }
                    }
                    try {
                        this.getHandler().onResults(this.runningClientupdate, this.runningSelfupdate, clientSrcRevision, this.getDestRevision(this.client), selfUpdateSrcRevision, this.getDestRevision(this.selfUpdateClient), this.packageAWFFile, this.packageAWFSelfupdateFile, this.selfUpdateClient.getWorkingDirectory(), this.getLaunchState() != LaunchState.START);
                        return;
                    }
                    catch (Exception e) {
                        if (e instanceof InstallException) {
                            throw (InstallException)e;
                        }
                        if (!(e instanceof SelfUpdateException)) throw new InstallException(null, (Throwable)e);
                        throw (SelfUpdateException)e;
                    }
                }
                catch (InstallException e) {
                    UpdateClient exceptionClient = e.getUpdateClient();
                    if (exceptionClient == null) throw e;
                    UpdateOptions retryOptions = exceptionClient.retry(e);
                    if (retryOptions == null) throw e;
                    exceptionClient.setUpdateOptions(retryOptions);
                    try {
                        this.deleteAllAwfs();
                        this.runUpdateLoop();
                        return;
                    }
                    catch (NullPointerException e1) {
                        this.getLogger().log(e1);
                    }
                    throw e;
                }
            }
            catch (InterruptedException e) {
                this.gui.setProgress(0.0);
                this.gui.setText(T.T.installframe_statusmsg_interrupted());
                this.setGuiVisible(false, true);
                throw e;
            }
        }
        catch (CanceledException e) {
            this.setGuiVisible(false, true);
            throw e;
        }
    }

    @Override
    public void setGuiFinished(final String message) {
        if (Application.isHeadless()) {
            return;
        }
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                UpdateManager.this.gui.onHead();
                UpdateManager.this.gui.setText(message == null ? T.T.guiless_you_are_up2date() : message);
                UpdateManager.this.gui.setProgress(100.0);
            }
        };
    }

    @Override
    public void setGuiVisible(final boolean b, final boolean toFront) {
        if (Application.isHeadless()) {
            return;
        }
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                boolean old = UpdateManager.this.gui.isVisible();
                UpdateManager.this.gui.setVisible(b);
                if (toFront) {
                    UpdateManager.this.gui.toFront();
                    UpdateManager.this.gui.setExtendedState(0);
                }
                if (old != b) {
                    UpdateManager.this.getHandler().onGuiVisibilityChanged(UpdateManager.this.gui.getWindow(), old, b);
                }
            }
        };
    }

    public synchronized void setHandler(final UpdateCallbackInterface callback) {
        UpdateCallbackInterface previousHandler;
        if (callback == null || callback == this.defaultHandler) {
            previousHandler = this.handler.getAndSet(this.defaultHandler);
            if (previousHandler == this.defaultHandler) {
                return;
            }
        } else {
            previousHandler = this.handler.getAndSet(new UpdateCallbackInterface(){
                private Boolean isRunning = null;

                @Override
                public HTTPProxy updateProxyAuth(int retries, HTTPProxy usedProxy, List<String> proxyAuths, URL url) {
                    try {
                        return callback.updateProxyAuth(retries, usedProxy, proxyAuths, url);
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        return UpdateManager.this.defaultHandler.updateProxyAuth(retries, usedProxy, proxyAuths, url);
                    }
                }

                @Override
                public void updateGuiText(String icon) {
                    try {
                        callback.updateGuiText(icon);
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        UpdateManager.this.defaultHandler.updateGuiText(icon);
                    }
                }

                @Override
                public void updateGuiProgress(double progress) {
                    try {
                        callback.updateGuiProgress(progress);
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        UpdateManager.this.defaultHandler.updateGuiProgress(progress);
                    }
                }

                @Override
                public void updateGuiIcon(ImageIcon icon) {
                    try {
                        callback.updateGuiIcon(icon);
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        UpdateManager.this.defaultHandler.updateGuiIcon(icon);
                    }
                }

                @Override
                public void setRunning(boolean b) {
                    try {
                        this.isRunning = b;
                        callback.setRunning(b);
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        UpdateManager.this.defaultHandler.setRunning(b);
                    }
                }

                @Override
                public List<HTTPProxy> selectProxy(URL url) {
                    try {
                        return callback.selectProxy(url);
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        return UpdateManager.this.defaultHandler.selectProxy(url);
                    }
                }

                @Override
                public Process runExeAsynch(List<String> call, File root) throws IOException {
                    try {
                        return callback.runExeAsynch(call, root);
                    }
                    catch (Throwable e2) {
                        UpdateManager.this.logger.log(e2);
                        return UpdateManager.this.defaultHandler.runExeAsynch(call, root);
                    }
                }

                @Override
                public void onResults(boolean app, boolean updater, int clientRevision, int clientDestRevision, int selfRevision, int selfDestRevision, File clientAWF, File selfAWF, File selfWOrkingDir, boolean jdLaunched) throws InterruptedException, IOException, Exception {
                    try {
                        callback.onResults(app, updater, clientRevision, clientDestRevision, selfRevision, selfDestRevision, clientAWF, selfAWF, selfWOrkingDir, jdLaunched);
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        UpdateManager.this.defaultHandler.onResults(app, updater, clientRevision, clientDestRevision, selfRevision, selfDestRevision, clientAWF, selfAWF, selfWOrkingDir, jdLaunched);
                    }
                }

                @Override
                public void onGuiVisibilityChanged(Window window, boolean oldValue, boolean newValue) {
                    try {
                        callback.onGuiVisibilityChanged(window, oldValue, newValue);
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        UpdateManager.this.defaultHandler.onGuiVisibilityChanged(window, oldValue, newValue);
                    }
                }

                @Override
                public boolean isRunning() {
                    try {
                        if (this.isRunning != null) {
                            return this.isRunning;
                        }
                        return callback.isRunning();
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        return UpdateManager.this.defaultHandler.isRunning();
                    }
                }

                @Override
                public boolean handleException(Exception e) {
                    try {
                        return callback.handleException(e);
                    }
                    catch (Throwable e2) {
                        UpdateManager.this.logger.log(e2);
                        return UpdateManager.this.defaultHandler.handleException(e);
                    }
                }

                @Override
                public Locator getGuiLocator() {
                    try {
                        return callback.getGuiLocator();
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        return UpdateManager.this.defaultHandler.getGuiLocator();
                    }
                }

                @Override
                public boolean doContinueUpdateAvailable(boolean app, boolean updater, long appDownloadSize, long updaterDownloadSize, int appRevision, int updaterRevision, int appDestRevision, int updaterDestRevision) {
                    try {
                        return callback.doContinueUpdateAvailable(app, updater, appDownloadSize, updaterDownloadSize, appRevision, updaterRevision, appDestRevision, updaterDestRevision);
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        return UpdateManager.this.defaultHandler.doContinueUpdateAvailable(app, updater, appDownloadSize, updaterDownloadSize, appRevision, updaterRevision, appDestRevision, updaterDestRevision);
                    }
                }

                @Override
                public boolean doContinueReadyForExtracting(boolean app, boolean updater, File appFile, File updaterFile) {
                    try {
                        return callback.doContinueReadyForExtracting(app, updater, appFile, updaterFile);
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        return UpdateManager.this.defaultHandler.doContinueReadyForExtracting(app, updater, appFile, updaterFile);
                    }
                }

                @Override
                public boolean doContinuePackageAvailable(boolean app, boolean updater, long appDownloadSize, long updaterDownloadSize, int appRevision, int updaterRevision, int appDestRevision, int updaterDestRevision) {
                    try {
                        return callback.doContinuePackageAvailable(app, updater, appDownloadSize, updaterDownloadSize, appRevision, updaterRevision, appDestRevision, updaterDestRevision);
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        return UpdateManager.this.defaultHandler.doContinuePackageAvailable(app, updater, appDownloadSize, updaterDownloadSize, appRevision, updaterRevision, appDestRevision, updaterDestRevision);
                    }
                }

                @Override
                public boolean doContinueLoopStarted() {
                    try {
                        return callback.doContinueLoopStarted();
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        return UpdateManager.this.defaultHandler.doContinueLoopStarted();
                    }
                }

                @Override
                public void append(StringBuilder sb) {
                    try {
                        callback.append(sb);
                    }
                    catch (Throwable e) {
                        UpdateManager.this.logger.log(e);
                        UpdateManager.this.defaultHandler.append(sb);
                    }
                }
            });
        }
        if (previousHandler != null && previousHandler.isRunning()) {
            this.handler.get().setRunning(true);
        }
    }

    public void setLaunchState(LaunchState state) {
        this.getLogger().info("Launchstate: " + (Object)((Object)state));
        this.launchState = state;
        this.client.setLaunchState(state);
    }

    private List<String> sortedList(Collection<String> modifiedPlugins) {
        ArrayList<String> ret = new ArrayList<String>(modifiedPlugins);
        Collections.sort(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(File root, File dest, String ... args) throws IOException {
        try {
            RestartController.getInstance().setRoot(root);
            RestartController.getInstance().directRestart(new ForcedRestartRequest(args));
        }
        finally {
            RestartController.getInstance().setRoot(null);
        }
    }

    @Override
    public void startIntervalChecker() {
        this.intervalChecker = new Thread("UpdateChecker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                long updateInterval;
                if (Application.isHeadless()) {
                    updateInterval = Math.max(3600000L, UpdateManager.this.settings.getUpdateInterval());
                    UpdateManager.this.logger.info("JDownloader running in headless mode: force UpdateInterval to minimum 1 hour to enable device to go to standby/hibernate: " + TimeFormatter.formatMilliSeconds(updateInterval, 0));
                } else {
                    updateInterval = UpdateManager.this.settings.getUpdateInterval();
                }
                try {
                    if (UpdateManager.this.intervalChecker == null) {
                        return;
                    }
                    while (true) {
                        long timeToNextUpdate = updateInterval - System.currentTimeMillis() + UpdateManager.this.latestUpdateCheck;
                        Thread.sleep(Math.max(100L, timeToNextUpdate));
                        22 var5_4 = this;
                        synchronized (var5_4) {
                            if (System.currentTimeMillis() - UpdateManager.this.latestUpdateCheck > updateInterval) {
                                if (UpdateManager.this.settings.isAutoUpdateCheckEnabled()) {
                                    if (UpdateManager.this.intervalChecker == null) {
                                        return;
                                    }
                                    UpdateManager.this.startUpdate(new PendingUpdate(UpdateManager.this, false, UpdateManager.this.settings.isJarDiffEnabled()));
                                    Thread.sleep(10000L);
                                } else {
                                    Thread.sleep(10000L);
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    LoggerFactory.getDefaultLogger().log(e);
                    return;
                }
            }
        };
        this.intervalChecker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUpdate(final PendingUpdate runnable) {
        Runnable runable = new Runnable(){

            @Override
            public void run() {
                try {
                    UpdateManager.this.getHandler().setRunning(true);
                    UpdateManager.this.latestUpdateCheck = System.currentTimeMillis();
                    runnable.run();
                }
                finally {
                    UpdateManager.this.getHandler().setRunning(false);
                    UpdateManager.this.thread = null;
                }
            }
        };
        UpdateManager updateManager = this;
        synchronized (updateManager) {
            if (Thread.currentThread() instanceof UpdateThread) {
                System.out.println("Start Update");
                runable.run();
            } else {
                if (!this.enabled) {
                    return;
                }
                if (this.thread != null) {
                    return;
                }
                System.out.println("Start Update");
                this.thread = new UpdateThread(runable, "Updater");
                this.thread.start();
            }
        }
    }

    protected long sum(long client, long self) {
        if (this.runningClientupdate && this.runningSelfupdate) {
            return client + self;
        }
        if (this.runningClientupdate) {
            return client;
        }
        if (this.runningSelfupdate) {
            return self;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallExtension(String ... parameters) throws InterruptedException {
        UpdateManager updateManager = this;
        synchronized (updateManager) {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            for (String s : parameters) {
                this.client.getExtensionManager().requestUninstallation(s);
            }
            this.runUpdateCheck(true);
        }
        this.waitForUpdate();
    }

    private void updateRunningVariables() {
        try {
            this.runningSelfupdate = !this.selfUpdateClient.isAtHead();
        }
        catch (IllegalStateException e) {
            this.runningSelfupdate = false;
        }
        try {
            this.runningClientupdate = !this.client.isAtHead();
        }
        catch (IllegalStateException e) {
            this.runningClientupdate = false;
        }
    }

    @Override
    public void waitForUpdate() throws InterruptedException {
        UpdateThread thread = this.thread;
        if (thread != null) {
            thread.join();
        }
    }

    @Override
    public void stopIntervalChecker() {
        Thread intervalChecker = this.intervalChecker;
        if (intervalChecker != null) {
            intervalChecker.interrupt();
            this.intervalChecker = null;
        }
    }

    public void setRestartEnabled(boolean b) {
        this.restartEnabled = b;
    }

    public boolean isRestartEnabled() {
        return this.restartEnabled;
    }

    public void setForceUpdateFlag(boolean b) {
        this.forceUpdateFlag = b;
    }

    public boolean isForceUpdateFlag() {
        return this.forceUpdateFlag;
    }

    public void setUpdateOnExitFlag(boolean b) {
        if (b != this.updateOnExitFlag) {
            this.updateOnExitFlag = b;
            if (!b) {
                this.defaultHandler.setDoNotAsk(false);
                this.gui = this.createGui();
            }
        }
    }

    public boolean isUpdateOnExitFlag() {
        return this.updateOnExitFlag;
    }

    public HTTPProxy updateProxyAuth(int retries, HTTPProxy usedProxy, List<String> proxyAuths, URL url) {
        if (!this.hasJDHandler()) {
            throw new IllegalStateException("Handler not seT");
        }
        return this.getHandler().updateProxyAuth(retries, usedProxy, proxyAuths, url);
    }

    public boolean hasJDHandler() {
        UpdateCallbackInterface ret = this.getHandler();
        return ret != null && ret != this.defaultHandler;
    }

    public List<HTTPProxy> selectProxy(URL url) {
        if (!this.hasJDHandler()) {
            throw new IllegalStateException("Handler not seT");
        }
        return this.getHandler().selectProxy(url);
    }

    @Override
    public void requestFullExtensionUpdate(String ... parameters) {
        this.client.getExtensionManager().requestFullExtensionUpdate(parameters);
    }

    @Override
    public void setGuiAlwaysOnTop(boolean enabled) {
        if (this.alwaysOnTopExternal != enabled) {
            this.alwaysOnTopExternal = enabled;
            UIInterface g = this.gui;
            if (g != null) {
                g.setAlwaysOnTop(this.isAlwaysOnTopExternal());
            }
        }
    }

    public boolean isAlwaysOnTopExternal() {
        return this.alwaysOnTopExternal;
    }
}

