/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update;

import java.io.File;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.logging2.LogInterface;

public class RevFile
extends File {
    private final File jdJar;
    private final UpdateClient updateClient;
    private final FileAccessHandler fileSystem;

    public RevFile(UpdateClient updateClient, File workingDirectory) {
        super(workingDirectory, "rev");
        this.jdJar = new File(workingDirectory, "JDownloader.jar");
        this.updateClient = updateClient;
        this.fileSystem = updateClient.getFileSystem();
    }

    public int read() {
        if (!this.exists() || !this.jdJar.exists()) {
            return -1;
        }
        try {
            String value = this.fileSystem.secureReadFileToString(this);
            return Integer.parseInt(value.trim());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void write(int destRevision) throws ExtIOException {
        LogInterface logger = this.updateClient.getLogger();
        if (logger != null) {
            logger.info("Write " + this + ": " + destRevision);
        }
        this.fileSystem.secureWrite(this, String.valueOf(destRevision).getBytes(UpdateClient.UTF8), true);
    }
}

