/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.zip.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.appwork.utils.StringUtils;
import org.appwork.utils.zip.CompressedEntriesIndex;
import org.appwork.utils.zip.tests.OnClassPathZipJarTests;

public class CompressedEntriesIndexTest
extends OnClassPathZipJarTests {
    public static void main(String[] args) {
        CompressedEntriesIndexTest.run();
    }

    @Override
    public void runTest() throws Exception {
        for (File testZip : this.getZipJarFilesFromClassPath()) {
            this.testZip(testZip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testZip(File zipFile) throws Exception {
        ArrayList<String> paths = new ArrayList<String>();
        ZipFile zip = new ZipFile(zipFile);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                paths.add(entry.getName());
            }
        }
        finally {
            zip.close();
        }
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
        try {
            ZipEntry entry;
            int index = 0;
            while ((entry = zis.getNextEntry()) != null) {
                CompressedEntriesIndexTest.assertEquals(entry.getName(), paths.get(index++));
            }
            CompressedEntriesIndexTest.assertEquals(index, paths.size());
        }
        finally {
            zis.close();
        }
        CompressedEntriesIndex cei = new CompressedEntriesIndex();
        byte[] data = cei.compress(paths);
        String list = StringUtils.join(paths, "\r\n");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)baos, new Deflater(9));
        out.write(list.getBytes("UTF-8"));
        out.close();
        InputStream is = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)bos, new Deflater(9));
        dos.write(data);
        dos.close();
        System.out.println("ZipFile:" + zipFile + "\t Entries:" + paths.size() + "\t IndexSize:" + data.length + "\t CompressedIndexSize:" + bos.size() + "\t Ratio:" + 100.0 * (double)bos.size() / (double)data.length + "\t ZippedRAWSize: " + baos.size());
        is = new InflaterInputStream(new ByteArrayInputStream(bos.toByteArray()));
        List<String> check = cei.uncompress(is);
        for (int index = 0; index < paths.size(); ++index) {
            String path = paths.get(index);
            String restored = check.get(index);
            CompressedEntriesIndexTest.assertEquals(path, restored);
        }
        CompressedEntriesIndexTest.assertEquals(check.size(), paths.size());
    }
}

