/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.windowmanager;

import java.awt.Component;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.appwork.swing.PropertyStateEventProviderInterface;
import org.appwork.swing.event.PropertySetListener;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.appwork.utils.swing.windowmanager.WindowsWindowManager;

public class WindowResetListener
implements PropertySetListener,
HierarchyListener,
WindowListener {
    private WindowManager.FrameState state;
    private Window w;
    private boolean oldFocusableWindowState;
    private boolean oldFocusable;
    private WindowsWindowManager windowsWindowManager;
    private Point location;
    private boolean oldAlwaysOnTop;
    private int frameExtendedState;

    public boolean isOldFocusableWindowState() {
        return this.oldFocusableWindowState;
    }

    public boolean isOldFocusable() {
        return this.oldFocusable;
    }

    public boolean isOldAlwaysOnTop() {
        return this.oldAlwaysOnTop;
    }

    public WindowResetListener(WindowsWindowManager windowsWindowManager, Window w, WindowManager.FrameState state) {
        this.w = w;
        this.state = state;
        this.windowsWindowManager = windowsWindowManager;
        this.oldFocusableWindowState = w.getFocusableWindowState();
        this.oldAlwaysOnTop = w.isAlwaysOnTop();
        this.oldFocusable = w.isFocusable();
        if (w instanceof Frame) {
            this.frameExtendedState = ((Frame)w).getExtendedState();
        }
        if (w instanceof PropertyStateEventProviderInterface) {
            ((PropertyStateEventProviderInterface)((Object)w)).getPropertySetEventSender().addListener(this, true);
        }
        try {
            this.location = w.getLocationOnScreen();
        }
        catch (IllegalComponentStateException e) {
            this.location = w.getLocation();
        }
    }

    public WindowManager.FrameState getState() {
        return this.state;
    }

    public void setState(WindowManager.FrameState flags) {
        this.state = flags;
    }

    public void resetProperties() {
        this.removeListeners();
        switch (this.getState()) {
            case TO_FRONT: 
            case TO_FRONT_FOCUSED: {
                this.windowsWindowManager.setFocusableWindowState(this.w, this.oldFocusableWindowState);
                this.windowsWindowManager.setFocusable(this.w, this.oldFocusable);
                this.windowsWindowManager.setAlwaysOnTop(this.w, this.oldAlwaysOnTop);
                break;
            }
            default: {
                this.windowsWindowManager.setFocusableWindowState(this.w, this.oldFocusableWindowState);
                this.windowsWindowManager.setFocusable(this.w, this.oldFocusable);
                if (!(this.w instanceof Frame)) break;
                this.windowsWindowManager.setExtendedState((Frame)this.w, this.frameExtendedState);
            }
        }
        this.w.setLocation(this.location);
    }

    protected void removeListeners() {
        this.w.removeHierarchyListener(this);
        this.w.removeWindowListener(this);
        if (this.w instanceof PropertyStateEventProviderInterface) {
            ((PropertyStateEventProviderInterface)((Object)this.w)).getPropertySetEventSender().removeListener(this);
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyevent) {
        this.windowOpened(null);
    }

    @Override
    public void windowOpened(WindowEvent windowevent) {
        this.removeListeners();
        switch (this.getState()) {
            case TO_FRONT: 
            case TO_FRONT_FOCUSED: {
                this.windowsWindowManager.setFocusableWindowState(this.w, this.oldFocusableWindowState);
                this.windowsWindowManager.setFocusable(this.w, this.oldFocusable);
                this.windowsWindowManager.setAlwaysOnTop(this.w, this.oldAlwaysOnTop);
                this.windowsWindowManager.setZState(this.w, this.getState());
                break;
            }
            default: {
                if (this.w instanceof Frame) {
                    this.windowsWindowManager.setExtendedState((Frame)this.w, this.frameExtendedState);
                }
                this.windowsWindowManager.toBack(this.w);
                this.windowsWindowManager.setFocusableWindowState(this.w, this.oldFocusableWindowState);
                this.windowsWindowManager.setFocusable(this.w, this.oldFocusable);
            }
        }
        if (this.w instanceof Frame) {
            switch (this.windowsWindowManager.getExtendedState((Frame)this.w)) {
                case NORMAL: {
                    this.w.setLocation(this.location);
                }
            }
        } else {
            this.w.setLocation(this.location);
        }
    }

    @Override
    public void onPropertySet(Component caller, String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null || propertyName.equals(this.windowsWindowManager.getBlocker())) {
            return;
        }
        if ("focusableWindowState".equals(propertyName)) {
            this.oldFocusableWindowState = (Boolean)newValue;
        } else if ("focusable".equals(propertyName)) {
            this.oldFocusable = (Boolean)newValue;
        } else if ("alwaysOnTop".equals(propertyName)) {
            this.oldAlwaysOnTop = (Boolean)newValue;
        } else if ("location".equals(propertyName)) {
            this.location = (Point)newValue;
        } else if ("extendedState".equals(propertyName)) {
            this.frameExtendedState = (Integer)newValue;
        }
    }

    public void add() {
        this.w.addHierarchyListener(this);
    }

    @Override
    public void windowActivated(WindowEvent windowevent) {
    }

    @Override
    public void windowClosed(WindowEvent windowevent) {
    }

    @Override
    public void windowClosing(WindowEvent windowevent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowevent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowevent) {
    }

    @Override
    public void windowIconified(WindowEvent windowevent) {
    }
}

