/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.windowmanager;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Map;
import java.util.WeakHashMap;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.windowmanager.DefaultWindowManager;
import org.appwork.utils.swing.windowmanager.LinuxWindowManager;
import org.appwork.utils.swing.windowmanager.MacWindowManager;
import org.appwork.utils.swing.windowmanager.WindowsWindowManager;

public abstract class WindowManager {
    static WindowManager INSTANCE = WindowManager.createOsWindowManager();
    protected final WeakHashMap<Window, WindowMetaInfo> windowMetaMap = new WeakHashMap();
    protected final WindowFocusListener windowFocusListener = new WindowFocusListener(){

        @Override
        public void windowLostFocus(WindowEvent e) {
            WindowManager.this.getMetaInfo(e.getWindow()).setLostFocus(System.currentTimeMillis());
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            WindowManager.this.getMetaInfo(e.getWindow()).setGainedFocus(System.currentTimeMillis());
        }
    };

    public static void setCustom(WindowManager instance) {
        INSTANCE = instance;
    }

    private static WindowManager createOsWindowManager() {
        if (CrossSystem.isWindows()) {
            return new WindowsWindowManager();
        }
        if (CrossSystem.isUnix()) {
            return new LinuxWindowManager();
        }
        if (CrossSystem.isMac()) {
            return new MacWindowManager();
        }
        return new DefaultWindowManager();
    }

    public static WindowManager getInstance() {
        return INSTANCE;
    }

    public WindowExtendedState getExtendedState(Frame w) {
        return WindowExtendedState.get(w.getExtendedState());
    }

    public boolean hasFocus(Window window) {
        if (window != null) {
            if (window.isFocusOwner()) {
                return true;
            }
            if (window.getFocusOwner() != null) {
                return true;
            }
            if (window.isFocused()) {
                return true;
            }
            return window.hasFocus();
        }
        return false;
    }

    public void hide(Window w) {
        this.setVisible(w, false, FrameState.OS_DEFAULT);
    }

    public void hide(Window w, FrameState state) {
        this.setVisible(w, false, state);
    }

    public Window getLatestWorkingFrameOrDialog() {
        WindowMetaInfo meta = null;
        Window window = null;
        for (Map.Entry<Window, WindowMetaInfo> es : this.windowMetaMap.entrySet()) {
            Window w = es.getKey();
            if (w == null || !w.isDisplayable() || !(w instanceof Frame) && !(w instanceof Dialog)) continue;
            WindowMetaInfo metaInfo = es.getValue();
            if (meta != null && Math.max(meta.getGainedFocus(), meta.getShown()) >= Math.max(metaInfo.getGainedFocus(), metaInfo.getShown())) continue;
            meta = metaInfo;
            window = w;
        }
        return window;
    }

    public WindowMetaInfo getMetaInfo(Window window) {
        WindowMetaInfo ret = this.windowMetaMap.get(window);
        if (ret == null) {
            ret = new WindowMetaInfo();
            this.windowMetaMap.put(window, ret);
        }
        return ret;
    }

    public void setExtendedState(Frame w, WindowExtendedState state) {
        if (state == null) {
            throw new NullPointerException("State is null");
        }
        switch (state) {
            case NORMAL: {
                w.setExtendedState(0);
                break;
            }
            case ICONIFIED: {
                w.setExtendedState(1);
                break;
            }
            case MAXIMIZED_BOTH: {
                w.setExtendedState(6);
            }
        }
    }

    public void setVisible(Window w, boolean visible) {
        this.setVisible(w, visible, FrameState.OS_DEFAULT);
    }

    public abstract void setVisible(Window var1, boolean var2, FrameState var3);

    public abstract void setZState(Window var1, FrameState var2);

    public void show(Window w) {
        this.setVisible(w, true, FrameState.OS_DEFAULT);
    }

    public void show(Window w, FrameState state) {
        this.setVisible(w, true, state);
    }

    public boolean hasFocus() {
        for (Window w : Window.getWindows()) {
            if (!this.hasFocus(w)) continue;
            return true;
        }
        return false;
    }

    public static class WindowMetaInfo {
        private long lostFocus;
        private long gainedFocus;
        private long shown;

        public long getShown() {
            return this.shown;
        }

        public void setShown(long shown) {
            this.shown = shown;
        }

        public long getLostFocus() {
            return this.lostFocus;
        }

        public void setLostFocus(long lostFocus) {
            this.lostFocus = lostFocus;
        }

        public long getGainedFocus() {
            return this.gainedFocus;
        }

        public void setGainedFocus(long gainedFocus) {
            this.gainedFocus = gainedFocus;
        }
    }

    public static enum WindowExtendedState {
        NORMAL(0),
        MAXIMIZED_BOTH(6),
        ICONIFIED(1);

        private int id;

        public int getId() {
            return this.id;
        }

        private WindowExtendedState(int i) {
            this.id = i;
        }

        public static WindowExtendedState get(int state) {
            if ((state & 6) != 0) {
                return MAXIMIZED_BOTH;
            }
            if ((state & 1) != 0) {
                return ICONIFIED;
            }
            return NORMAL;
        }
    }

    public static enum FrameState {
        OS_DEFAULT,
        TO_FRONT,
        TO_BACK,
        TO_FRONT_FOCUSED;

    }
}

