/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.locator;

import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.locationstore.LocationStorage;
import org.appwork.utils.swing.locationstore.LocationStorageManager;
import org.appwork.utils.swing.locator.AbstractLocator;
import org.appwork.utils.swing.locator.CenterOfScreenLocator;

public class RememberRelativeLocator
extends AbstractLocator {
    public static final String TYPE = "relative";
    private final Window parent;
    protected AbstractLocator fallbackLocator;

    public RememberRelativeLocator(String id, Window jFrame) {
        super(id);
        if (id == null) {
            throw new IllegalArgumentException("id ==null");
        }
        this.parent = jFrame;
        this.setFallbackLocator(new CenterOfScreenLocator());
    }

    protected AbstractLocator getFallbackLocator() {
        return this.fallbackLocator;
    }

    @Override
    public Point getLocationOnScreen(Window frame) {
        block9: {
            try {
                String storageID = this.getStorageID(frame);
                LocationStorage cfg = LocationStorageManager.INSTANCE.get(frame, storageID);
                if (cfg.isValid()) {
                    Point ret;
                    Point location = new Point(cfg.getX(), cfg.getY());
                    Point parentLocationOnScreen = null;
                    if ("absolute".equalsIgnoreCase(cfg.getType())) {
                        ret = AbstractLocator.validate(location, frame);
                    } else if (TYPE.equalsIgnoreCase(cfg.getType())) {
                        Container actualParent = frame.getParent();
                        if (actualParent != null && actualParent.isShowing()) {
                            parentLocationOnScreen = actualParent.getLocationOnScreen();
                        }
                        Window parent = this.getParent();
                        if (parentLocationOnScreen == null && parent != null && parent.isShowing()) {
                            parentLocationOnScreen = parent.getLocationOnScreen();
                        }
                        ret = parentLocationOnScreen == null ? this.getFallbackLocator().getLocationOnScreen(frame) : AbstractLocator.validate(new Point(location.x + parentLocationOnScreen.x, location.y + parentLocationOnScreen.y), frame);
                    } else {
                        ret = this.getFallbackLocator().getLocationOnScreen(frame);
                    }
                    return ret;
                }
            }
            catch (Throwable e) {
                if (!CrossSystem.isLinux()) break block9;
                LogV3.log(e);
            }
        }
        return this.getFallbackLocator().getLocationOnScreen(frame);
    }

    protected Window getParent() {
        return this.parent;
    }

    @Override
    public void onClose(Window window, ComponentEvent event) {
        try {
            if (window.isShowing()) {
                String storageID = this.getStorageID(window);
                Point locationOnScreen = window.getLocationOnScreen();
                Point parentLocationOnScreen = null;
                Container parentLocationSource = null;
                Container actualParent = window.getParent();
                if (actualParent != null && actualParent.isShowing()) {
                    parentLocationOnScreen = actualParent.getLocationOnScreen();
                    parentLocationSource = actualParent;
                }
                Window parent = this.getParent();
                if (parentLocationOnScreen == null && parent != null && parent.isShowing()) {
                    parentLocationSource = parent;
                    parentLocationOnScreen = parent.getLocationOnScreen();
                }
                LocationStorage cfg = LocationStorageManager.INSTANCE.get(window, storageID);
                if (parentLocationOnScreen == null) {
                    LocationStorageManager.INSTANCE.onUpdate(window, locationOnScreen, null, cfg, "absolute");
                } else {
                    LocationStorageManager.INSTANCE.onUpdate(window, new Point(locationOnScreen.x - parentLocationOnScreen.x, locationOnScreen.y - parentLocationOnScreen.y), null, cfg, TYPE);
                }
            }
        }
        catch (Throwable e) {
            LogV3.logger(this).exception("Swallowed", e);
        }
    }

    public void setFallbackLocator(AbstractLocator fallbackLocator) {
        this.fallbackLocator = fallbackLocator == null ? new CenterOfScreenLocator() : fallbackLocator;
    }
}

