/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;

public class LoginRegisterDialog
extends AbstractDialog<String[]>
implements KeyListener,
MouseListener {
    public static final int REGISTER = 0x100000;
    public static final int FORCE_REGISTER = 0x200000;
    private final String defaultMessage;
    private final String message;
    private JTextPane messageArea;
    private JTextField login;
    private JPasswordField password;
    private final boolean remember;
    private JCheckBox rem;
    private final boolean register;
    private JLabel registerBtn;
    private JPasswordField rpassword;
    private JLabel rpasswordLabel;

    public static void main(String[] args) {
        try {
            Dialog.getInstance().showDialog(new LoginRegisterDialog(32, "itle", "message", "defaultMessage", null, null, null));
        }
        catch (DialogClosedException e) {
            e.printStackTrace();
        }
        catch (DialogCanceledException e) {
            e.printStackTrace();
        }
    }

    public LoginRegisterDialog(int flag, String title, String message, String defaultMessage, ImageIcon icon, String okOption, String cancelOption) {
        super(flag & 0xFFFFFFFF & 0xFFFFFFDF, title, icon, okOption, cancelOption);
        this.remember = BinaryLogic.containsAll(flag, 32);
        this.register = BinaryLogic.containsAll(flag, 0x100000);
        this.defaultMessage = defaultMessage;
        this.message = message;
    }

    @Override
    protected String[] createReturnValue() {
        return this.getLogins();
    }

    public String[] getLogins() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return null;
        }
        return new String[]{this.login.getText(), new String(this.password.getPassword()), this.rpassword.isVisible() ? new String(this.rpassword.getPassword()) : null, this.rem.isSelected() ? "yes" : null};
    }

    public boolean isRemember() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return false;
        }
        return this.rem.isSelected();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.cancel();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public JComponent layoutDialogContent() {
        JPanel cp = new JPanel(new MigLayout("ins 0,wrap 2", "[][fill,grow]"));
        this.messageArea = new JTextPane();
        this.messageArea.setBorder(null);
        this.messageArea.setBackground(null);
        this.messageArea.setOpaque(false);
        this.messageArea.setText(this.message);
        this.messageArea.setEditable(false);
        this.messageArea.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        cp.add((Component)this.messageArea, "spanx");
        cp.add((Component)new JLabel(_AWU.T.LOGINDIALOG_LABEL_USERNAME()), "alignx right");
        this.login = new JTextField();
        this.login.setBorder(BorderFactory.createEtchedBorder());
        this.login.setText(this.defaultMessage);
        this.login.addKeyListener(this);
        this.login.addMouseListener(this);
        cp.add((Component)this.login, "pushy,growy");
        cp.add((Component)new JLabel(_AWU.T.LOGINDIALOG_LABEL_PASSWORD()), "alignx right");
        this.password = new JPasswordField();
        this.password.setBorder(BorderFactory.createEtchedBorder());
        this.password.addKeyListener(this);
        this.password.addMouseListener(this);
        cp.add((Component)this.password, "pushy,growy");
        this.rpasswordLabel = new JLabel(_AWU.T.LOGINDIALOG_LABEL_PASSWORD_REPEAT());
        cp.add((Component)this.rpasswordLabel, "alignx right,hidemode 3");
        this.rpassword = new JPasswordField();
        this.rpassword.setBorder(BorderFactory.createEtchedBorder());
        this.rpassword.addKeyListener(this);
        this.rpassword.addMouseListener(this);
        cp.add((Component)this.rpassword, "pushy,growy,hidemode 3");
        this.rpassword.setVisible(BinaryLogic.containsAll(this.flagMask, 0x200000));
        this.rpasswordLabel.setVisible(BinaryLogic.containsAll(this.flagMask, 0x200000));
        if (this.register) {
            this.registerBtn = new JLabel(_AWU.T.LOGINDIALOG_BUTTON_REGISTER());
            this.registerBtn.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, cp.getBackground().darker().darker()));
            this.registerBtn.setCursor(Cursor.getPredefinedCursor(12));
            this.registerBtn.addMouseListener(this);
            cp.add((Component)this.registerBtn, "skip,split 2");
        } else {
            cp.add(Box.createHorizontalGlue(), "skip,split 2");
        }
        if (this.remember) {
            this.rem = new JCheckBox(_AWU.T.LOGINDIALOG_CHECKBOX_REMEMBER());
            this.rem.setHorizontalTextPosition(2);
            this.rem.setHorizontalAlignment(4);
            cp.add((Component)this.rem, "pushx,growx,alignx right");
        }
        return cp;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.registerBtn) {
            if (this.rpassword.isVisible()) {
                this.rpassword.setVisible(false);
                this.rpasswordLabel.setVisible(false);
                this.registerBtn.setText(_AWU.T.LOGINDIALOG_BUTTON_REGISTER());
            } else {
                this.rpassword.setVisible(true);
                this.rpasswordLabel.setVisible(true);
                this.registerBtn.setText(_AWU.T.LOGINDIALOG_BUTTON_LOGIN());
            }
            this.pack();
        } else {
            this.cancel();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    protected void initFocus(JComponent focus) {
        this.login.selectAll();
        this.login.requestFocusInWindow();
    }
}

