/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.Files;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.swing.EDTHelper;

public class FilePreview
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 68064282036848471L;
    private final JFileChooser fileChooser;
    private final JPanel panel;
    private final JLabel label;
    private File file;

    public FilePreview(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
        this.fileChooser.addPropertyChangeListener(this);
        this.panel = new JPanel(new MigLayout("ins 5", "[grow,fill]", "[grow,fill]"));
        this.label = new JLabel();
        this.panel.add(this.label);
        this.setLayout(new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
        this.add((Component)new JScrollPane(this.panel), "hidemode 3,gapleft 5");
        this.setPreferredSize(new Dimension(200, 100));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("directoryChanged".equals(e.getPropertyName())) {
            this.file = (File)e.getNewValue();
        } else if ("SelectedFileChangedProperty".equals(e.getPropertyName())) {
            this.file = (File)e.getNewValue();
        }
        new Thread(){

            @Override
            public void run() {
                FilePreview.this.update();
            }
        }.start();
    }

    private void update() {
        if (this.file != null && this.file.isFile()) {
            try {
                String ext = Files.getExtension(this.file.getName(), false);
                if (ext != null) {
                    BufferedImage image = null;
                    if (ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("gif")) {
                        image = ImageProvider.read(this.file);
                    }
                    if (image != null) {
                        final ImageIcon ii = new ImageIcon(ImageProvider.scaleBufferedImage(image, 160, 160));
                        new EDTHelper<Object>(){

                            @Override
                            public Object edtRun() {
                                FilePreview.this.label.setIcon(ii);
                                int w = FilePreview.this.fileChooser.getWidth() / 3;
                                FilePreview.this.setPreferredSize(new Dimension(w, 100));
                                FilePreview.this.fileChooser.revalidate();
                                return null;
                            }
                        }.start();
                        return;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                FilePreview.this.label.setIcon(null);
                FilePreview.this.label.setText("");
                FilePreview.this.setPreferredSize(new Dimension(0, 0));
                FilePreview.this.fileChooser.revalidate();
                return null;
            }
        }.start();
    }
}

