/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.swing.MigPanel;
import org.appwork.uio.ComboBoxDialogInterface;
import org.appwork.utils.swing.dialog.AbstractDialog;

public class ComboBoxDialog
extends AbstractDialog<Integer>
implements ComboBoxDialogInterface {
    private JComboBox box;
    private final String message;
    private JTextPane textpane;
    private final int defaultAnswer;
    private final Object[] options;
    private final ListCellRenderer renderer;

    @Override
    public boolean isRemoteAPIEnabled() {
        return true;
    }

    public ComboBoxDialog(int flag, String title, String question, Object[] options, int defaultSelection, Icon icon, String okText, String cancelText, ListCellRenderer renderer) {
        super(flag, title, icon, okText, cancelText);
        this.getLogger().fine("Dialog    [" + okText + "][" + cancelText + "]\r\nflag:  " + Integer.toBinaryString(flag) + "\r\ntitle: " + title + "\r\nmsg:   \r\n" + question + "\r\noptions:   \r\n" + Arrays.toString(options) + "\r\ndef:" + defaultSelection);
        this.message = question;
        this.renderer = renderer;
        this.defaultAnswer = defaultSelection < 0 ? 0 : defaultSelection;
        this.options = options;
    }

    @Override
    protected Integer createReturnValue() {
        return this.getReturnIndex();
    }

    protected JComboBox getComboBox(Object[] options2) {
        JComboBox<Object> ret = new JComboBox<Object>(options2);
        ListCellRenderer rend = this.getRenderer(ret.getRenderer());
        if (rend != null) {
            ret.setRenderer(rend);
        }
        try {
            if (this.defaultAnswer < this.options.length && this.defaultAnswer >= 0) {
                ret.setSelectedIndex(this.defaultAnswer);
            }
        }
        catch (Exception e) {
            this.getLogger().log(e);
        }
        return ret;
    }

    protected ListCellRenderer getRenderer(ListCellRenderer orgRenderer) {
        return this.renderer;
    }

    public Integer getReturnIndex() {
        if ((this.getReturnmask() & 2) == 0) {
            return -1;
        }
        return this.box.getSelectedIndex();
    }

    @Override
    public JComponent layoutDialogContent() {
        MigPanel contentpane = new MigPanel("ins 0,wrap 1", "[fill,grow]", "[][]");
        this.textpane = new JTextPane();
        this.textpane.setBorder(null);
        this.textpane.setBackground(null);
        this.textpane.setOpaque(false);
        this.textpane.setForeground(new JLabel().getForeground());
        this.textpane.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.textpane.setText(this.message);
        this.textpane.setEditable(false);
        contentpane.add(this.textpane);
        this.box = this.getComboBox(this.options);
        contentpane.add((Component)this.box, "pushy,growy,height 24!");
        return contentpane;
    }

    @Override
    public int getSelectedIndex() {
        return this.getReturnIndex();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String[] getLabels() {
        String[] ret = new String[this.options.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.options[i] instanceof LabelInterface ? ((LabelInterface)this.options[i]).getLabel() : String.valueOf(this.options[i]);
        }
        return ret;
    }

    @Override
    public int getPreSelectedIndex() {
        return this.defaultAnswer;
    }
}

