/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.utils.Application;
import org.appwork.utils.Time;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.swing.EDTRunner;

public class SlowEDTDetector {
    private final AtomicLong lastInvoke = new AtomicLong(-1L);
    private final AtomicLong lastEDT = new AtomicLong(-1L);
    private final AtomicBoolean detectEDTBlocking = new AtomicBoolean(false);
    private final AtomicBoolean doLog = new AtomicBoolean(true);
    private final DelayedRunnable detector;
    private final long maxEDTBlockingTime;

    public SlowEDTDetector(long maxEDTBlockingTime, final LogInterface logger) {
        this.maxEDTBlockingTime = maxEDTBlockingTime;
        this.detector = new DelayedRunnable(maxEDTBlockingTime, maxEDTBlockingTime){

            @Override
            public void delayedrun() {
                block7: {
                    try {
                        long blocking = SlowEDTDetector.this.lastEDT.get();
                        if (blocking < 0L) {
                            blocking = SlowEDTDetector.this.now() - SlowEDTDetector.this.lastInvoke.get();
                        }
                        if (blocking >= SlowEDTDetector.this.maxEDTBlockingTime) {
                            if (!SlowEDTDetector.this.doLog.get()) break block7;
                            try {
                                logger.severe(Application.getThreadDump());
                                break block7;
                            }
                            finally {
                                SlowEDTDetector.this.doLog.set(false);
                            }
                        }
                        SlowEDTDetector.this.doLog.set(true);
                    }
                    catch (Throwable e) {
                        logger.log(e);
                    }
                }
                SlowEDTDetector.this.invokeEDT();
            }
        };
        this.invokeEDT();
    }

    protected long now() {
        return Time.systemIndependentCurrentJVMTimeMillis();
    }

    protected void invokeEDT() {
        if (this.detectEDTBlocking.compareAndSet(false, true)) {
            this.lastEDT.set(-1L);
            this.lastInvoke.set(this.now());
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    SlowEDTDetector.this.lastEDT.set(SlowEDTDetector.this.now() - SlowEDTDetector.this.lastInvoke.get());
                    SlowEDTDetector.this.detectEDTBlocking.set(false);
                }
            };
        }
        this.detector.run();
    }
}

