/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class ShadowBorder
extends AbstractBorder {
    private static final long serialVersionUID = 1L;
    private int shadowWidth = 3;
    private Color color = Color.GRAY;

    public ShadowBorder() {
        this(3);
    }

    public ShadowBorder(int width) {
        this(width, Color.GRAY);
    }

    public ShadowBorder(int width, Color color) {
        this.shadowWidth = width;
        this.color = color;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(0, 0, this.shadowWidth + 1, this.shadowWidth + 1);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 1;
        insets.left = 1;
        insets.bottom = this.shadowWidth + 1;
        insets.right = this.shadowWidth + 1;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.color);
        g.drawRect(x, y, width - this.shadowWidth - 1, height - this.shadowWidth - 1);
        int alphaSteps = this.color.getAlpha() / (this.shadowWidth + 1);
        for (int i = 0; i <= this.shadowWidth; ++i) {
            g.setColor(new Color(g.getColor().getRed(), g.getColor().getGreen(), g.getColor().getBlue(), g.getColor().getAlpha() - alphaSteps));
            int x1 = x + i + this.shadowWidth;
            int y1 = y + height - this.shadowWidth + i;
            int x2 = x + width + i - this.shadowWidth;
            int y2 = y1;
            g.drawLine(x1, y1, x2, y2);
            x1 = x + width - this.shadowWidth + i;
            y1 = y + i + this.shadowWidth;
            x2 = x1;
            y2 = y + height + i - this.shadowWidth - 1;
            g.drawLine(x1, y1, x2, y2);
        }
        g.setColor(oldColor);
    }
}

