/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class ListFocusTraversalPolicy
extends FocusTraversalPolicy {
    private final List<Component> focusOrder;

    public static List<Component> getFocusableComponents(Container comp) {
        ArrayList<Component> ret = new ArrayList<Component>();
        for (Component c : comp.getComponents()) {
            if (!c.isFocusable()) continue;
            boolean allowed = false;
            allowed |= c instanceof AbstractButton;
            allowed |= c instanceof JTextComponent && ((JTextComponent)c).isEditable();
            if (allowed |= c instanceof JTextField) {
                ret.add(c);
            }
            if (!(c instanceof Container)) continue;
            ret.addAll(ListFocusTraversalPolicy.getFocusableComponents((Container)c));
        }
        return ret;
    }

    public ListFocusTraversalPolicy(List<Component> focusOrder) {
        this.focusOrder = focusOrder;
    }

    @Override
    public Component getLastComponent(Container aContainer) {
        return this.focusOrder.get(this.focusOrder.size() - 1);
    }

    @Override
    public Component getFirstComponent(Container aContainer) {
        return this.focusOrder.get(0);
    }

    @Override
    public Component getDefaultComponent(Container aContainer) {
        return this.focusOrder.get(0);
    }

    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        Component newC = null;
        int index = this.focusOrder.indexOf(aComponent);
        System.out.println(index);
        if (index == -1) {
            index = 0;
        }
        --index;
        for (int i = 0; i < this.focusOrder.size(); ++i) {
            int bi;
            for (bi = index - i; bi < 0; bi += this.focusOrder.size()) {
            }
            newC = this.focusOrder.get(bi);
            if (newC.isEnabled() && newC.isVisible()) break;
        }
        return newC;
    }

    @Override
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        Component newC = null;
        int index = this.focusOrder.indexOf(aComponent) + 1;
        for (int i = 0; !(i >= this.focusOrder.size() || (newC = this.focusOrder.get((index + i) % this.focusOrder.size())).isEnabled() && newC.isVisible()); ++i) {
        }
        return newC;
    }
}

