/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.util.regex.Pattern;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JTextAreaLimited
extends JTextArea {
    private static final long serialVersionUID = 4659158584673623059L;
    private int limit = 0;
    private Pattern validCharsRegex = null;

    public JTextAreaLimited(int limit) {
        this.limit = limit;
        this.setDocument(new JTextFieldLimiter());
    }

    public JTextAreaLimited(int limit, Pattern validCharsRegex) {
        this.limit = limit;
        this.validCharsRegex = validCharsRegex;
        this.setDocument(new JTextFieldLimiter());
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public Pattern getValidCharsRegex() {
        return this.getValidCharsRegex();
    }

    public void setValidCharsRegex(Pattern valid) {
        this.validCharsRegex = valid;
    }

    class JTextFieldLimiter
    extends PlainDocument {
        private static final long serialVersionUID = 2849987429671585606L;

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (!(JTextAreaLimited.this.limit > 0 && this.getLength() + str.length() > JTextAreaLimited.this.limit || JTextAreaLimited.this.validCharsRegex != null && !JTextAreaLimited.this.validCharsRegex.matcher(str).matches())) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

