/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.reflection;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.CannotResolvePathException;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.Property;
import org.appwork.utils.DebugMode;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.reflection.Clazz;

public class CompiledType {
    private static final ThreadLocal<HashMap<Type, List<CompiledType>>> INIT_CACHE = new ThreadLocal();
    private static final CompiledType[] EMPTY = new CompiledType[0];
    private static final Map<Type, CompiledType> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    public final Class<? extends Type> category;
    public final Class<?> raw;
    public final CompiledType[] componentTypes;
    public final Type type;
    public final Map<Type, CompiledType> genericTypesMap;
    public final CompiledType superType;
    private final LinkedList<Type> contextHirarchy;
    private LinkedList<CompiledType> cachedTypeHirarchy;
    private ClassCache classCache;
    private boolean generic;
    private boolean genericsResolvedByContext;
    private Boolean genericsResolved;
    private Boolean isEnum = null;
    private static final ArrayList<CompiledType> PRIMITIVES_AND_BASICS;
    private static final HashSet<Class> BREAK_HIERARCHY_AT_TYPES;
    private static volatile WeakHashMap<Type, CompiledType> SIMPLE_CACHE;
    private static final WeakHashMap<Type, List<WeakReference<CompiledType>>> CACHE;
    public static final CompiledType BOOLEAN_PRIMITIVE;
    public static final CompiledType BOOLEAN_WRAPPER;
    public static final CompiledType STRING;
    public static final CompiledType DOUBLE_PRIMITIVE;
    public static final CompiledType DOUBLE_WRAPPER;
    public static final CompiledType INT_PRIMITIVE;
    public static final CompiledType INT_WRAPPER;
    public static final CompiledType FLOAT_PRIMITIVE;
    public static final CompiledType FLOAT_WRAPPER;
    public static final CompiledType LONG_PRIMITIVE;
    public static final CompiledType LONG_WRAPPER;
    public static final CompiledType BYTE_PRIMITIVE;
    public static final CompiledType BYTE_WRAPPER;
    public static final CompiledType SHORT_PRIMITIVE;
    public static final CompiledType SHORT_WRAPPER;
    public static final CompiledType CHAR_PRIMITIVE;
    public static final CompiledType CHAR_WRAPPER;
    public static final CompiledType OBJECT;

    public CompiledType[] getComponentTypes() {
        return this.componentTypes;
    }

    public String getTypeName() {
        return "CompiledType " + this.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString(ToStringRule rule) {
        StringBuilder sb;
        block50: {
            block51: {
                block52: {
                    if (rule == null) {
                        rule = new ToStringRule();
                    }
                    sb = new StringBuilder();
                    if (this.raw != null && this.raw.isAnonymousClass() && rule.isSkipAnonymousClasses()) {
                        return this.superType.toString(rule);
                    }
                    if (this.raw != null) break block51;
                    if (!(this.type instanceof WildcardType)) break block52;
                    if ("?".equals(this.type.toString())) {
                        sb.append(rule.getNameForUnspecifiedGeneric());
                        break block50;
                    } else if (((WildcardType)this.type).getUpperBounds().length == 1 && ((WildcardType)this.type).getLowerBounds().length == 0) {
                        sb.append(rule.getNameForUnspecifiedGeneric() + " extends " + CompiledType.create(((WildcardType)this.type).getUpperBounds()[0]).toString(rule));
                        break block50;
                    } else {
                        sb.append(((WildcardType)this.type).toString());
                    }
                    break block50;
                }
                if (!(this.type instanceof TypeVariable)) {
                    LogV3.log(new Exception("Unknown type " + this.type));
                    return "Unknown Type";
                }
                Type[] bounds = ((TypeVariable)this.type).getBounds();
                sb.append(((TypeVariable)this.type).toString());
                break block50;
            }
            if (Collection.class.isAssignableFrom(this.raw)) {
                switch (rule.getSyntax()) {
                    case JAVA: {
                        sb.append(this.raw.getSimpleName());
                        break;
                    }
                    default: {
                        sb.append(rule.getNameForArrays());
                        break;
                    }
                }
            } else if (Map.class.isAssignableFrom(this.raw)) {
                switch (rule.getSyntax()) {
                    case JAVA: {
                        sb.append(this.raw.getSimpleName());
                        break;
                    }
                    default: {
                        if (!this.isImplementing(Map.class)) {
                            sb.append(this.raw.getSimpleName());
                            break;
                        }
                        sb.append(rule.getNameForMaps());
                        break;
                    }
                }
            } else if (this.raw.isArray()) {
                switch (rule.getSyntax()) {
                    case JAVA: {
                        break;
                    }
                    default: {
                        sb.append(rule.getNameForArrays());
                        break;
                    }
                }
            } else if (this.raw.isEnum()) {
                switch (rule.getSyntax()) {
                    case JAVA: {
                        sb.append(this.raw.getSimpleName());
                        break;
                    }
                    default: {
                        sb.append(this.raw.getSimpleName() + rule.getPostFixForEnums());
                        break;
                    }
                }
            } else if (Clazz.isPrimitive(this.raw)) {
                switch (rule.getPrimitiveWrapperStrategy()) {
                    case DEDICATED_NAME_FOR_EACH: {
                        sb.append(this.raw.getSimpleName());
                        break;
                    }
                    case PRIMITIVE_NAMES_FOR_BOTH: {
                        if (!Clazz.isPrimitiveWrapper(this.raw)) {
                            sb.append(this.raw.getSimpleName());
                            break;
                        }
                        sb.append(Clazz.wrapperToPrimitive(this.raw).getSimpleName());
                        break;
                    }
                    case WRAPPER_NAMES_FOR_BOTH: {
                        if (Clazz.isPrimitiveWrapper(this.raw)) {
                            sb.append(this.raw.getSimpleName());
                            break;
                        }
                        sb.append(((Class)Clazz.primitiveToWrapper(this.raw)).getSimpleName());
                        break;
                    }
                }
            } else {
                sb.append(this.raw.getSimpleName());
            }
        }
        CompiledType[] actualComponents = this.componentTypes;
        if (rule.getSyntax() == ToStringSyntax.JSON && this.raw != null) {
            if (this.isImplementing(Map.class)) {
                actualComponents = this.getComponentTypes(Map.class);
            } else if (Collection.class.isAssignableFrom(this.raw)) {
                actualComponents = this.getComponentTypes(Collection.class);
            }
        }
        if (this.raw != null && this.raw.isArray() && rule.getSyntax() == ToStringSyntax.JAVA) {
            sb.append(actualComponents[0].toString(rule));
            sb.append("[]");
            return sb.toString();
        }
        if (actualComponents.length <= 0) return sb.toString();
        sb.append("<");
        CompiledType[] compiledTypeArray = actualComponents;
        int n = compiledTypeArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                sb.append(">");
                return sb.toString();
            }
            CompiledType t = compiledTypeArray[n2];
            if (sb.charAt(sb.length() - 1) != '<') {
                sb.append(",");
            }
            if (rule.getSyntax() == ToStringSyntax.JAVA) {
                PrimitiveWrapperStrategy before = rule.getPrimitiveWrapperStrategy();
                try {
                    rule.setPrimitiveWrapperStrategy(PrimitiveWrapperStrategy.WRAPPER_NAMES_FOR_BOTH);
                    sb.append(t.toString(rule));
                }
                finally {
                    rule.setPrimitiveWrapperStrategy(before);
                }
            } else {
                sb.append(t.toString(rule));
            }
            ++n2;
        }
    }

    private boolean isImplementing(Class<?> ... interfaces) {
        block0: for (Class<?> requested : interfaces) {
            for (Class<?> i : this.raw.getInterfaces()) {
                if (i == requested) continue block0;
            }
            return false;
        }
        return true;
    }

    private LinkedList<CompiledType> getTypeHirarchy() {
        if (this.cachedTypeHirarchy != null) {
            return this.cachedTypeHirarchy;
        }
        LinkedList<CompiledType> ret = new LinkedList<CompiledType>();
        CompiledType c = this;
        while (c != null) {
            ret.add(c);
            c = c.superType;
        }
        this.cachedTypeHirarchy = ret;
        return ret;
    }

    public boolean isGenericsResolved() {
        if (this.genericsResolved != null) {
            return this.genericsResolved == Boolean.TRUE;
        }
        this.genericsResolved = this.isGenericsResolvedInternal(new HashSet<CompiledType>());
        return this.genericsResolved == Boolean.TRUE;
    }

    private boolean isGenericsResolvedInternal(HashSet<CompiledType> hashSet) {
        if (!hashSet.add(this)) {
            return true;
        }
        if (this.type instanceof TypeVariable) {
            return false;
        }
        if (this.type instanceof WildcardType) {
            return false;
        }
        for (CompiledType c : this.componentTypes) {
            if (c.isGenericsResolvedInternal(hashSet)) continue;
            return false;
        }
        if (this.superType != null) {
            return this.superType.isGenericsResolvedInternal(hashSet);
        }
        return true;
    }

    private CompiledType(Type type, LinkedList<Type> contextHirarchy) {
        if (contextHirarchy.getLast() != type) {
            contextHirarchy.add(type);
        }
        this.contextHirarchy = new LinkedList<Type>(contextHirarchy);
        this.type = type;
        this.category = type.getClass();
        CompiledType.putToThreadLocalCache(this);
        if (type instanceof Class) {
            this.raw = ReflectionUtils.getRaw(type);
            TypeVariable<Class<?>>[] types = this.raw.getTypeParameters();
            if (((Class)type).getComponentType() != null) {
                this.componentTypes = new CompiledType[]{CompiledType.create(((Class)type).getComponentType(), contextHirarchy)};
            } else if (types != null && types.length > 0) {
                this.componentTypes = new CompiledType[types.length];
                for (int i = 0; i < types.length; ++i) {
                    this.componentTypes[i] = OBJECT;
                }
            } else {
                this.componentTypes = EMPTY;
            }
            this.genericTypesMap = EMPTY_MAP;
        } else if (type instanceof ParameterizedType) {
            this.raw = ReflectionUtils.getRaw(type);
            int i = 0;
            this.componentTypes = new CompiledType[((ParameterizedType)type).getActualTypeArguments().length];
            HashMap genericsMap = new HashMap();
            for (Type cType : ((ParameterizedType)type).getActualTypeArguments()) {
                this.componentTypes[i] = CompiledType.create(cType, contextHirarchy);
                genericsMap.put(this.raw.getTypeParameters()[i], this.componentTypes[i]);
                ++i;
            }
            this.genericTypesMap = Collections.unmodifiableMap(genericsMap);
        } else if (type instanceof GenericArrayType) {
            this.componentTypes = new CompiledType[]{CompiledType.create(((GenericArrayType)type).getGenericComponentType(), contextHirarchy)};
            this.raw = Array.newInstance(this.componentTypes[0].raw, 0).getClass();
            this.genericTypesMap = EMPTY_MAP;
        } else if (type instanceof WildcardType) {
            this.componentTypes = EMPTY;
            this.raw = null;
            this.genericTypesMap = EMPTY_MAP;
        } else if (type instanceof TypeVariable) {
            this.componentTypes = EMPTY;
            this.raw = null;
            this.genericTypesMap = EMPTY_MAP;
        } else {
            throw new IllegalArgumentException("Unknown type " + type);
        }
        if (this.raw != null) {
            Object superC;
            if (this.raw.isEnum()) {
                this.superType = null;
            } else if (this.isInterface()) {
                superC = this.raw.getGenericInterfaces();
                this.superType = null;
            } else {
                superC = this.raw.getGenericSuperclass();
                this.superType = superC != null && superC != Object.class ? (BREAK_HIERARCHY_AT_TYPES.contains(ReflectionUtils.getRaw((Type)superC)) ? null : CompiledType.create((Type)superC, contextHirarchy)) : null;
            }
        } else {
            this.superType = null;
        }
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && CompiledType.readFromSlowCache(type, contextHirarchy) != null) {
            throw new WTFException("DUPE FOUND");
        }
    }

    private static void putToThreadLocalCache(CompiledType cType) {
        List<CompiledType> list;
        Type type = cType.type;
        HashMap<Type, List<CompiledType>> cache = INIT_CACHE.get();
        if (cache == null) {
            cache = new HashMap();
        }
        if ((list = cache.get(type)) == null) {
            list = new LinkedList<CompiledType>();
            list.add(cType);
            cache.put(type, list);
        } else {
            list.add(cType);
        }
        INIT_CACHE.set(cache);
    }

    public static boolean isThreadLocalCacheEmpty() {
        return INIT_CACHE.get() == null;
    }

    private static void removeFromThreadLocalCache(CompiledType cType) {
        Type type = cType.type;
        HashMap<Type, List<CompiledType>> cache = INIT_CACHE.get();
        if (cache != null) {
            List<CompiledType> list = cache.get(type);
            if (list != null) {
                list.remove(cType);
                if (list.size() == 0) {
                    cache.remove(type);
                }
            }
            if (cache.size() == 0) {
                INIT_CACHE.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pushToSimpleCache(CompiledType cType) {
        CompiledType.removeFromThreadLocalCache(cType);
        if (SIMPLE_CACHE == null) {
            return;
        }
        WeakHashMap<Type, Object> weakHashMap = CACHE;
        synchronized (weakHashMap) {
            CACHE.remove(cType.type);
        }
        weakHashMap = SIMPLE_CACHE;
        synchronized (weakHashMap) {
            WeakHashMap<Type, CompiledType> newSimple = new WeakHashMap<Type, CompiledType>(SIMPLE_CACHE);
            newSimple.put(cType.type, cType);
            SIMPLE_CACHE = newSimple;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putToCache(CompiledType entry) {
        CompiledType.removeFromThreadLocalCache(entry);
        WeakHashMap<Type, List<WeakReference<CompiledType>>> weakHashMap = CACHE;
        synchronized (weakHashMap) {
            List<WeakReference<CompiledType>> list = CACHE.get(entry.type);
            if (list == null) {
                list = new LinkedList<WeakReference<CompiledType>>();
                list.add(new WeakReference<CompiledType>(entry));
                CACHE.put(entry.type, list);
            } else {
                list.add(new WeakReference<CompiledType>(entry));
            }
        }
    }

    public boolean hasGenericsResolvedByContext() {
        return this.genericsResolvedByContext;
    }

    public static CompiledType createFromCompiledHirarchy(Type type, LinkedList<CompiledType> contextHirarchy) {
        return CompiledType.create(type, CompiledType.convert(contextHirarchy));
    }

    public static CompiledType create(Type type, LinkedList<Type> contextHirarchy) {
        CompiledType cached;
        if (type instanceof Class && PRIMITIVES_AND_BASICS != null) {
            for (CompiledType c : PRIMITIVES_AND_BASICS) {
                if (c.type != type) continue;
                return c;
            }
        }
        if (contextHirarchy == null) {
            contextHirarchy = new LinkedList();
            contextHirarchy.add(type);
        }
        if ((cached = CompiledType.readFromCache(type, contextHirarchy)) == null) {
            Object resolvedType = type;
            if (resolvedType instanceof TypeVariable) {
                block1: while (resolvedType instanceof TypeVariable) {
                    Iterator<Type> it = contextHirarchy.descendingIterator();
                    block2: while (it.hasNext()) {
                        Type context = it.next();
                        while (context != null) {
                            if (context instanceof ParameterizedType) {
                                Class<?> raw = ReflectionUtils.getRaw(context);
                                TypeVariable<Class<?>>[] typeParams = raw.getTypeParameters();
                                Type[] actualTypes = ((ParameterizedType)context).getActualTypeArguments();
                                for (int i = 0; i < typeParams.length; ++i) {
                                    if (!typeParams[i].equals(resolvedType)) continue;
                                    resolvedType = actualTypes[i];
                                    continue block1;
                                }
                                context = raw.getGenericSuperclass();
                                continue;
                            }
                            if (!(context instanceof Class)) continue block2;
                            TypeVariable<Class<T>>[] types = ((Class)context).getTypeParameters();
                            if (types != null) {
                                for (TypeVariable pseudoObject : types) {
                                    if (pseudoObject != resolvedType) continue;
                                    resolvedType = Object.class;
                                    continue block1;
                                }
                            }
                            context = ((Class)context).getGenericSuperclass();
                        }
                    }
                    break block1;
                }
                if (contextHirarchy.getLast() != resolvedType) {
                    contextHirarchy.add((Type)resolvedType);
                }
                if ((cached = CompiledType.readFromCache((Type)resolvedType, contextHirarchy)) != null) {
                    return cached;
                }
            }
            cached = new CompiledType((Type)resolvedType, contextHirarchy);
            if (CompiledType.requiresContextToResolveGenerics((Type)resolvedType)) {
                CompiledType.pushToSimpleCache(cached);
            } else {
                CompiledType.putToCache(cached);
            }
        }
        return cached;
    }

    private static boolean requiresContextToResolveGenerics(Type t) {
        if (t instanceof WildcardType) {
            return true;
        }
        if (t instanceof Class) {
            return true;
        }
        if (t instanceof ParameterizedType) {
            for (Type e : ((ParameterizedType)t).getActualTypeArguments()) {
                if (CompiledType.requiresContextToResolveGenerics(e)) continue;
                return false;
            }
            return true;
        }
        if (t instanceof GenericArrayType) {
            return CompiledType.requiresContextToResolveGenerics(((GenericArrayType)t).getGenericComponentType());
        }
        return false;
    }

    private static CompiledType readFromCache(Type type, LinkedList<Type> contextHirarchy) {
        List<CompiledType> list;
        CompiledType direct;
        if (SIMPLE_CACHE != null && (direct = SIMPLE_CACHE.get(type)) != null) {
            return direct;
        }
        HashMap<Type, List<CompiledType>> threadLocalCache = INIT_CACHE.get();
        if (threadLocalCache != null && (list = threadLocalCache.get(type)) != null) {
            for (CompiledType eType : list) {
                if (type instanceof Class && ((Class)type).getTypeParameters().length == 0) {
                    return eType;
                }
                if (type instanceof WildcardType) {
                    return eType;
                }
                if (eType.contextHirarchy.size() != contextHirarchy.size() || !eType.contextHirarchy.equals(contextHirarchy)) continue;
                return eType;
            }
        }
        return CompiledType.readFromSlowCache(type, contextHirarchy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompiledType readFromSlowCache(Type type, LinkedList<Type> contextHirarchy) {
        WeakHashMap<Type, List<WeakReference<CompiledType>>> weakHashMap = CACHE;
        synchronized (weakHashMap) {
            List<WeakReference<CompiledType>> list = CACHE.get(type);
            if (list == null) {
                return null;
            }
            Iterator<WeakReference<CompiledType>> it = list.iterator();
            while (it.hasNext()) {
                CompiledType eType = (CompiledType)it.next().get();
                if (eType == null) {
                    it.remove();
                    continue;
                }
                if (type instanceof Class && ((Class)type).getTypeParameters().length == 0) {
                    return eType;
                }
                if (type instanceof WildcardType) {
                    return eType;
                }
                if (eType.contextHirarchy.size() != contextHirarchy.size() || !eType.contextHirarchy.equals(contextHirarchy)) continue;
                return eType;
            }
        }
        return null;
    }

    public static CompiledType create(Type type, Type context) {
        LinkedList<Type> contextHirarchy = new LinkedList<Type>();
        contextHirarchy.add(context);
        if (type != context) {
            contextHirarchy.add(type);
        }
        return CompiledType.create(type, contextHirarchy);
    }

    public static CompiledType create(Type type) {
        return CompiledType.create(type, (LinkedList<Type>)null);
    }

    public static CompiledType create(TypeRef<?> typeRef) {
        return CompiledType.create(typeRef.getType());
    }

    public CompiledType resolveGenericType(Type fieldType) {
        CompiledType lookup = this;
        while (lookup != null) {
            CompiledType ret = lookup.genericTypesMap.get(fieldType);
            if (ret != null) {
                return ret;
            }
            lookup = lookup.superType;
        }
        return null;
    }

    public static CompiledType create(LinkedList<Type> typeHirarchy) {
        return CompiledType.create(typeHirarchy.getLast(), typeHirarchy);
    }

    public boolean isAnyOf(Type ... classes) {
        for (Type c : classes) {
            if (c != this && c != this.type) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimitive() {
        return Clazz.isPrimitive(this.type);
    }

    public boolean isNoneOf(Type ... classes) {
        for (Type c : classes) {
            if (c != this && c != this.type) continue;
            return false;
        }
        return true;
    }

    public boolean isEnum(boolean autoSkipAnonymous) {
        if (this.raw == null) {
            return false;
        }
        if (autoSkipAnonymous) {
            if (this.isEnum == null) {
                this.isEnum = Clazz.isEnum(this.raw);
            }
            return this.isEnum;
        }
        return this.type instanceof Class && ((Class)this.type).isEnum();
    }

    public boolean isArray() {
        return this.raw != null && this.raw.isArray();
    }

    public boolean isInstanceOf(Type ... types) {
        if (this.raw == null) {
            return false;
        }
        for (Type b : types) {
            if (!(b instanceof Class) || !((Class)b).isAssignableFrom(this.raw)) continue;
            return true;
        }
        return false;
    }

    public boolean isBoolean() {
        return this == BOOLEAN_PRIMITIVE || this == BOOLEAN_WRAPPER;
    }

    public boolean isNumber() {
        return Clazz.isNumberType(this.type);
    }

    public boolean isFixedPointNumber() {
        return Clazz.isFixedPointNumber(this.type);
    }

    public boolean isFloatingPointNumber() {
        return Clazz.isFloatingPointNumber(this.type);
    }

    public boolean isString() {
        return this == STRING;
    }

    public boolean isCollection() {
        return this.raw != null && Collection.class.isAssignableFrom(this.raw);
    }

    public boolean isInterface() {
        return this.raw != null && this.raw.isInterface();
    }

    public boolean isMap() {
        return this.raw != null && Map.class.isAssignableFrom(this.raw);
    }

    public boolean isSet() {
        return this.raw != null && Set.class.isAssignableFrom(this.raw);
    }

    public boolean isList() {
        return this.raw != null && List.class.isAssignableFrom(this.raw);
    }

    public CompiledType[] getComponentTypes(Class<?> class1) {
        CompiledType superClass = this.getAssignableSuperClass(class1);
        if (superClass == null) {
            return null;
        }
        return superClass.componentTypes;
    }

    public CompiledType getAssignableSuperClass(Class<?> class1) {
        LinkedList<CompiledType> cl = this.getTypeHirarchy();
        Iterator<CompiledType> it = cl.descendingIterator();
        while (it.hasNext()) {
            CompiledType next = it.next();
            if (next.raw == null || !class1.isAssignableFrom(next.raw)) continue;
            return next;
        }
        return null;
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        if (this.raw == null) {
            throw new InstantiationException("Cannot create an instance of " + this);
        }
        return this.raw.newInstance();
    }

    public Object newArrayInstance(int size) {
        return Array.newInstance(this.raw, size);
    }

    public boolean isObject() {
        return this == OBJECT;
    }

    public ClassCache getClassCache() {
        if (this.classCache != null) {
            return this.classCache;
        }
        try {
            this.classCache = ClassCache.getClassCache(this.raw);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        return this.classCache;
    }

    public boolean isCharacter() {
        return this == CHAR_PRIMITIVE || this == CHAR_WRAPPER;
    }

    public boolean isPrimitiveWrapper() {
        return Clazz.isPrimitiveWrapper(this.type);
    }

    public static CompiledType createFromCompiledHirarchy(List<CompiledType> typeHirarchy) {
        return CompiledType.create(CompiledType.convert(typeHirarchy));
    }

    public static LinkedList<Type> convert(List<CompiledType> typeHirarchy) {
        LinkedList<Type> hir = new LinkedList<Type>();
        for (CompiledType ct : typeHirarchy) {
            hir.add(ct.type);
        }
        return hir;
    }

    public static CompiledType create(Type type, CompiledType context) {
        return CompiledType.create(type, context == null ? null : CompiledType.convert(context.getTypeHirarchy()));
    }

    public boolean isContainer() {
        if (this.isString()) {
            return false;
        }
        if (this.isPrimitive()) {
            return false;
        }
        return !this.isEnum(true);
    }

    public boolean isObjectContainer() {
        if (this.isString()) {
            return false;
        }
        if (this.isPrimitive()) {
            return false;
        }
        if (this.isEnum(true)) {
            return false;
        }
        if (this.isArray()) {
            return false;
        }
        return !this.isCollection();
    }

    public boolean isListContainer() {
        return this.isArray() || this.isCollection();
    }

    public CompiledType getComponentTypeFor(Class<?> ... interfaces) {
        for (Class<?> t : interfaces) {
            if (t == Array.class) {
                if (!this.isArray()) continue;
                return this.componentTypes[0];
            }
            if (!this.isInstanceOf(t)) continue;
            CompiledType[] types = this.getComponentTypes(t);
            if (CompiledType.create(t).isMap()) {
                if (types.length == 2) {
                    return types[1];
                }
            } else if (types.length == 1) {
                return types[0];
            }
            return OBJECT;
        }
        return null;
    }

    public CompiledType resolve(JSPath path) throws CannotResolvePathException {
        CompiledType ret = this;
        for (Object o : path.getElements()) {
            if (ret.isListContainer()) {
                if (o instanceof Number) {
                    ret = ret.getComponentTypeFor(Collection.class, Array.class);
                    continue;
                }
                throw new CannotResolvePathException();
            }
            if (ret.isMap()) {
                if (o instanceof String) {
                    ret = ret.getComponentTypeFor(Map.class);
                    continue;
                }
                throw new CannotResolvePathException();
            }
            if (!ret.isObjectContainer()) continue;
            if (o instanceof String) {
                Property prop = ret.getClassCache().getProperty((String)o);
                if (prop == null) {
                    throw new CannotResolvePathException();
                }
                Type genType = prop.getGenericType();
                ret = CompiledType.create(genType, ret.contextHirarchy);
                DebugMode.breakIf(prop.type.raw != Object.class && prop.type.raw != ret.raw, new Object[0]);
                continue;
            }
            throw new CannotResolvePathException();
        }
        return ret;
    }

    public Object[] getEnumValues() {
        CompiledType search = this;
        while (search.raw == null) {
            search = search.superType;
        }
        return search.raw.getEnumConstants();
    }

    public Field getField(String key) {
        if (StringUtils.isEmpty(key)) {
            return null;
        }
        CompiledType search = this;
        while (search != null) {
            Field ret = search.getDeclaredField(key);
            if (ret != null) {
                return ret;
            }
            search = search.superType;
        }
        return null;
    }

    private Field getDeclaredField(String key) {
        if (this.raw == null) {
            return null;
        }
        if (StringUtils.isEmpty(key)) {
            return null;
        }
        try {
            return this.raw.getDeclaredField(key);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public final int getListLength(Object object) {
        if (this.isArray()) {
            return Array.getLength(object);
        }
        if (this.isCollection()) {
            return ((Collection)object).size();
        }
        throw new IllegalStateException(object + " is no List");
    }

    public List<Object> getListElements(Object object) {
        if (this.isListContainer()) {
            ArrayList<Object> ret = new ArrayList<Object>();
            if (this.isArray()) {
                for (int i = 0; i < this.getListLength(object); ++i) {
                    ret.add(Array.get(object, i));
                }
            } else if (this.isCollection()) {
                for (Object o : (Collection)object) {
                    ret.add(o);
                }
            }
            return ret;
        }
        return null;
    }

    public Object getListElement(Object object, int i) {
        if (this.isListContainer()) {
            if (this.isArray()) {
                return Array.get(object, i);
            }
            if (this.isInstanceOf(new Type[]{List.class})) {
                return ((List)object).get(i);
            }
            if (this.isCollection()) {
                for (Object o : (Collection)object) {
                    if (i == 0) {
                        return 0;
                    }
                    --i;
                }
            }
        }
        return null;
    }

    public boolean hasAnnotation(Class<? extends Annotation> ... annotations) {
        if (this.raw == null) {
            return false;
        }
        for (Class<? extends Annotation> a : annotations) {
            if (this.getClassCache().getAnnotations(null, a).size() <= 0) continue;
            return true;
        }
        return false;
    }

    public List<Method> listMethods() {
        return CompiledType.listMethods(this.raw);
    }

    private static List<Method> listMethods(Class<?> c) {
        ArrayList<Method> ret = new ArrayList<Method>();
        while (c != null) {
            for (Class<?> i : c.getInterfaces()) {
                ret.addAll(CompiledType.listMethods(i));
            }
            ret.addAll(Arrays.asList(c.getDeclaredMethods()));
            c = c.getSuperclass();
        }
        return ret;
    }

    public CompiledType getComponentType() {
        return this.getComponentTypeFor(this.raw);
    }

    static {
        BREAK_HIERARCHY_AT_TYPES = new HashSet();
        SIMPLE_CACHE = new WeakHashMap();
        CACHE = new WeakHashMap();
        BOOLEAN_PRIMITIVE = CompiledType.create(Boolean.TYPE);
        BOOLEAN_WRAPPER = CompiledType.create(Boolean.class);
        STRING = CompiledType.create(String.class);
        DOUBLE_PRIMITIVE = CompiledType.create(Double.TYPE);
        DOUBLE_WRAPPER = CompiledType.create(Double.class);
        INT_PRIMITIVE = CompiledType.create(Integer.TYPE);
        INT_WRAPPER = CompiledType.create(Integer.class);
        FLOAT_PRIMITIVE = CompiledType.create(Float.TYPE);
        FLOAT_WRAPPER = CompiledType.create(Float.class);
        LONG_PRIMITIVE = CompiledType.create(Long.TYPE);
        LONG_WRAPPER = CompiledType.create(Long.class);
        BYTE_PRIMITIVE = CompiledType.create(Byte.TYPE);
        BYTE_WRAPPER = CompiledType.create(Byte.class);
        SHORT_PRIMITIVE = CompiledType.create(Short.TYPE);
        SHORT_WRAPPER = CompiledType.create(Short.class);
        CHAR_PRIMITIVE = CompiledType.create(Character.TYPE);
        CHAR_WRAPPER = CompiledType.create(Character.class);
        OBJECT = CompiledType.create(Object.class);
        BREAK_HIERARCHY_AT_TYPES.add(AbstractMap.class);
        BREAK_HIERARCHY_AT_TYPES.add(AbstractSet.class);
        BREAK_HIERARCHY_AT_TYPES.add(AbstractList.class);
        ArrayList<Object> staticList = new ArrayList<Object>();
        for (Map.Entry<Type, List<WeakReference<CompiledType>>> f : CACHE.entrySet()) {
            if (!Clazz.isPrimitive(f.getKey()) && f.getKey() != String.class) continue;
            staticList.add(f.getValue().get(0).get());
            CACHE.remove(f.getKey());
            SIMPLE_CACHE.remove(f.getKey());
        }
        staticList.add(OBJECT);
        PRIMITIVES_AND_BASICS = staticList;
    }

    public static class ToStringRule {
        private boolean skipAnonymousClasses = false;
        private PrimitiveWrapperStrategy primitiveWrapperStrategy = PrimitiveWrapperStrategy.DEDICATED_NAME_FOR_EACH;
        private String nameForArrays = "Array";
        private String nameForUnspecifiedGeneric = "?";
        private ToStringSyntax syntax = ToStringSyntax.JSON;
        private String postFixForEnums = "-Enum";
        private String nameForMaps = "Map";

        public ToStringRule(ToStringSyntax java) {
            this.setSyntax(java);
        }

        public ToStringRule() {
        }

        public ToStringSyntax getSyntax() {
            return this.syntax;
        }

        public ToStringRule syntax(ToStringSyntax syntax) {
            this.syntax = syntax;
            return this;
        }

        public void setSyntax(ToStringSyntax syntax) {
            this.syntax = syntax;
        }

        public String getNameForUnspecifiedGeneric() {
            return this.nameForUnspecifiedGeneric;
        }

        public void setNameForUnspecifiedGeneric(String nameForUnspecifiedGeneric) {
            this.nameForUnspecifiedGeneric = nameForUnspecifiedGeneric;
        }

        public String getNameForArrays() {
            return this.nameForArrays;
        }

        public void setNameForArrays(String nameForArrays) {
            this.nameForArrays = nameForArrays;
        }

        public String getNameForMaps() {
            return this.nameForMaps;
        }

        public void setNameForMaps(String nameForMaps) {
            this.nameForMaps = nameForMaps;
        }

        public String getPostFixForEnums() {
            return this.postFixForEnums;
        }

        public void setPostFixForEnums(String postFixForEnums) {
            this.postFixForEnums = postFixForEnums;
        }

        public boolean isSkipAnonymousClasses() {
            return this.skipAnonymousClasses;
        }

        public void setSkipAnonymousClasses(boolean skipAnonymousClasses) {
            this.skipAnonymousClasses = skipAnonymousClasses;
        }

        public ToStringRule skipAnonymousClasses(boolean skipAnonymousClasses) {
            this.skipAnonymousClasses = skipAnonymousClasses;
            return this;
        }

        public PrimitiveWrapperStrategy getPrimitiveWrapperStrategy() {
            return this.primitiveWrapperStrategy;
        }

        public void setPrimitiveWrapperStrategy(PrimitiveWrapperStrategy primitiveWrapperStrategy) {
            this.primitiveWrapperStrategy = primitiveWrapperStrategy;
        }

        public ToStringRule primitiveWrapperStrategy(PrimitiveWrapperStrategy primitiveWrapperStrategy) {
            this.primitiveWrapperStrategy = primitiveWrapperStrategy;
            return this;
        }
    }

    public static enum ToStringSyntax {
        JSON,
        JAVA;

    }

    public static enum PrimitiveWrapperStrategy {
        DEDICATED_NAME_FOR_EACH,
        PRIMITIVE_NAMES_FOR_BOTH,
        WRAPPER_NAMES_FOR_BOTH;

    }
}

