/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.reflection;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class Clazz {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP = new HashMap();
    private static final Map<Class<?>, Class<?>> WRAPPER_PRIMITIVE_MAP;

    public static boolean isBoolean(Type type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }

    public static boolean isByte(Type type) {
        return type == Byte.class || type == Byte.TYPE;
    }

    public static boolean isCharacter(Type type) {
        return type == Character.class || type == Character.TYPE;
    }

    public static boolean isDouble(Type type) {
        return type == Double.class || type == Double.TYPE;
    }

    public static boolean isFloat(Type type) {
        return type == Float.class || type == Float.TYPE;
    }

    public static boolean isInteger(Type type) {
        return type == Integer.class || type == Integer.TYPE;
    }

    public static boolean isLong(Type type) {
        return type == Long.class || type == Long.TYPE;
    }

    public static boolean isPrimitive(Type type) {
        if (type instanceof Class) {
            return ((Class)type).isPrimitive() || Clazz.isPrimitiveWrapper(type);
        }
        return false;
    }

    public static boolean isPrimitiveWrapper(Type type) {
        return type == Boolean.class || type == Integer.class || type == Long.class || type == Byte.class || type == Short.class || type == Float.class || type == Double.class || type == Character.class || type == Void.class;
    }

    public static boolean isShort(Type type) {
        return type == Short.class || type == Short.TYPE;
    }

    public static boolean isVoid(Type type) {
        return type == Void.class || type == Void.TYPE;
    }

    public static boolean isString(Type type) {
        return type == String.class;
    }

    public static boolean isEnum(Type type) {
        return (type = Clazz.getNonAnonymousType(type)) instanceof Class && ((Class)type).isEnum();
    }

    public static Type getNonAnonymousType(Type type) {
        if (type instanceof Class && ((Class)type).isAnonymousClass()) {
            return ((Class)type).getGenericSuperclass();
        }
        return type;
    }

    public static boolean isInstanceof(Type a, Class<?> b) {
        if (a instanceof Class) {
            boolean ret = b.isAssignableFrom((Class)a);
            return ret;
        }
        return false;
    }

    public static boolean isArray(Type type) {
        return type instanceof Class && ((Class)type).isArray();
    }

    public static boolean isFixedPointNumber(Type a) {
        try {
            Class ac = (Class)a;
            if (ac.isPrimitive()) {
                return a != Float.TYPE && a != Double.TYPE && a != Void.TYPE && a != Boolean.TYPE && a != Character.TYPE;
            }
            if (Number.class.isAssignableFrom(ac)) {
                return a != Float.class && a != Double.class && !BigDecimal.class.isAssignableFrom(ac);
            }
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static boolean isNumberType(Type a) {
        if (!(a instanceof Class)) {
            return false;
        }
        if (((Class)a).isPrimitive()) {
            return a != Void.TYPE && a != Boolean.TYPE && a != Character.TYPE;
        }
        return Number.class.isAssignableFrom((Class)a);
    }

    public static boolean isFloatingPointNumber(Type a) {
        try {
            Class ac = (Class)a;
            if (ac.isPrimitive()) {
                return a == Double.TYPE || a == Float.TYPE;
            }
            return a == Double.class || a == Float.class || BigDecimal.class.isAssignableFrom(ac);
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static boolean objectIsTypeOf(Object p, Class<?> expected) {
        if (expected.isPrimitive() && p == null) {
            return false;
        }
        if (p == null) {
            return true;
        }
        return Clazz.isAssignable(p.getClass(), expected);
    }

    public static boolean isAssignable(Class<?> from, Class<?> to) {
        if (to.isAssignableFrom(from)) {
            return true;
        }
        if (from.isPrimitive() && PRIMITIVE_WRAPPER_MAP.get(from) == to) {
            return true;
        }
        return to.isPrimitive() && PRIMITIVE_WRAPPER_MAP.get(to) == from;
    }

    public static boolean equalsIgnorePrimitive(Type a, Type b) {
        return Clazz.primitiveToWrapper(a).equals(Clazz.primitiveToWrapper(b));
    }

    public static Type primitiveToWrapper(Type a) {
        Class<?> ret = PRIMITIVE_WRAPPER_MAP.get(a);
        if (ret != null) {
            return ret;
        }
        return a;
    }

    public static Class<?> wrapperToPrimitive(Class<?> a) {
        Class<?> ret = WRAPPER_PRIMITIVE_MAP.get(a);
        if (ret != null) {
            return ret;
        }
        return a;
    }

    public static Object getDefaultValue(Class<?> returnType) {
        if (returnType == Byte.TYPE) {
            return (byte)0;
        }
        if (returnType == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (returnType == Short.TYPE) {
            return (short)0;
        }
        if (returnType == Integer.TYPE) {
            return 0;
        }
        if (returnType == Long.TYPE) {
            return 0L;
        }
        if (returnType == Double.TYPE) {
            return 0.0;
        }
        if (returnType == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (returnType == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    static {
        PRIMITIVE_WRAPPER_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPER_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPER_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER_MAP.put(Short.TYPE, Short.class);
        WRAPPER_PRIMITIVE_MAP = new HashMap();
        WRAPPER_PRIMITIVE_MAP.put(Boolean.class, Boolean.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Byte.class, Byte.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Character.class, Character.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Double.class, Double.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Float.class, Float.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Integer.class, Integer.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Long.class, Long.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Short.class, Short.TYPE);
    }
}

