/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.processes.command;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ProcessStream
extends InputStream {
    protected final Process process;
    protected final AtomicBoolean processAliveFlag = new AtomicBoolean(true);
    protected final InputStream is;
    protected final AtomicBoolean closedFlag = new AtomicBoolean(false);

    public Process getProcess() {
        return this.process;
    }

    protected ProcessStream(Process process, InputStream is) {
        this.process = process;
        this.is = is;
        new Thread(this.getClass().getName() + "WaitForProcess:" + process){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    ProcessStream.this.notifyProcessTerminated(ProcessStream.this.getProcess().waitFor());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyProcessTerminated(int exitCode) {
        if (this.processAliveFlag.compareAndSet(true, false)) {
            AtomicBoolean atomicBoolean = this.processAliveFlag;
            synchronized (atomicBoolean) {
                this.processAliveFlag.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        byte[] ret = new byte[1];
        int read;
        while ((read = this.read(ret, 0, 1)) != -1) {
            if (read == 1) {
                return ret[0] & 0xFF;
            }
            if (read != 0) continue;
            try {
                AtomicBoolean atomicBoolean = this.processAliveFlag;
                synchronized (atomicBoolean) {
                    if (this.processAliveFlag.get()) {
                        this.processAliveFlag.wait(10L);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        return -1;
    }

    public boolean isProcessAlive() {
        if (!this.processAliveFlag.get()) {
            return false;
        }
        try {
            this.notifyProcessTerminated(this.getProcess().exitValue());
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    @Override
    public int available() throws IOException {
        int ret = this.is.available();
        if (ret > 0) {
            return ret;
        }
        if (!this.isProcessAlive()) {
            throw new IOException("process is terminated");
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        if (this.closedFlag.compareAndSet(false, true)) {
            Thread thread = new Thread(this.getClass().getName() + "WaitForClose:"){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    try {
                        ProcessStream.this.is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
            try {
                thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int next;
        try {
            next = this.available();
        }
        catch (IOException e) {
            if (this.isProcessAlive()) {
                throw e;
            }
            return -1;
        }
        if (next <= 0) {
            if (this.isProcessAlive()) {
                return 0;
            }
            return -1;
        }
        return this.is.read(b, off, Math.min(next, len));
    }
}

