/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.processes.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.appwork.utils.processes.ProcessOutput;
import org.appwork.utils.processes.command.AsyncInputStreamHandler;
import org.appwork.utils.processes.command.OutputHandler;
import org.appwork.utils.processes.command.ProcessErrorStream;
import org.appwork.utils.processes.command.ProcessInputStream;
import org.appwork.utils.processes.command.ProcessStreamReader;

public class ProcessOutputHandler
implements OutputHandler {
    private ByteArrayOutputStream baoErr;
    private ByteArrayOutputStream baoStd;
    private Charset charset;
    private int exitCode = -1;

    protected boolean killProcessInFinally(ProcessStreamReader streamReader, Exception e) {
        return false;
    }

    protected boolean ignoreOutputStreamException(ProcessStreamReader streamReader, IOException e) {
        return true;
    }

    @Override
    public AsyncInputStreamHandler createAsyncStreamHandler(ProcessInputStream inputStream, Charset charset) throws UnsupportedEncodingException, InterruptedException {
        this.baoStd = new ByteArrayOutputStream();
        this.charset = charset;
        Process process = inputStream.getProcess();
        return new ProcessStreamReader("Process-Reader-Std:" + process, process, inputStream, this.baoStd){

            @Override
            protected boolean ignoreOutputStreamException(IOException e) {
                return ProcessOutputHandler.this.ignoreOutputStreamException(this, e);
            }

            @Override
            protected boolean killProcessInFinally(Exception e) {
                return ProcessOutputHandler.this.killProcessInFinally(this, e);
            }
        };
    }

    @Override
    public AsyncInputStreamHandler createAsyncStreamHandler(ProcessErrorStream errorStream, Charset charset) throws UnsupportedEncodingException, InterruptedException {
        this.baoErr = new ByteArrayOutputStream();
        this.charset = charset;
        Process process = errorStream.getProcess();
        return new ProcessStreamReader("Process-Reader-Error:" + process, process, errorStream, this.baoErr){

            @Override
            protected boolean ignoreOutputStreamException(IOException e) {
                return ProcessOutputHandler.this.ignoreOutputStreamException(this, e);
            }

            @Override
            protected boolean killProcessInFinally(Exception e) {
                return ProcessOutputHandler.this.killProcessInFinally(this, e);
            }
        };
    }

    public ProcessOutput getResult() {
        return new ProcessOutput(this.exitCode, this.baoStd, this.baoErr, this.charset.name());
    }

    @Override
    public void onExitCode(int exitCode) {
        this.exitCode = exitCode;
    }
}

