/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.processes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.processes.ProcessBuilderFactory;

public class ProcessRestarter {
    public static void restartApplication(File jar, String ... parameters) {
        try {
            LogV3.info("restartApplication " + jar + " " + parameters.length);
            ArrayList<String> nativeParameters = new ArrayList<String>();
            File runin = null;
            if (CrossSystem.isMac()) {
                Object rootpath;
                HashSet<String[]> loopMap = new HashSet<String[]>();
                for (rootpath = jar; rootpath != null && loopMap.add((String[])rootpath) && !((File)rootpath).getName().endsWith(".app"); rootpath = ((File)rootpath).getParentFile()) {
                }
                if (((File)rootpath).getName().endsWith(".app")) {
                    nativeParameters.add("open");
                    nativeParameters.add("-n");
                    nativeParameters.add(((File)rootpath).getAbsolutePath());
                    runin = ((File)rootpath).getParentFile();
                }
            }
            if (nativeParameters.isEmpty()) {
                LogV3.info("Find Jarfile");
                String[] jarFile = jar;
                LogV3.info("Find Jarfile " + jarFile);
                runin = jarFile.getParentFile();
                if (CrossSystem.isWindows() || CrossSystem.isOS2()) {
                    File exeFile = new File(jarFile.getParentFile(), jarFile.getName().substring(0, jarFile.getName().length() - 4) + ".exe");
                    if (exeFile.exists()) {
                        nativeParameters.add(exeFile.getAbsolutePath());
                    } else {
                        nativeParameters.add(CrossSystem.getJavaBinary());
                        nativeParameters.add("-jar");
                        nativeParameters.add(jarFile.getAbsolutePath());
                    }
                } else {
                    nativeParameters.add(CrossSystem.getJavaBinary());
                    nativeParameters.add("-jar");
                    nativeParameters.add(jarFile.getAbsolutePath());
                }
            }
            if (parameters != null) {
                for (String s : parameters) {
                    nativeParameters.add(s);
                }
            }
            LogV3.info("Start " + nativeParameters);
            final ProcessBuilder pb = ProcessBuilderFactory.create(nativeParameters.toArray(new String[0]));
            LogV3.info("Root: " + runin);
            if (runin != null) {
                pb.directory(runin);
            }
            ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){
                {
                    this.setHookPriority(Integer.MIN_VALUE);
                }

                @Override
                public void onShutdown(ShutdownRequest shutdownRequest) {
                    try {
                        pb.start();
                    }
                    catch (IOException e) {
                        LogV3.log(e);
                    }
                }
            });
            LogV3.info("Start " + ShutdownController.getInstance().requestShutdown(true));
        }
        catch (Throwable e) {
            throw new WTFException(e);
        }
    }
}

