/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.processes;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Exceptions;

public class ProcessOutput {
    private final int exitCode;
    private final ByteArrayOutputStream stdOutData;
    private final ByteArrayOutputStream errOutData;
    private final String codePage;

    public ByteArrayOutputStream getStdOutData() {
        return this.stdOutData;
    }

    public ByteArrayOutputStream getErrOutData() {
        return this.errOutData;
    }

    public ProcessOutput(int exitCode, ByteArrayOutputStream stdOut, ByteArrayOutputStream errOut, String codePage) {
        this.exitCode = exitCode;
        this.stdOutData = stdOut;
        this.errOutData = errOut;
        this.codePage = codePage;
    }

    public String toString() {
        return "Exitcode: " + this.getExitCode() + " STD:" + this.getStdOutString() + " ERR:" + this.getErrOutString();
    }

    public String getStdOutString(String charset) throws UnsupportedEncodingException {
        return this.getStdOutData().toString(charset);
    }

    public String getErrOutString(String charset) throws UnsupportedEncodingException {
        return this.getErrOutData().toString(charset);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getStdOutString() {
        try {
            return this.getStdOutString(this.codePage);
        }
        catch (UnsupportedEncodingException e) {
            try {
                return this.getStdOutString("UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                throw Exceptions.addSuppressed(new WTFException(e2), e);
            }
        }
    }

    public String getErrOutString() {
        try {
            return this.getErrOutString(this.codePage);
        }
        catch (UnsupportedEncodingException e) {
            try {
                return this.getErrOutString("UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                throw Exceptions.addSuppressed(new WTFException(e2), e);
            }
        }
    }
}

