/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.processes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.appwork.utils.net.LineParsingInputStream;
import org.appwork.utils.net.LineParsingOutputStream;
import org.appwork.utils.processes.LineHandler;

public class ContinuesFileLineReader {
    protected final File file;
    protected final AtomicBoolean closedFlag = new AtomicBoolean(false);
    protected AtomicReference<Thread> thread = new AtomicReference<Object>(null);
    protected final LineHandler sink;
    protected final Charset charset;
    private volatile IOException exceptionIOException;
    protected volatile boolean started = false;

    public File getFile() {
        return this.file;
    }

    public ContinuesFileLineReader(LineHandler sink, String path, Charset charset) {
        if (sink == null) {
            throw new IllegalArgumentException("Sink missing");
        }
        this.file = new File(path);
        this.sink = sink;
        this.charset = charset == null ? Charset.forName("UTF-8") : charset;
    }

    public synchronized ContinuesFileLineReader run() {
        Thread thread = this.thread.get();
        if (thread != null && thread.isAlive()) {
            return this;
        }
        this.closedFlag.compareAndSet(true, false);
        this.exceptionIOException = null;
        thread = new Thread("Read " + this.file){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block18: {
                    try {
                        while (!ContinuesFileLineReader.this.file.exists() && !ContinuesFileLineReader.this.isClosed()) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                ContinuesFileLineReader.this.thread.compareAndSet(Thread.currentThread(), null);
                                return;
                            }
                        }
                        ContinuesFileLineReader.this.started = true;
                        if (ContinuesFileLineReader.this.isClosed()) break block18;
                        try {
                            FileInputStream fis = new FileInputStream(ContinuesFileLineReader.this.file);
                            try {
                                LineParsingInputStream is = new LineParsingInputStream(fis, ContinuesFileLineReader.this.charset){

                                    @Override
                                    protected void onNextLine(LineParsingOutputStream.NEWLINE newLine, long line, StringBuilder sb, int startIndex, int endIndex) {
                                        ContinuesFileLineReader.this.onNextLine(newLine, line, sb, startIndex, endIndex);
                                    }
                                };
                                try {
                                    byte[] buf = new byte[Short.MAX_VALUE];
                                    while (!ContinuesFileLineReader.this.isClosed()) {
                                        int read = is.read(buf);
                                        if (read > 0) continue;
                                        if (ContinuesFileLineReader.this.isClosed()) {
                                            break;
                                        }
                                        ContinuesFileLineReader.this.onWait(read, is.getLines());
                                    }
                                }
                                finally {
                                    is.close();
                                }
                            }
                            finally {
                                fis.close();
                            }
                        }
                        catch (IOException e) {
                            ContinuesFileLineReader.this.exceptionIOException = e;
                        }
                        catch (InterruptedException e) {
                            ContinuesFileLineReader.this.thread.compareAndSet(Thread.currentThread(), null);
                            return;
                        }
                    }
                    finally {
                        ContinuesFileLineReader.this.thread.compareAndSet(Thread.currentThread(), null);
                    }
                }
            }
        };
        this.thread.set(thread);
        thread.start();
        return this;
    }

    public boolean isClosed() {
        return this.closedFlag.get();
    }

    public void closeAndFlush() throws InterruptedException, IOException {
        Thread thread = this.thread.get();
        try {
            if (this.closedFlag.compareAndSet(false, true)) {
                if (!this.started && thread != null) {
                    thread.interrupt();
                }
                if (thread != null) {
                    thread.join();
                }
                if (this.exceptionIOException != null) {
                    throw this.exceptionIOException;
                }
            }
        }
        catch (InterruptedException e) {
            if (thread != null) {
                thread.interrupt();
            }
            throw e;
        }
    }

    protected void onWait(int read, long lines) throws InterruptedException {
        Thread.sleep(50L);
    }

    protected void onNextLine(LineParsingOutputStream.NEWLINE newLine, long line, StringBuilder sb, int startIndex, int endIndex) {
        this.sink.handleLine(sb.substring(startIndex, endIndex), this);
    }
}

