/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os.hardware;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.hardware.HardwareTypeInterface;

public abstract class Synology
implements HardwareTypeInterface {
    @Override
    public HardwareTypeInterface.ID getHardwareType() {
        return HardwareTypeInterface.ID.SYNOLOGY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Synology getSynologyDetails() {
        File cpuInfo;
        if (CrossSystem.isLinux() && (cpuInfo = new File("/proc/sys/kernel/syno_hw_version")).isFile()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(cpuInfo);
                BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                String line = null;
                while ((line = is.readLine()) != null && !StringUtils.isNotEmpty(line)) {
                }
                is.close();
                if (StringUtils.isNotEmpty(line)) {
                    Synology synology = Synology.parse(line);
                    return synology;
                }
            }
            catch (Throwable ignore) {
                ignore.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return null;
    }

    private static Synology parse(final String hardware) {
        return new Synology(){

            @Override
            public String getModel() {
                return hardware;
            }
        };
    }

    public String toString() {
        return "Synology|Model:" + this.getModel();
    }

    private Synology() {
    }

    public abstract String getModel();
}

