/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os.hardware;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.hardware.HardwareTypeInterface;

public abstract class RaspberryPi
implements HardwareTypeInterface {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RaspberryPi getRaspberryPiDetails() {
        if (!CrossSystem.isUnix()) return null;
        if (!CrossSystem.ARCHFamily.ARM.equals((Object)CrossSystem.getARCHFamily())) return null;
        File cpuInfo = new File("/proc/cpuinfo");
        if (!cpuInfo.isFile()) return null;
        try {
            FileInputStream fis = new FileInputStream(cpuInfo);
            try {
                String raspberryPIModel = null;
                String raspberryPIHardware = null;
                String revision = null;
                BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                try {
                    String line;
                    while ((line = is.readLine()) != null) {
                        if (StringUtils.startsWithCaseInsensitive(line, "Model")) {
                            raspberryPIModel = new Regex(line, "(?i)^\\s*Model\\s*:\\s*(Raspberry.*?)(\r|\n|$)").getMatch(0);
                        } else if (StringUtils.startsWithCaseInsensitive(line, "Hardware")) {
                            raspberryPIHardware = new Regex(line, "(?i)^\\s*Hardware\\s*:\\s*(BCM[0-9a-zA-Z]+)").getMatch(0);
                        } else if (StringUtils.startsWithCaseInsensitive(line, "Revision")) {
                            revision = new Regex(line, "(?i)^\\s*Revision\\s*:\\s*([0-9a-fA-F]+)").getMatch(0);
                        }
                        if (raspberryPIModel == null || revision == null) continue;
                        break;
                    }
                }
                finally {
                    is.close();
                }
                if (raspberryPIModel == null) {
                    if (raspberryPIHardware == null) return null;
                }
                if (revision == null) return null;
                RaspberryPi raspberryPi = RaspberryPi.parse(revision);
                return raspberryPi;
            }
            finally {
                fis.close();
            }
        }
        catch (Throwable ignore) {
            ignore.printStackTrace();
        }
        return null;
    }

    private RaspberryPi() {
    }

    public static void main(String[] args) {
        System.out.println(RaspberryPi.getRaspberryPiDetails());
    }

    private static RaspberryPi parse(final String revision) {
        if (revision != null && revision.matches("^[a-fA-F0-9]+$")) {
            boolean oldStyleRevision;
            Long revisionLong;
            if (revision.matches("^10000[0-9a-fA-F]{2}$")) {
                revisionLong = Long.parseLong(revision.substring(3), 16);
                oldStyleRevision = true;
            } else if (revision.matches("^00[0-9a-fA-F]{2}$")) {
                oldStyleRevision = true;
                revisionLong = Long.parseLong(revision, 16);
                if (revisionLong < 2L || revisionLong > 21L) {
                    return null;
                }
            } else if (revision.matches("^[0-9a-fA-F]{6,}$")) {
                oldStyleRevision = false;
                revisionLong = Long.parseLong(revision, 16);
            } else {
                return null;
            }
            return new RaspberryPi(){

                @Override
                public String getRaw() {
                    return revision;
                }

                @Override
                public boolean isNewStyleRevision() {
                    if (oldStyleRevision) {
                        return false;
                    }
                    int value = (int)(revisionLong >>> 23 & 1L);
                    return value == 1;
                }

                @Override
                public MANUFACTURER getManufaturer() {
                    if (revisionLong >= 2L && revisionLong <= 21L) {
                        switch (revisionLong.intValue()) {
                            case 2: 
                            case 3: {
                                return MANUFACTURER.EGOMAN;
                            }
                            case 4: {
                                return MANUFACTURER.SONY_UK;
                            }
                            case 5: {
                                return MANUFACTURER.QISDA;
                            }
                            case 6: 
                            case 7: {
                                return MANUFACTURER.EGOMAN;
                            }
                            case 8: {
                                return MANUFACTURER.SONY_UK;
                            }
                            case 9: {
                                return MANUFACTURER.QISDA;
                            }
                            case 13: {
                                return MANUFACTURER.EGOMAN;
                            }
                            case 14: {
                                return MANUFACTURER.SONY_UK;
                            }
                            case 15: {
                                return MANUFACTURER.EGOMAN;
                            }
                            case 16: 
                            case 17: 
                            case 18: {
                                return MANUFACTURER.SONY_UK;
                            }
                            case 19: 
                            case 20: 
                            case 21: {
                                return MANUFACTURER.EMBEST;
                            }
                        }
                        return MANUFACTURER.UNKNOWN;
                    }
                    int value = (int)(revisionLong >>> 16 & 0xFL);
                    switch (value) {
                        case 0: {
                            return MANUFACTURER.SONY_UK;
                        }
                        case 1: {
                            return MANUFACTURER.EGOMAN;
                        }
                        case 2: {
                            return MANUFACTURER.EMBEST;
                        }
                        case 3: {
                            return MANUFACTURER.SONY_JAPAN;
                        }
                        case 4: {
                            return MANUFACTURER.EMBEST;
                        }
                        case 5: {
                            return MANUFACTURER.STADIUM;
                        }
                    }
                    return MANUFACTURER.UNKNOWN;
                }

                @Override
                public PROCESSOR getProcessor() {
                    if (revisionLong >= 2L && revisionLong <= 21L) {
                        return PROCESSOR.UNKNOWN;
                    }
                    int value = (int)(revisionLong >>> 12) & 0xF;
                    switch (value) {
                        case 0: {
                            return PROCESSOR.BCM2835;
                        }
                        case 1: {
                            return PROCESSOR.BCM2836;
                        }
                        case 2: {
                            return PROCESSOR.BCM2837;
                        }
                        case 3: {
                            return PROCESSOR.BCM2711;
                        }
                        case 4: {
                            return PROCESSOR.BCM2712;
                        }
                    }
                    return PROCESSOR.UNKNOWN;
                }

                @Override
                public MEMORY_SIZE getMemorySize() {
                    if (revisionLong >= 2L && revisionLong <= 21L) {
                        switch (revisionLong.intValue()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                return MEMORY_SIZE.MB_256;
                            }
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: {
                                return MEMORY_SIZE.MB_512;
                            }
                            case 18: {
                                return MEMORY_SIZE.MB_256;
                            }
                            case 19: 
                            case 20: {
                                return MEMORY_SIZE.MB_512;
                            }
                            case 21: {
                                return MEMORY_SIZE.MB_512;
                            }
                        }
                        return MEMORY_SIZE.UNKNOWN;
                    }
                    int value = (int)(revisionLong >>> 20) & 7;
                    switch (value) {
                        case 0: {
                            return MEMORY_SIZE.MB_256;
                        }
                        case 1: {
                            return MEMORY_SIZE.MB_512;
                        }
                        case 2: {
                            return MEMORY_SIZE.GB_1;
                        }
                        case 3: {
                            return MEMORY_SIZE.GB_2;
                        }
                        case 4: {
                            return MEMORY_SIZE.GB_4;
                        }
                        case 5: {
                            return MEMORY_SIZE.GB_8;
                        }
                    }
                    return MEMORY_SIZE.UNKNOWN;
                }

                @Override
                public TYPE getType() {
                    if (revisionLong >= 2L && revisionLong <= 21L) {
                        switch (revisionLong.intValue()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                return TYPE.B;
                            }
                            case 7: 
                            case 8: 
                            case 9: {
                                return TYPE.A;
                            }
                            case 13: 
                            case 14: 
                            case 15: {
                                return TYPE.B;
                            }
                            case 16: {
                                return TYPE.B_PLUS;
                            }
                            case 17: {
                                return TYPE.CM1;
                            }
                            case 18: {
                                return TYPE.A_PLUS;
                            }
                            case 19: {
                                return TYPE.B_PLUS;
                            }
                            case 20: {
                                return TYPE.CM1;
                            }
                            case 21: {
                                return TYPE.A_PLUS;
                            }
                        }
                        return TYPE.UNKNOWN;
                    }
                    int value = (int)(revisionLong >>> 4) & 0xFF;
                    switch (value) {
                        case 0: {
                            return TYPE.A;
                        }
                        case 1: {
                            return TYPE.B;
                        }
                        case 2: {
                            return TYPE.A_PLUS;
                        }
                        case 3: {
                            return TYPE.B_PLUS;
                        }
                        case 4: {
                            return TYPE.TWO_B;
                        }
                        case 5: {
                            return TYPE.ALPHA;
                        }
                        case 6: {
                            return TYPE.CM1;
                        }
                        case 7: {
                            return TYPE.UNKNOWN;
                        }
                        case 8: {
                            return TYPE.THREE_B;
                        }
                        case 9: {
                            return TYPE.ZERO;
                        }
                        case 10: {
                            return TYPE.CM3;
                        }
                        case 11: {
                            return TYPE.UNKNOWN;
                        }
                        case 12: {
                            return TYPE.ZERO_W;
                        }
                        case 13: {
                            return TYPE.THREE_B_PLUS;
                        }
                        case 14: {
                            return TYPE.THREE_A_PLUS;
                        }
                        case 15: {
                            return TYPE.INTERNAL_USE_ONLY;
                        }
                        case 16: {
                            return TYPE.CM3_PLUS;
                        }
                        case 17: {
                            return TYPE.FOUR_B;
                        }
                        case 18: {
                            return TYPE.ZERO_2_W;
                        }
                        case 19: {
                            return TYPE.FOUR_HUNDRET;
                        }
                        case 20: {
                            return TYPE.CM4;
                        }
                        case 21: {
                            return TYPE.CM4_S;
                        }
                        case 22: {
                            return TYPE.UNKNOWN;
                        }
                        case 23: {
                            return TYPE.FIVE_B;
                        }
                    }
                    return TYPE.UNKNOWN;
                }
            };
        }
        return null;
    }

    public String toString() {
        return "RaspberryPI|Type:" + (Object)((Object)this.getType()) + "|MemorySize:" + (Object)((Object)this.getMemorySize()) + "|Manufacturer:" + (Object)((Object)this.getManufaturer()) + "|Processor:" + (Object)((Object)this.getProcessor()) + "|Raw:" + this.getRaw();
    }

    @Override
    public HardwareTypeInterface.ID getHardwareType() {
        return HardwareTypeInterface.ID.RASPBERRYPI;
    }

    public abstract String getRaw();

    public abstract boolean isNewStyleRevision();

    public abstract MANUFACTURER getManufaturer();

    public abstract PROCESSOR getProcessor();

    public abstract MEMORY_SIZE getMemorySize();

    public abstract TYPE getType();

    public static enum TYPE {
        A,
        B,
        A_PLUS("A+"),
        B_PLUS("B+"),
        TWO_B("2B"),
        ALPHA,
        CM1,
        THREE_B("3B"),
        ZERO,
        CM3,
        ZERO_W("ZeroW"),
        ZERO_2_W("Zero2W"),
        THREE_B_PLUS("3B+"),
        THREE_A_PLUS("3A+"),
        INTERNAL_USE_ONLY,
        CM3_PLUS("CM3+"),
        FOUR_B("4B"),
        FOUR_HUNDRET("400"),
        FIVE_B("5B"),
        CM4,
        CM4_S,
        UNKNOWN;

        private final String name;

        private TYPE() {
            this(null);
        }

        private TYPE(String name) {
            this.name = name;
        }

        public String toString() {
            if (this.name == null) {
                return this.name();
            }
            return this.name;
        }
    }

    public static enum MEMORY_SIZE {
        MB_256,
        MB_512,
        GB_1,
        GB_2,
        GB_4,
        GB_8,
        UNKNOWN;

    }

    public static enum PROCESSOR {
        BCM2835,
        BCM2836,
        BCM2837,
        BCM2711,
        BCM2712,
        UNKNOWN;

    }

    public static enum MANUFACTURER {
        QISDA,
        SONY_UK,
        EGOMAN,
        EMBEST,
        SONY_JAPAN,
        STADIUM,
        UNKNOWN;

    }
}

