/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os.hardware;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.net.httpconnection.JavaSSLSocketStreamFactory;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.hardware.HardwareTypeInterface;

public abstract class QNAP
implements HardwareTypeInterface {
    @Override
    public HardwareTypeInterface.ID getHardwareType() {
        return HardwareTypeInterface.ID.QNAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QNAP getQNAPDetails() {
        if (CrossSystem.isLinux()) {
            boolean hasDataMount;
            boolean hasShellCommands = new File("/sbin/get_display_name").isFile() || new File("/sbin/getcfg").isFile();
            boolean bl = hasDataMount = new File("/share/HDA_DATA").isDirectory() || new File("/share/MD0_DATA").isDirectory() || new File("/share/CACHEDEV1_DATA").isDirectory() || new File("/share/CE_CACHEDEV1_DATA").isDirectory();
            if (hasShellCommands && hasDataMount) {
                int webinterfaceHTTPPort;
                QNAP qnap = QNAP.parseConfFiles();
                if (qnap != null) {
                    return qnap;
                }
                ArrayList<String> hosts = new ArrayList<String>(Arrays.asList("http://127.0.0.1:8080", "https://127.0.0.1:443"));
                int webinterfaceHTTPsPort = QNAP.findWebinterfaceHTTPsPort();
                if (webinterfaceHTTPsPort != -1 && webinterfaceHTTPsPort != 443) {
                    hosts.add(0, "https://127.0.0.1:" + webinterfaceHTTPsPort);
                }
                if ((webinterfaceHTTPPort = QNAP.findWebinterfaceHTTPPort()) != -1 && webinterfaceHTTPPort != 8080) {
                    hosts.add(0, "http://127.0.0.1:" + webinterfaceHTTPPort);
                }
                for (String host : hosts) {
                    try {
                        byte[] response;
                        URL url = new URL(host + "/cgi-bin/authLogin.cgi");
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
                        if (connection instanceof HttpsURLConnection) {
                            ((HttpsURLConnection)connection).setSSLSocketFactory(JavaSSLSocketStreamFactory.getInstance().getSSLSocketFactory(null, url.getHost()));
                            ((HttpsURLConnection)connection).setHostnameVerifier(new HostnameVerifier(){

                                @Override
                                public boolean verify(String hostname, SSLSession session) {
                                    return true;
                                }
                            });
                        }
                        connection.setConnectTimeout(2500);
                        connection.setReadTimeout(5000);
                        try {
                            connection.connect();
                            response = IO.readStream(8192, connection.getInputStream());
                        }
                        finally {
                            connection.disconnect();
                        }
                        qnap = QNAP.parse(new String(response, "UTF-8"));
                        if (qnap == null) continue;
                        return qnap;
                    }
                    catch (Exception ignore) {
                        ignore.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private static QNAP parseConfFiles() {
        File uLinuxConf = new File("/etc/config/uLinux.conf");
        File platformConf = new File("/etc/platform.conf");
        String model = QNAP.readValue(platformConf, "DISPLAY_NAME");
        if (model == null) {
            model = QNAP.readValue(uLinuxConf, "Model");
        }
        if (model != null) {
            final String version = QNAP.readValue(uLinuxConf, "Version");
            final String platform = QNAP.readValue(platformConf, "Platform");
            final String finalModel = model;
            return new QNAP(){

                @Override
                public String getVersion() {
                    return version;
                }

                @Override
                public String getPlatform() {
                    return platform;
                }

                @Override
                public String getModel() {
                    return finalModel;
                }
            };
        }
        return null;
    }

    private static final String readValue(File file, String key) {
        try {
            if (file.isFile()) {
                String content = IO.readFileToString(file);
                String value = new Regex(content, Pattern.quote(key) + "\\s=\\s*([^\r\n]+)").getMatch(0);
                return value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static final String getXMLFieldValue(String xml, String key) {
        return new Regex(xml, "<" + Pattern.quote(key) + ">\\s*<\\!\\[CDATA\\[(.*?)\\]]>").getMatch(0);
    }

    private static int findWebinterfaceHTTPsPort() {
        block5: {
            try {
                File apacheSSLConf = new File("/etc/apache-sys-proxy-ssl.conf");
                if (!apacheSSLConf.isFile()) break block5;
                try {
                    String html = IO.readFileToString(apacheSSLConf);
                    String port = new Regex(html, "Listen\\s+(\\d+)").getMatch(0);
                    if (port != null) {
                        return Integer.parseInt(port);
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findWebinterfaceHTTPPort() {
        try {
            File qhttpdConf;
            File apacheConf = new File("/etc/apache-sys-proxy.conf");
            if (apacheConf.isFile()) {
                try {
                    String html = IO.readFileToString(apacheConf);
                    String port = new Regex(html, "Listen\\s+(\\d+)").getMatch(0);
                    if (port != null) {
                        return Integer.parseInt(port);
                    }
                }
                catch (Exception html) {
                    // empty catch block
                }
            }
            if ((qhttpdConf = new File("/home/Qhttpd/index.html")).isFile()) {
                try {
                    String html = IO.readFileToString(qhttpdConf);
                    String port = new Regex(html, "\\s*\\+\\s*(\\d+)\\s*\\+").getMatch(0);
                    if (port != null) {
                        return Integer.parseInt(port);
                    }
                }
                catch (Exception html) {
                    // empty catch block
                }
            }
            URL url = new URL("http://127.0.0.1");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
            try {
                connection.setInstanceFollowRedirects(true);
                connection.setConnectTimeout(2500);
                connection.setReadTimeout(5000);
                connection.connect();
                String html = IO.readStreamToString(connection.getInputStream(), -1, true);
                String port = new Regex(html, "\\s*\\+\\s*(\\d+)\\s*\\+").getMatch(0);
                if (port == null) return -1;
                int n = Integer.parseInt(port);
                return n;
            }
            finally {
                connection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private static QNAP parse(String xml) {
        String model = QNAP.getXMLFieldValue(xml, "displayModelName");
        if (model == null && (model = QNAP.getXMLFieldValue(xml, "modelName")) == null) {
            model = QNAP.getXMLFieldValue(xml, "internalModelName");
        }
        if (model != null) {
            final String version = QNAP.getXMLFieldValue(xml, "version");
            final String platform = QNAP.getXMLFieldValue(xml, "platform");
            final String finalModel = model;
            return new QNAP(){

                @Override
                public String getPlatform() {
                    return platform;
                }

                @Override
                public String getModel() {
                    return finalModel;
                }

                @Override
                public String getVersion() {
                    return version;
                }
            };
        }
        return null;
    }

    public String toString() {
        return "QNAP|Model:" + this.getModel() + "|Version:" + this.getVersion() + "|Platform:" + this.getPlatform();
    }

    private QNAP() {
    }

    public abstract String getPlatform();

    public abstract String getModel();

    public abstract String getVersion();
}

