/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os.hardware;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.hardware.HardwareTypeInterface;

public abstract class ODROID
implements HardwareTypeInterface {
    @Override
    public HardwareTypeInterface.ID getHardwareType() {
        return HardwareTypeInterface.ID.ODROID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ODROID getODROIDDetails() {
        if (CrossSystem.isUnix()) {
            for (String infoSource : new String[]{"/proc/cpuinfo", "/proc/device-tree/mode"}) {
                File cpuInfo = new File(infoSource);
                if (!cpuInfo.isFile()) continue;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(cpuInfo);
                    BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                    String odroidHardware = null;
                    String line = null;
                    while ((line = is.readLine()) != null) {
                        if (StringUtils.startsWithCaseInsensitive(line, "Hardware")) {
                            odroidHardware = new Regex(line, "(?i)^\\s*Hardware\\s*:\\s*(.*?ODROID.*?)$").getMatch(0);
                        } else if (StringUtils.contains(line, "Hardkernel") || StringUtils.contains(line, "Odroid")) {
                            odroidHardware = line;
                        }
                        if (odroidHardware == null) continue;
                    }
                    is.close();
                    if (odroidHardware == null) continue;
                    ODROID oDROID = ODROID.parse(odroidHardware);
                    return oDROID;
                }
                catch (Throwable ignore) {
                    ignore.printStackTrace();
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }
        return null;
    }

    private static ODROID parse(final String hardware) {
        if (StringUtils.containsIgnoreCase(hardware, "ODROID")) {
            return new ODROID(){

                @Override
                public TYPE getType() {
                    if (StringUtils.contains(hardware, "HC2")) {
                        return TYPE.HC2;
                    }
                    if (StringUtils.contains(hardware, "HC1")) {
                        return TYPE.HC1;
                    }
                    if (StringUtils.contains(hardware, "MC1")) {
                        return TYPE.MC1;
                    }
                    if (StringUtils.contains(hardware, "N2+")) {
                        return TYPE.N2_PLUS;
                    }
                    if (StringUtils.contains(hardware, "N2")) {
                        return TYPE.N2;
                    }
                    if (StringUtils.contains(hardware, "C1+") || StringUtils.contains(hardware, "C+")) {
                        return TYPE.C1_PLUS;
                    }
                    if (StringUtils.contains(hardware, "H2+")) {
                        return TYPE.H2_PLUS;
                    }
                    if (StringUtils.contains(hardware, "H2")) {
                        return TYPE.H2;
                    }
                    if (StringUtils.contains(hardware, "C2")) {
                        return TYPE.C2;
                    }
                    if (StringUtils.contains(hardware, "XU4Q")) {
                        return TYPE.XU4Q;
                    }
                    if (StringUtils.contains(hardware, "XU4")) {
                        return TYPE.XU4;
                    }
                    if (StringUtils.contains(hardware, "XU3")) {
                        return TYPE.XU3;
                    }
                    if (StringUtils.contains(hardware, "XU")) {
                        return TYPE.XU;
                    }
                    if (StringUtils.contains(hardware, "U3")) {
                        return TYPE.U3;
                    }
                    if (StringUtils.contains(hardware, "X2")) {
                        return TYPE.X2;
                    }
                    if (StringUtils.contains(hardware, "U2")) {
                        return TYPE.U2;
                    }
                    if (StringUtils.contains(hardware, "W")) {
                        return TYPE.W;
                    }
                    if (StringUtils.contains(hardware, "C4")) {
                        return TYPE.C4;
                    }
                    if (StringUtils.contains(hardware, "GO")) {
                        return TYPE.GO;
                    }
                    if (StringUtils.contains(hardware, "C")) {
                        return TYPE.C1;
                    }
                    return TYPE.UNKNOWN;
                }

                @Override
                public String getRaw() {
                    return hardware;
                }
            };
        }
        return null;
    }

    public String toString() {
        return "ODROID|Type:" + (Object)((Object)this.getType()) + "|RAW:" + this.getRaw();
    }

    private ODROID() {
    }

    public abstract TYPE getType();

    public abstract String getRaw();

    public static enum TYPE {
        ODROID,
        U2,
        X2,
        U3,
        XU,
        XU3,
        XU3_LITE("XU3-Lite"),
        W,
        C1,
        C1_PLUS("C1+"),
        C2,
        H2,
        N2,
        C4,
        XU4,
        XU4Q,
        GO,
        HC1,
        HC2,
        MC1,
        N2_PLUS("N2+"),
        H2_PLUS("H2+"),
        UNKNOWN;

        private final String name;

        private TYPE() {
            this(null);
        }

        private TYPE(String name) {
            this.name = name;
        }

        public String toString() {
            if (this.name == null) {
                return this.name();
            }
            return this.name;
        }
    }
}

