/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.lang.reflect.Method;
import org.appwork.utils.StringUtils;

public class WindowsUtils {
    public static final String SID_LOCAL_SYSTEM = "S-1-5-18";

    public static String getCurrentUserSID() throws Exception {
        Class<?> ntSystemClass = Class.forName("com.sun.security.auth.module.NTSystem");
        Object ntSystem = ntSystemClass.newInstance();
        Method getSID = ntSystemClass.getDeclaredMethod("getUserSID", new Class[0]);
        return (String)getSID.invoke(ntSystem, new Object[0]);
    }

    public static boolean isCurrentUserPartOfGroup(String sid) throws Exception {
        String[] groups;
        Class<?> ntSystemClass = Class.forName("com.sun.security.auth.module.NTSystem");
        Object ntSystem = ntSystemClass.newInstance();
        Method getGroupIDs = ntSystemClass.getDeclaredMethod("getGroupIDs", new Class[0]);
        for (String group : groups = (String[])getGroupIDs.invoke(ntSystem, new Object[0])) {
            if (!StringUtils.equals(sid, group)) continue;
            return true;
        }
        return false;
    }

    public static enum SID {
        SID_NULL("S-1-0-0"),
        SID_EVERYONE("S-1-1-0"),
        SID_LOCAL("S-1-2-0"),
        SID_CONSOLE_LOGON("S-1-2-1"),
        SID_CREATOR_OWNER("S-1-3-0"),
        SID_CREATOR_GROUP("S-1-3-1"),
        SID_OWNER_SERVER("S-1-3-2"),
        SID_GROUP_SERVER("S-1-3-3"),
        SID_OWNER_RIGHTS("S-1-3-4"),
        SID_NT_AUTHORITY("S-1-5"),
        SID_DIALUP("S-1-5-1"),
        SID_NETWORK("S-1-5-2"),
        SID_BATCH("S-1-5-3"),
        SID_INTERACTIVE("S-1-5-4"),
        SID_SERVICE("S-1-5-6"),
        SID_ANONYMOUS("S-1-5-7"),
        SID_PROXY("S-1-5-8"),
        SID_ENTERPRISE_DOMAIN_CONTROLLERS("S-1-5-9"),
        SID_PRINCIPAL_SELF("S-1-5-10"),
        SID_AUTHENTICATED_USERS("S-1-5-11"),
        SID_RESTRICTED_CODE("S-1-5-12"),
        SID_TERMINAL_SERVER_USER("S-1-5-13"),
        SID_REMOTE_INTERACTIVE_LOGON("S-1-5-14"),
        SID_THIS_ORGANIZATION("S-1-5-15"),
        SID_IUSR("S-1-5-17"),
        SID_LOCAL_SYSTEM("S-1-5-18"),
        SID_LOCAL_SERVICE("S-1-5-19"),
        SID_NETWORK_SERVICE("S-1-5-20"),
        SID_COMPOUNDED_AUTHENTICATION("S-1-5-21-0-0-0-496"),
        SID_CLAIMS_VALID("S-1-5-21-0-0-0-497"),
        SID_BUILTIN_ADMINISTRATORS("S-1-5-32-544"),
        SID_BUILTIN_USERS("S-1-5-32-545"),
        SID_BUILTIN_GUESTS("S-1-5-32-546"),
        SID_POWER_USERS("S-1-5-32-547"),
        SID_ACCOUNT_OPERATORS("S-1-5-32-548"),
        SID_SERVER_OPERATORS("S-1-5-32-549"),
        SID_PRINTER_OPERATORS("S-1-5-32-550"),
        SID_BACKUP_OPERATORS("S-1-5-32-551"),
        SID_REPLICATOR("S-1-5-32-552"),
        SID_ALIAS_PREW2KCOMPACC("S-1-5-32-554"),
        SID_REMOTE_DESKTOP("S-1-5-32-555"),
        SID_NETWORK_CONFIGURATION_OPS("S-1-5-32-556"),
        SID_INCOMING_FOREST_TRUST_BUILDERS("S-1-5-32-557"),
        SID_PERFMON_USERS("S-1-5-32-558"),
        SID_PERFLOG_USERS("S-1-5-32-559"),
        SID_WINDOWS_AUTHORIZATION_ACCESS_GROUP("S-1-5-32-560"),
        SID_TERMINAL_SERVER_LICENSE_SERVERS("S-1-5-32-561"),
        SID_DISTRIBUTED_COM_USERS("S-1-5-32-562"),
        SID_IIS_IUSRS("S-1-5-32-568"),
        SID_CRYPTOGRAPHIC_OPERATORS("S-1-5-32-569"),
        SID_EVENT_LOG_READERS("S-1-5-32-573"),
        SID_CERTIFICATE_SERVICE_DCOM_ACCESS("S-1-5-32-574"),
        SID_RDS_REMOTE_ACCESS_SERVERS("S-1-5-32-575"),
        SID_RDS_ENDPOINT_SERVERS("S-1-5-32-576"),
        SID_RDS_MANAGEMENT_SERVERS("S-1-5-32-577"),
        SID_HYPER_V_ADMINS("S-1-5-32-578"),
        SID_ACCESS_CONTROL_ASSISTANCE_OPS("S-1-5-32-579"),
        SID_REMOTE_MANAGEMENT_USERS("S-1-5-32-580"),
        SID_WRITE_RESTRICTED_CODE("S-1-5-33"),
        SID_NTLM_AUTHENTICATION("S-1-5-64-10"),
        SID_SCHANNEL_AUTHENTICATION("S-1-5-64-14"),
        SID_DIGEST_AUTHENTICATION("S-1-5-64-21"),
        SID_THIS_ORGANIZATION_CERTIFICATE("S-1-5-65-1"),
        SID_NT_SERVICE("S-1-5-80"),
        SID_USER_MODE_DRIVERS("S-1-5-84-0-0-0-0-0"),
        SID_LOCAL_ACCOUNT("S-1-5-113"),
        SID_LOCAL_ACCOUNT_AND_MEMBER_OF_ADMINISTRATORS_GROUP("S-1-5-114"),
        SID_OTHER_ORGANIZATION("S-1-5-1000"),
        SID_ALL_APP_PACKAGES("S-1-15-2-1"),
        SID_ML_UNTRUSTED("S-1-16-0"),
        SID_ML_LOW("S-1-16-4096"),
        SID_ML_MEDIUM("S-1-16-8192"),
        SID_ML_MEDIUM_PLUS("S-1-16-8448"),
        SID_ML_HIGH("S-1-16-12288"),
        SID_ML_SYSTEM("S-1-16-16384"),
        SID_ML_PROTECTED_PROCESS("S-1-16-20480"),
        SID_AUTHENTICATION_AUTHORITY_ASSERTED_IDENTITY("S-1-18-1"),
        SID_SERVICE_ASSERTED_IDENTITY("S-1-18-2"),
        SID_FRESH_PUBLIC_KEY_IDENTITY("S-1-18-3"),
        SID_KEY_TRUST_IDENTITY("S-1-18-4"),
        SID_KEY_PROPERTY_MFA("S-1-18-5"),
        SID_KEY_PROPERTY_ATTESTATION("S-1-18-6");

        public final String sid;

        private SID(String sid) {
            this.sid = sid;
        }
    }
}

