/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.util.HashMap;

public class SecuritySoftwareInfo
extends HashMap<String, String> {
    public String getName() {
        return (String)this.get("displayName");
    }

    public String getState() {
        return (String)this.get("productState");
    }

    public boolean isEnabled() {
        if ("TRUE".equals(this.get("enabled"))) {
            return true;
        }
        if (this.get("productState") == null) {
            return true;
        }
        String state = this.getState();
        if (state == null) {
            return false;
        }
        int i = Integer.parseInt(state);
        return SecuritySoftwareInfo.isEnabledByState(i);
    }

    public static boolean isEnabledByState(int i) {
        int enabledFlag = 0xFF & i >> 8;
        return enabledFlag >= 16;
    }

    @Override
    public String toString() {
        return this.getName() + " Enabled: " + this.isEnabled() + " Up2Date: " + this.isUp2Date();
    }

    public boolean isUp2Date() {
        String up2DateXp = (String)this.get("productUptoDate");
        if ("TRUE".equalsIgnoreCase(up2DateXp)) {
            return true;
        }
        String state = this.getState();
        if (state == null) {
            return false;
        }
        int i = Integer.parseInt(state);
        int upToDate = 0xFF & i;
        return upToDate == 0;
    }
}

