/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.websocket;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Random;
import org.appwork.utils.IO;
import org.appwork.utils.net.LimitedInputStream;
import org.appwork.utils.net.websocket.ReadWebSocketFrame;
import org.appwork.utils.net.websocket.WebSocketFrame;
import org.appwork.utils.net.websocket.WebSocketFrameHeader;
import org.appwork.utils.net.websocket.WriteWebSocketFrame;

public abstract class WebSocketEndPoint {
    protected byte[] fill(InputStream is, byte[] buffer) throws IOException {
        int done;
        int length = buffer.length;
        int read = 0;
        for (done = 0; done < length && (read = is.read(buffer, done, length - done)) != -1; done += read) {
        }
        if (done != length) {
            throw new EOFException(done + "!=" + length);
        }
        return buffer;
    }

    public byte[] nextMask() {
        byte[] ret = new byte[4];
        new Random().nextBytes(ret);
        return ret;
    }

    protected ReadWebSocketFrame readWebSocketFrame(InputStream is) throws IOException {
        WebSocketFrameHeader frameHeader = this.readWebSocketFrameHeader(is);
        if (frameHeader != null) {
            if (frameHeader.getPayloadLength() > 0L) {
                byte[] payLoad = IO.readStream(-1, new LimitedInputStream(is, frameHeader.getPayloadLength()){

                    @Override
                    public void close() throws IOException {
                    }
                });
                return new ReadWebSocketFrame(frameHeader, payLoad);
            }
            return new ReadWebSocketFrame(frameHeader);
        }
        return null;
    }

    protected WebSocketFrameHeader readWebSocketFrameHeader(InputStream is) throws IOException {
        byte[] buf = this.fill(is, new byte[2]);
        boolean fin = 1 == (buf[0] & 0xFF) >>> 7;
        int opCode = buf[0] & 0xF;
        boolean mask = 1 == (buf[1] & 0xFF) >>> 7;
        long payloadLength = buf[1] & 0x7F;
        if (payloadLength == 126L) {
            buf = this.fill(is, new byte[2]);
            payloadLength = ((buf[0] & 0xFF) << 8) + ((buf[1] & 0xFF) << 0);
        } else if (payloadLength == 127L) {
            buf = this.fill(is, new byte[8]);
            payloadLength = ((long)buf[0] << 56) + ((long)(buf[1] & 0xFF) << 48) + ((long)(buf[2] & 0xFF) << 40) + ((long)(buf[3] & 0xFF) << 32) + ((long)(buf[4] & 0xFF) << 24) + (long)((buf[5] & 0xFF) << 16) + (long)((buf[6] & 0xFF) << 8) + (long)((buf[7] & 0xFF) << 0);
        }
        WebSocketFrameHeader.OP_CODE op_Code = WebSocketFrameHeader.OP_CODE.get(opCode);
        if (op_Code == null) {
            throw new IOException("Unsupported opCode:" + opCode);
        }
        if (mask) {
            return new WebSocketFrameHeader(fin, op_Code, payloadLength, this.fill(is, new byte[4]));
        }
        return new WebSocketFrameHeader(fin, op_Code, payloadLength);
    }

    public WriteWebSocketFrame buildCloseFrame() {
        return new WriteWebSocketFrame(new WebSocketFrameHeader(true, WebSocketFrameHeader.OP_CODE.CLOSE, 0L, this.nextMask()));
    }

    public WriteWebSocketFrame buildPingFrame() {
        return this.buildPingFrame(null);
    }

    public WriteWebSocketFrame buildPingFrame(byte[] payLoad) {
        if (payLoad != null && payLoad.length > 0) {
            if (payLoad.length > 125) {
                throw new IllegalArgumentException("Payload length must be <=125!");
            }
            return new WriteWebSocketFrame(new WebSocketFrameHeader(true, WebSocketFrameHeader.OP_CODE.PING, payLoad.length, this.nextMask()), payLoad);
        }
        return new WriteWebSocketFrame(new WebSocketFrameHeader(true, WebSocketFrameHeader.OP_CODE.PING, 0L, null));
    }

    public WriteWebSocketFrame buildUTF8TextFrame(String text) {
        byte[] bytes = text.getBytes(Charset.forName("UTF-8"));
        return new WriteWebSocketFrame(new WebSocketFrameHeader(true, WebSocketFrameHeader.OP_CODE.UTF8_TEXT, bytes.length, this.nextMask()), bytes);
    }

    public void writeFrame(WriteWebSocketFrame webSocketFrame) throws IOException {
        this.log(webSocketFrame);
        OutputStream os = this.getOutputStream();
        os.write(webSocketFrame.getHeader());
        if (webSocketFrame.hasPayLoad()) {
            os.write(webSocketFrame.getPayload());
        }
    }

    protected void onOpCode_Close(ReadWebSocketFrame close) throws IOException {
    }

    protected void onOpCode_Pong(ReadWebSocketFrame pong) throws IOException {
    }

    public WriteWebSocketFrame buildPongFrame(ReadWebSocketFrame ping) {
        if (WebSocketFrameHeader.OP_CODE.PING.equals((Object)ping.getOpCode())) {
            if (ping.hasPayLoad()) {
                return new WriteWebSocketFrame(new WebSocketFrameHeader(true, WebSocketFrameHeader.OP_CODE.PONG, ping.getPayloadLength(), ping.getMask()), ping.getPayload());
            }
            return new WriteWebSocketFrame(new WebSocketFrameHeader(true, WebSocketFrameHeader.OP_CODE.PONG, 0L), null);
        }
        throw new IllegalArgumentException("Wrong OpCode:" + (Object)((Object)ping.getOpCode()));
    }

    protected void onOpCode_Ping(ReadWebSocketFrame ping) throws IOException {
    }

    protected abstract void log(WebSocketFrame var1);

    public ReadWebSocketFrame readNextFrame() throws IOException {
        ReadWebSocketFrame webSocketFrame = this.readWebSocketFrame(this.getInputStream());
        if (webSocketFrame != null) {
            this.log(webSocketFrame);
            switch (webSocketFrame.getOpCode()) {
                case PING: {
                    this.onOpCode_Ping(webSocketFrame);
                    break;
                }
                case PONG: {
                    this.onOpCode_Pong(webSocketFrame);
                    break;
                }
                case CLOSE: {
                    this.onOpCode_Close(webSocketFrame);
                    break;
                }
            }
            return webSocketFrame;
        }
        return null;
    }

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract OutputStream getOutputStream() throws IOException;
}

