/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.usenet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.utils.Exceptions;
import org.appwork.utils.net.usenet.BodyInputStream;
import org.appwork.utils.net.usenet.SimpleUseNet;

public class YEncInputStream
extends InputStream {
    private final InputStream inputStream;
    private final ByteArrayOutputStream buffer;
    private final long size;
    private final String name;
    private String yEncTrailer = null;
    private final int lineLength;
    private final boolean isMultiPart;
    private final long partBegin;
    private long decodedBytes = 0L;
    private boolean eof = false;
    protected static final Pattern NUMBER = Pattern.compile("\\d+");
    protected static final Pattern CRC32 = Pattern.compile("[a-fA-F0-9]+");
    private static final byte LF = 10;
    private static final byte CR = 13;
    private static final byte ESCAPE = 61;
    private static final byte DOT = 46;
    private final long partEnd;
    private final int partIndex;
    private final int partTotal;
    private final SimpleUseNet client;
    private final String messageID;
    private final byte[] lineBuffer;
    private String crc32Value = null;
    private String pcrc32Value = null;
    private final byte[] decodedBuffer;
    private int decodedIndex = 0;
    private int decodedLength = 0;
    private final byte[] encodedBuffer;
    private int encodedReadIndex = 0;
    private int encodedLength = 0;

    public long getPartBegin() {
        return this.partBegin;
    }

    public long getPartEnd() {
        return this.partEnd;
    }

    public boolean isMultiPart() {
        return this.isMultiPart;
    }

    public int getPartIndex() {
        return this.partIndex;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public int getPartTotal() {
        return this.partTotal;
    }

    @Override
    public int available() throws IOException {
        if (this.decodedIndex < this.decodedLength) {
            return this.decodedLength - this.decodedIndex;
        }
        return 0;
    }

    protected YEncInputStream(SimpleUseNet client, String messageID, ByteArrayOutputStream buffer) throws IOException {
        String totalValue;
        this.messageID = messageID;
        this.client = client;
        this.inputStream = client.getInputStream();
        this.buffer = buffer;
        String line = new String(buffer.toByteArray(), 0, buffer.size(), client.getCharSet());
        if (!line.startsWith("=ybegin")) {
            throw new IOException("missing =ybegin");
        }
        String lineValue = this.getValue(line, "line", NUMBER);
        this.lineLength = lineValue != null ? Integer.parseInt(lineValue) : -1;
        this.name = this.getValue(line, "name", null);
        String sizeValue = this.getValue(line, "size", NUMBER);
        this.size = sizeValue != null ? Long.parseLong(sizeValue) : -1L;
        String partValue = this.getValue(line, "part", NUMBER);
        this.partIndex = partValue != null ? Integer.parseInt(partValue) : -1;
        boolean bl = this.isMultiPart = this.partIndex != -1;
        this.partTotal = this.isMultiPart ? ((totalValue = this.getValue(line, "total", NUMBER)) != null ? Integer.parseInt(totalValue) : -1) : -1;
        if (this.isMultiPart) {
            buffer.reset();
            line = client.readLine(buffer);
            if (!line.startsWith("=ypart")) {
                throw new IOException("missing =ypart");
            }
            String beginValue = this.getValue(line, "begin", NUMBER);
            this.partBegin = beginValue != null ? Long.parseLong(beginValue) : -1L;
            String endValue = this.getValue(line, "end", NUMBER);
            this.partEnd = endValue != null ? Long.parseLong(endValue) : -1L;
        } else {
            this.partBegin = -1L;
            this.partEnd = -1L;
        }
        this.lineBuffer = this.initLineBuffer(this.getLineLength());
        this.encodedBuffer = this.initEncodedBuffer();
        this.decodedBuffer = this.initDecodedBuffer();
        if (this.encodedBuffer.length < 5) {
            throw new IllegalArgumentException("encodedBuffer requires minimum size of 5 '=yend'!");
        }
    }

    protected byte[] initLineBuffer(int lineLength) {
        return lineLength > 0 ? new byte[lineLength] : null;
    }

    protected byte[] initEncodedBuffer() {
        return new byte[262144];
    }

    protected byte[] initDecodedBuffer() {
        return new byte[this.encodedBuffer.length];
    }

    public int getDecodedBufferSize() {
        return this.decodedBuffer.length;
    }

    protected final InputStream getInputStream() {
        return this.inputStream;
    }

    public String getFileCRC32() {
        return this.crc32Value;
    }

    public String getPartCRC32() {
        return this.pcrc32Value;
    }

    private final synchronized int readNextDecodedByte() throws IOException {
        if (this.decodedIndex < this.decodedLength) {
            int ret = this.decodedBuffer[this.decodedIndex++] & 0xFF;
            return ret;
        }
        return -1;
    }

    private final int readNextDecodedBytes(byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            if (this.decodedIndex < this.decodedLength) {
                int ret = Math.min(len, this.decodedLength - this.decodedIndex);
                System.arraycopy(this.decodedBuffer, this.decodedIndex, b, off, ret);
                this.decodedIndex += ret;
                return ret;
            }
            return -1;
        }
        return 0;
    }

    private int indexOf(byte[] buf, int startIndex, int len, byte indexOf) {
        int lineLength = this.getLineLength();
        if (lineLength > 0 && len > lineLength * 3) {
            int lineEndIndex = startIndex + lineLength;
            if (buf[lineEndIndex + 1] == indexOf) {
                return lineEndIndex + 1;
            }
            if (buf[lineEndIndex + 2] == indexOf) {
                return lineEndIndex + 2;
            }
        }
        int endIndex = startIndex + len;
        for (int index = startIndex; index < endIndex; ++index) {
            if (buf[index] != indexOf) continue;
            return index;
        }
        return -1;
    }

    private byte[] removeCRLF(byte[] buf, int startIndex, int endIndex) {
        int length = endIndex - startIndex;
        if (buf[endIndex - 1] == 13) {
            --length;
            --endIndex;
        }
        byte[] ret = length == this.getLineLength() && this.lineBuffer != null ? this.lineBuffer : new byte[length];
        int count = 0;
        for (int index = startIndex; index < endIndex; ++index) {
            byte b = buf[index];
            if (b == 13 || b == 10) continue;
            ret[count++] = b;
        }
        if (count == length) {
            return ret;
        }
        if (count == 0) {
            return null;
        }
        return Arrays.copyOf(ret, count);
    }

    private final int decodeLine() throws IOException {
        int encodedReadIndex = this.encodedReadIndex;
        int encodedLeft = this.encodedLength - encodedReadIndex;
        int lf_index = this.indexOf(this.encodedBuffer, encodedReadIndex, encodedLeft, (byte)10);
        if (lf_index == -1) {
            return 0;
        }
        if (this.encodedBuffer[encodedReadIndex] == 61 && this.encodedBuffer[encodedReadIndex + 1] == 121 && this.encodedBuffer[encodedReadIndex + 2] == 101 && this.encodedBuffer[encodedReadIndex + 3] == 110 && this.encodedBuffer[encodedReadIndex + 4] == 100) {
            this.eof = true;
            PushbackInputStream inputStream = new PushbackInputStream(this.getInputStream(), encodedLeft);
            inputStream.unread(this.encodedBuffer, encodedReadIndex, encodedLeft);
            this.encodedLength = 0;
            this.encodedReadIndex = 0;
            this.parseTrailer(inputStream);
            return 0;
        }
        byte[] buf = this.removeCRLF(this.encodedBuffer, encodedReadIndex, lf_index);
        int bufLen = buf.length;
        int decoded = 0;
        if (buf != null) {
            int index = 0;
            if (bufLen > 1 && buf[0] == 46 && buf[1] == 46) {
                ++index;
            }
            block6: while (index < bufLen) {
                byte b = buf[index++];
                switch (b) {
                    case 61: {
                        block7: while (index < bufLen) {
                            b = buf[index++];
                            switch (b) {
                                case 10: 
                                case 13: {
                                    continue block7;
                                }
                            }
                            b = (byte)((byte)(b - 64) & 0xFF);
                            this.decodedBuffer[this.decodedLength + decoded++] = (byte)((byte)(b - 42) & 0xFF);
                            continue block6;
                        }
                        continue block6;
                    }
                }
                this.decodedBuffer[this.decodedLength + decoded++] = (byte)((byte)(b - 42) & 0xFF);
            }
        }
        if (lf_index + 1 < this.encodedLength) {
            this.encodedReadIndex = lf_index + 1;
        } else {
            this.encodedReadIndex = 0;
            this.encodedLength = 0;
        }
        this.decodedBytes += (long)decoded;
        if (decoded == 0) {
            return this.decodeLine();
        }
        return decoded;
    }

    private final int fillDecodedBuffer() throws IOException {
        int maxRead;
        if (this.decodedIndex < this.decodedLength) {
            return this.decodedLength - this.decodedIndex;
        }
        if (this.eof) {
            return -1;
        }
        this.decodedIndex = 0;
        this.decodedLength = 0;
        if (this.eof) {
            return -1;
        }
        if (this.encodedReadIndex > 0) {
            int encodedLeft = this.encodedLength - this.encodedReadIndex;
            System.arraycopy(this.encodedBuffer, this.encodedReadIndex, this.encodedBuffer, 0, encodedLeft);
            this.encodedReadIndex = 0;
            this.encodedLength = encodedLeft;
        }
        if ((maxRead = this.encodedBuffer.length - this.encodedLength) == 0) {
            throw new IllegalStateException("maxRead=0");
        }
        int encodedRead = this.getInputStream().read(this.encodedBuffer, this.encodedLength, maxRead);
        if (encodedRead == -1) {
            this.eof = true;
            return -1;
        }
        if (encodedRead == 0) {
            return 0;
        }
        this.encodedLength += encodedRead;
        int lineDecoded = this.decodeLine();
        if (lineDecoded > 0) {
            this.decodedLength += lineDecoded;
            while ((lineDecoded = this.decodeLine()) > 0) {
                this.decodedLength += lineDecoded;
            }
            return this.decodedLength - this.decodedIndex;
        }
        if (this.eof) {
            return -1;
        }
        return 0;
    }

    @Override
    public synchronized int read() throws IOException {
        int ret = this.readNextDecodedByte();
        if (ret == -1) {
            int available;
            while ((available = this.fillDecodedBuffer()) <= 0) {
                if (available == -1) {
                    return -1;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
            ret = this.readNextDecodedByte();
        }
        return ret;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            int ret = this.readNextDecodedBytes(b, off, len);
            if (ret == -1) {
                int available;
                while ((available = this.fillDecodedBuffer()) <= 0) {
                    if (available == -1) {
                        return -1;
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                ret = this.readNextDecodedBytes(b, off, len);
            }
            return ret;
        }
        return 0;
    }

    private void parseTrailer(InputStream inputStream) throws IOException {
        this.buffer.reset();
        int lineSize = this.readLine(inputStream);
        byte[] lineBuffer = this.buffer.toByteArray();
        this.yEncTrailer = new String(lineBuffer, 0, lineSize, this.client.getCharSet());
        String sizeValue = this.getValue(this.getYEncTrailer(), "size", NUMBER);
        long size = sizeValue != null ? Long.parseLong(sizeValue) : -1L;
        this.pcrc32Value = this.getValue(this.getYEncTrailer(), "pcrc32", CRC32);
        this.crc32Value = this.getValue(this.getYEncTrailer(), " crc32", CRC32);
        IOException bodyEndException = null;
        try {
            this.readBodyEnd(inputStream);
        }
        catch (IOException e) {
            bodyEndException = e;
        }
        try {
            if (this.isMultiPart()) {
                int partValueInt;
                if (size != this.getPartSize()) {
                    throw new YEncSizeException(size);
                }
                String partValueString = this.getValue(this.getYEncTrailer(), "part", NUMBER);
                if (partValueString != null && (partValueInt = Integer.parseInt(partValueString)) != 0 && partValueInt != this.getPartIndex()) {
                    throw new YEncIndexException(partValueInt);
                }
            } else if (size != this.getSize()) {
                throw new YEncSizeException(size);
            }
            if (this.decodedBytes < size) {
                throw new YEncDecodedSizeException(this.decodedBytes, size);
            }
        }
        catch (IOException e) {
            throw Exceptions.addSuppressed(e, bodyEndException);
        }
        if (bodyEndException != null) {
            throw bodyEndException;
        }
    }

    public String getYEncTrailer() {
        return this.yEncTrailer;
    }

    protected int readLine(InputStream is) throws IOException {
        return this.client.readLine(is, this.buffer);
    }

    private void readBodyEnd(InputStream is) throws IOException {
        byte[] bodyEndBuf;
        BodyInputStream bodyInputStream = new BodyInputStream(is);
        byte[] byArray = bodyEndBuf = this.lineBuffer != null ? this.lineBuffer : new byte[32];
        while (bodyInputStream.read(bodyEndBuf) != -1) {
        }
        bodyInputStream.close();
    }

    @Override
    public void close() throws IOException {
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public long getPartSize() {
        if (this.isMultiPart) {
            return this.getPartEnd() - this.getPartBegin() + 1L;
        }
        return -1L;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    protected String getValue(String line, String key, Pattern valuePattern) {
        Matcher matcher;
        int index;
        String search = key + "=";
        int start = line.indexOf(search);
        if (start == -1) {
            return null;
        }
        int end = "name".equals(key) ? line.length() : ((index = line.indexOf(" ", start + search.length())) == -1 ? line.length() : index);
        String ret = line.substring(start + search.length(), end);
        if (valuePattern != null && (matcher = valuePattern.matcher(ret)).find()) {
            return matcher.group();
        }
        return ret;
    }

    public class YEncDecodedSizeException
    extends IOException {
        private final long size;
        private final long expected;
        private final String messageID;

        public long getSize() {
            return this.size;
        }

        public long getExpected() {
            return this.expected;
        }

        public String getMessageID() {
            return this.messageID;
        }

        protected YEncDecodedSizeException(long size, long expected) {
            super("decoded-size-error:" + size + "<->" + expected + "|yEncTrailer:" + YEncInputStream.this.getYEncTrailer());
            this.size = size;
            this.expected = expected;
            this.messageID = this.getMessageID();
        }
    }

    public class YEncSizeException
    extends IOException {
        private final long size;
        private final long expected;
        private final String messageID;
        private final boolean isMultiPart;

        public long getSize() {
            return this.size;
        }

        public String getMessageID() {
            return this.messageID;
        }

        public long getExpected() {
            return this.expected;
        }

        public boolean isMultiPart() {
            return this.isMultiPart;
        }

        public YEncSizeException(long size) {
            super((YEncInputStream.this.isMultiPart() ? "part-" : "") + "size-error:" + size + "<->" + YEncInputStream.this.getPartSize() + "|yEncTrailer:" + YEncInputStream.this.getYEncTrailer());
            this.size = size;
            this.expected = YEncInputStream.this.getPartSize();
            this.messageID = this.getMessageID();
            this.isMultiPart = this.isMultiPart();
        }
    }

    public class YEncIndexException
    extends IOException {
        private final String messageID;
        private final int expected;
        private final int index;

        public String getMessageID() {
            return this.messageID;
        }

        public int getIndex() {
            return this.index;
        }

        public int getExpected() {
            return this.expected;
        }

        public YEncIndexException(int index) {
            super("part-index-error:" + index + "<->" + YEncInputStream.this.getPartIndex() + "|yEncTrailer:" + YEncInputStream.this.getYEncTrailer());
            this.index = index;
            this.messageID = this.getMessageID();
            this.expected = YEncInputStream.this.getPartIndex();
        }
    }
}

