/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.usenet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.appwork.utils.net.usenet.BodyInputStream;
import org.appwork.utils.net.usenet.SimpleUseNet;

public class UUInputStream
extends InputStream {
    private final InputStream inputStream;
    private final ByteArrayOutputStream buffer;
    private final String name;
    private final SimpleUseNet client;
    private int lineSize = 0;
    private byte[] lineBuffer = null;
    private boolean eof = false;
    private int dataIndex = 0;
    private int dataLength = -1;
    private String trailer = null;

    protected UUInputStream(SimpleUseNet client, ByteArrayOutputStream buffer) throws IOException {
        this.client = client;
        this.inputStream = client.getInputStream();
        this.buffer = buffer;
        String line = new String(buffer.toByteArray(), 0, buffer.size(), client.getCharSet());
        if (!line.matches("^begin \\d{3} .+")) {
            throw new IOException("missing uuEncode begin");
        }
        this.name = line.replaceFirst("begin \\d{3} ", "");
        this.readNextLine();
    }

    private void readNextLine() throws IOException {
        int encodedLeft;
        this.buffer.reset();
        this.lineSize = this.client.readLine(this.inputStream, this.buffer);
        this.lineBuffer = this.buffer.toByteArray();
        if (this.lineSize == 1) {
            if (this.lineBuffer[0] == 96) {
                this.eof = true;
                this.parseTrailer(this.inputStream);
                return;
            }
            throw new IOException("unexpected single byte line");
        }
        this.dataIndex = 0;
        this.dataLength = (this.lineBuffer[0] & 0xFF) - 32;
        int writeIndex = 0;
        int readIndex = 1;
        while ((encodedLeft = this.dataLength - writeIndex) > 0) {
            int b;
            int a;
            if (encodedLeft >= 3) {
                a = this.lineBuffer[readIndex] & 0xFF;
                b = this.lineBuffer[readIndex + 1] & 0xFF;
                int c = this.lineBuffer[readIndex + 2] & 0xFF;
                int d = this.lineBuffer[readIndex + 3] & 0xFF;
                int x = (a - 32 & 0x3F) << 2 | (b - 32 & 0x3F) >> 4;
                int y = (b - 32 & 0x3F) << 4 | (c - 32 & 0x3F) >> 2;
                int z = (c - 32 & 0x3F) << 6 | d - 32 & 0x3F;
                this.lineBuffer[writeIndex++] = (byte)x;
                this.lineBuffer[writeIndex++] = (byte)y;
                this.lineBuffer[writeIndex++] = (byte)z;
            } else {
                if (encodedLeft >= 1) {
                    a = this.lineBuffer[readIndex] & 0xFF;
                    b = this.lineBuffer[readIndex + 1] & 0xFF;
                    int x = (a - 32 & 0x3F) << 2 | (b - 32 & 0x3F) >> 4;
                    this.lineBuffer[writeIndex++] = (byte)x;
                }
                if (encodedLeft >= 2) {
                    int b2 = this.lineBuffer[readIndex + 1] & 0xFF;
                    int c = this.lineBuffer[readIndex + 2] & 0xFF;
                    int y = (b2 - 32 & 0x3F) << 4 | (c - 32 & 0x3F) >> 2;
                    this.lineBuffer[writeIndex++] = (byte)y;
                }
            }
            readIndex += 4;
        }
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.dataIndex == this.dataLength) {
            this.readNextLine();
            if (this.eof) {
                return -1;
            }
        }
        int c = this.lineBuffer[this.dataIndex++] & 0xFF;
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.dataIndex == this.dataLength) {
            this.readNextLine();
            if (this.eof) {
                return -1;
            }
        }
        int written = 0;
        while (this.dataIndex < this.dataLength && written < len) {
            b[off + written++] = (byte)(this.lineBuffer[this.dataIndex++] & 0xFF);
        }
        return written;
    }

    private void parseTrailer(InputStream inputStream) throws IOException {
        this.buffer.reset();
        this.client.readLine(inputStream, this.buffer);
        this.trailer = new String(this.buffer.toByteArray(), 0, this.buffer.size(), this.client.getCharSet());
        this.readBodyEnd(inputStream);
        if (!"end".equals(this.trailer)) {
            throw new IOException("missing body termination(end): " + this.trailer);
        }
    }

    public String getTrailer() {
        return this.trailer;
    }

    private void readBodyEnd(InputStream is) throws IOException {
        BodyInputStream bodyInputStream = new BodyInputStream(is);
        byte[] bodyEndBuf = new byte[32];
        while (bodyInputStream.read(bodyEndBuf) != -1) {
        }
        bodyInputStream.close();
    }

    @Override
    public void close() throws IOException {
    }

    public String getName() {
        return this.name;
    }
}

