/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.socketconnection;

import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.socketconnection.SocketConnection;

public abstract class SocksSocketConnection
extends SocketConnection {
    protected final DESTTYPE destType;
    protected final Set<DESTTYPE> supportedDestType = new CopyOnWriteArraySet<DESTTYPE>();

    public SocksSocketConnection(HTTPProxy proxy, DESTTYPE destType) {
        super(proxy);
        this.destType = this.initSocksSocketConnection(proxy, destType);
    }

    protected abstract DESTTYPE initSocksSocketConnection(HTTPProxy var1, DESTTYPE var2);

    public boolean isSupported(DESTTYPE destType) {
        return destType != null && this.supportedDestType.contains((Object)destType);
    }

    public DESTTYPE getDestType() {
        return this.destType;
    }

    public abstract DESTTYPE getDestType(SocketAddress var1);

    public static enum DESTTYPE {
        AUTO,
        IPV4,
        IPV6,
        DOMAIN;

    }

    public static enum AUTH {
        PLAIN,
        NONE;

    }
}

