/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.socketconnection;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.appwork.utils.Exceptions;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.ProxyAuthException;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.net.httpconnection.ProxyEndpointConnectException;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.appwork.utils.net.httpconnection.SocksHTTPconnection;
import org.appwork.utils.net.socketconnection.SocketConnection;
import org.appwork.utils.net.socketconnection.SocksSocketConnection;

public class Socks5SocketConnection
extends SocksSocketConnection {
    private static final boolean SENDONLYSINGLEAUTHMETHOD = true;

    @Override
    public SocksSocketConnection.DESTTYPE getDestType(SocketAddress endpoint) {
        InetSocketAddress inetSocketAddress;
        SocksSocketConnection.DESTTYPE destType = this.getDestType();
        if (endpoint != null && endpoint instanceof InetSocketAddress && (inetSocketAddress = (InetSocketAddress)endpoint).getAddress() != null) {
            switch (inetSocketAddress.getAddress().getAddress().length) {
                case 4: {
                    if (!this.isSupported(SocksSocketConnection.DESTTYPE.IPV4) || !SocksSocketConnection.DESTTYPE.IPV4.equals((Object)destType) && !SocksSocketConnection.DESTTYPE.AUTO.equals((Object)destType)) break;
                    return SocksSocketConnection.DESTTYPE.IPV4;
                }
                case 16: {
                    if (!this.isSupported(SocksSocketConnection.DESTTYPE.IPV6) || !SocksSocketConnection.DESTTYPE.IPV6.equals((Object)destType) && !SocksSocketConnection.DESTTYPE.AUTO.equals((Object)destType)) break;
                    return SocksSocketConnection.DESTTYPE.IPV6;
                }
            }
        }
        return destType;
    }

    @Override
    protected boolean retryConnectProxySocket(IOException e, SocketStreamInterface connectSocket, SocketAddress endpoint) {
        Socks5EndpointConnectException connectException = Exceptions.getInstanceof(e, Socks5EndpointConnectException.class);
        if (connectException != null) {
            switch (connectException.getError()) {
                case ADDRESS_TYPE_NOT_SUPPORTED_IPV4: {
                    return this.supportedDestType.remove((Object)SocksSocketConnection.DESTTYPE.IPV4);
                }
                case ADDRESS_TYPE_NOT_SUPPORTED_IPV6: {
                    return this.supportedDestType.remove((Object)SocksSocketConnection.DESTTYPE.IPV6);
                }
                case ADDRESS_TYPE_NOT_SUPPORTED_DOMAIN: {
                    return this.supportedDestType.remove((Object)SocksSocketConnection.DESTTYPE.DOMAIN);
                }
                case NETWORK_UNREACHABLE: 
                case ADDRESS_TYPE_NOT_SUPPORTED: {
                    if (connectException.getDestType() != null) {
                        switch (connectException.getDestType()) {
                            case IPV4: 
                            case IPV6: {
                                return this.supportedDestType.remove((Object)connectException.getDestType());
                            }
                        }
                        return false;
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public Socks5SocketConnection(HTTPProxy proxy, SocksSocketConnection.DESTTYPE destType) {
        super(proxy, destType);
    }

    @Deprecated
    public Socks5SocketConnection(HTTPProxy proxy, SocksHTTPconnection.DESTTYPE destType) {
        super(proxy, SocksHTTPconnection.DESTTYPE.convert(destType));
    }

    public Socks5SocketConnection(HTTPProxy proxy) {
        this(proxy, SocksSocketConnection.DESTTYPE.AUTO);
    }

    @Override
    protected SocksSocketConnection.DESTTYPE initSocksSocketConnection(HTTPProxy proxy, SocksSocketConnection.DESTTYPE destType) {
        if (destType == null) {
            destType = SocksSocketConnection.DESTTYPE.AUTO;
        }
        this.supportedDestType.add(SocksSocketConnection.DESTTYPE.AUTO);
        this.supportedDestType.add(SocksSocketConnection.DESTTYPE.IPV4);
        this.supportedDestType.add(SocksSocketConnection.DESTTYPE.IPV6);
        this.supportedDestType.add(SocksSocketConnection.DESTTYPE.DOMAIN);
        if (!this.supportedDestType.contains((Object)destType)) {
            throw new IllegalArgumentException("Unsupported dest type:" + (Object)((Object)destType));
        }
        return destType;
    }

    @Override
    protected HTTPProxy isProxySupported(HTTPProxy proxy) {
        if (proxy != null && HTTPProxy.TYPE.SOCKS5.equals(proxy.getType())) {
            return proxy;
        }
        throw new IllegalArgumentException("proxy must be of type socks5:" + proxy);
    }

    @Override
    protected SocketStreamInterface connectProxySocket(SocketStreamInterface proxySocket, SocketAddress endPoint, StringBuffer logger) throws IOException {
        HTTPProxy proxy = this.getProxy();
        String userName = proxy.getUser();
        String passWord = proxy.getPass();
        SocksSocketConnection.AUTH authOffer = !StringUtils.isEmpty(userName) || !StringUtils.isEmpty(passWord) ? SocksSocketConnection.AUTH.PLAIN : SocksSocketConnection.AUTH.NONE;
        try {
            SocksSocketConnection.AUTH authRequest = this.sayHello(proxySocket, authOffer, logger);
            switch (authRequest) {
                case NONE: {
                    break;
                }
                case PLAIN: {
                    switch (authOffer) {
                        case NONE: {
                            throw new Socks5AuthException(AUTH_ERROR.MISSING_PLAIN);
                        }
                        case PLAIN: {
                            this.authPlain(proxySocket, userName, passWord, logger);
                        }
                    }
                }
            }
            return this.establishConnection(this, proxySocket, this.setEndPointSocketAddress(endPoint), this.getDestType(endPoint), logger);
        }
        catch (ProxyConnectException e) {
            throw e;
        }
        catch (Socks5AuthException e) {
            throw new ProxyAuthException(e, proxy);
        }
        catch (Socks5EndpointConnectException e) {
            throw new ProxyEndpointConnectException(e, this.getProxy(), endPoint);
        }
        catch (IOException e) {
            throw new ProxyConnectException(e, this.getProxy());
        }
    }

    protected SocketStreamInterface establishConnection(Socks5SocketConnection socks5SocketConnection, SocketStreamInterface proxySocket, SocketAddress endpoint, SocksSocketConnection.DESTTYPE destType, StringBuffer logger) throws IOException {
        byte[] read;
        SocksSocketConnection.DESTTYPE usedDestType;
        InetSocketAddress endPointAddress = (InetSocketAddress)endpoint;
        OutputStream os = proxySocket.getOutputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(5);
        bos.write(1);
        bos.write(0);
        switch (destType) {
            case IPV4: 
            case AUTO: {
                if (SocksSocketConnection.DESTTYPE.AUTO.equals((Object)destType) && this.isSupported(SocksSocketConnection.DESTTYPE.IPV4) || SocksSocketConnection.DESTTYPE.IPV4.equals((Object)destType)) {
                    InetAddress ipv4 = endPointAddress.getAddress();
                    if (ipv4 != null && ipv4.getAddress().length == 4) {
                        bos.write(1);
                        if (logger != null) {
                            logger.append("->SEND tcp connect request to:" + endpoint + " by ipv4:" + ipv4.getHostAddress() + "\r\n");
                        }
                        bos.write(ipv4.getAddress());
                        usedDestType = SocksSocketConnection.DESTTYPE.IPV4;
                        break;
                    }
                    if (SocksSocketConnection.DESTTYPE.IPV4.equals((Object)destType) && logger != null) {
                        if (ipv4 == null) {
                            logger.append("->Cannot connect request by ipv4 (unresolved)\r\n");
                        } else {
                            logger.append("->Cannot connect request by ipv4 (no ipv4)\r\n");
                        }
                    }
                }
            }
            case IPV6: {
                if (SocksSocketConnection.DESTTYPE.AUTO.equals((Object)destType) && this.isSupported(SocksSocketConnection.DESTTYPE.IPV6) || SocksSocketConnection.DESTTYPE.IPV6.equals((Object)destType)) {
                    InetAddress ipv6 = endPointAddress.getAddress();
                    if (ipv6 != null && ipv6.getAddress().length == 16) {
                        bos.write(4);
                        if (logger != null) {
                            logger.append("->SEND tcp connect request to:" + endpoint + " by ipv6:" + ipv6.getHostAddress() + "\r\n");
                        }
                        bos.write(ipv6.getAddress());
                        usedDestType = SocksSocketConnection.DESTTYPE.IPV6;
                        break;
                    }
                    if (SocksSocketConnection.DESTTYPE.IPV6.equals((Object)destType) && logger != null) {
                        if (ipv6 == null) {
                            logger.append("->Cannot connect request by ipv6 (unresolved)\r\n");
                        } else {
                            logger.append("->Cannot connect request by ipv6 (no ipv6)\r\n");
                        }
                    }
                }
            }
            case DOMAIN: {
                if (SocksSocketConnection.DESTTYPE.AUTO.equals((Object)destType) && this.isSupported(SocksSocketConnection.DESTTYPE.DOMAIN) || SocksSocketConnection.DESTTYPE.DOMAIN.equals((Object)destType)) {
                    bos.write(3);
                    String domainString = SocketConnection.getHostName(endPointAddress);
                    if (logger != null) {
                        logger.append("->SEND tcp connect request to:" + endpoint + " by domain:" + domainString + "\r\n");
                    }
                    byte[] domainBytes = domainString.getBytes(ISO_8859_1);
                    bos.write((byte)domainBytes.length & 0xFF);
                    bos.write(domainBytes);
                    usedDestType = SocksSocketConnection.DESTTYPE.DOMAIN;
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported destType:" + (Object)((Object)destType) + "|endPoint:" + endPointAddress);
            }
        }
        int port = endPointAddress.getPort();
        bos.write(port >> 8 & 0xFF);
        bos.write(port & 0xFF);
        bos.writeTo(os);
        os.flush();
        InputStream is = proxySocket.getInputStream();
        try {
            read = SocketConnection.ensureRead(is, 4, null);
        }
        catch (IOException e) {
            throw new ProxyEndpointConnectException(e, this.getProxy(), endpoint);
        }
        int[] resp = SocketConnection.byteArrayToIntArray(read);
        if (resp[0] != 5) {
            throw new IOException("Invalid response:" + resp[0]);
        }
        switch (resp[1]) {
            case 0: {
                break;
            }
            case 1: {
                throw new Socks5EndpointConnectException(CONNECT_ERROR.GENERAL_SERVER_FAILURE);
            }
            case 2: {
                throw new Socks5EndpointConnectException(CONNECT_ERROR.NOT_ALLOWED_BY_RULESET);
            }
            case 3: {
                throw new Socks5EndpointConnectException(CONNECT_ERROR.NETWORK_UNREACHABLE, usedDestType);
            }
            case 4: {
                throw new Socks5EndpointConnectException(CONNECT_ERROR.HOST_UNREACHABLE, usedDestType);
            }
            case 5: {
                throw new Socks5EndpointConnectException(CONNECT_ERROR.CONNECTION_REFUSED);
            }
            case 6: {
                throw new Socks5EndpointConnectException(CONNECT_ERROR.TTL_EXPIRED);
            }
            case 7: {
                throw new Socks5EndpointConnectException(CONNECT_ERROR.COMMMAND_NOT_SUPPORTED);
            }
            case 8: {
                switch (usedDestType) {
                    case DOMAIN: {
                        throw new Socks5EndpointConnectException(CONNECT_ERROR.ADDRESS_TYPE_NOT_SUPPORTED_DOMAIN, usedDestType);
                    }
                    case IPV4: {
                        throw new Socks5EndpointConnectException(CONNECT_ERROR.ADDRESS_TYPE_NOT_SUPPORTED_IPV4, usedDestType);
                    }
                    case IPV6: {
                        throw new Socks5EndpointConnectException(CONNECT_ERROR.ADDRESS_TYPE_NOT_SUPPORTED_IPV6, usedDestType);
                    }
                }
                throw new Socks5EndpointConnectException(CONNECT_ERROR.ADDRESS_TYPE_NOT_SUPPORTED, usedDestType);
            }
            default: {
                throw new Socks5EndpointConnectException(CONNECT_ERROR.UNKNOWN, usedDestType, "status=" + resp[1]);
            }
        }
        if (resp[3] == 1) {
            byte[] connectedIP = SocketConnection.ensureRead(is, 4, null);
            byte[] connectedPort = SocketConnection.ensureRead(is, 2, null);
            if (logger != null) {
                logger.append("<-BOUND IPv4:" + InetAddress.getByAddress(connectedIP) + ":" + (ByteBuffer.wrap(connectedPort).getShort() & 0xFFFF) + "\r\n");
            }
        } else if (resp[3] == 3) {
            byte[] length = SocketConnection.ensureRead(is, 1, null);
            byte[] connectedDomain = SocketConnection.ensureRead(is, SocketConnection.byteToInt(length[0]), null);
            byte[] connectedPort = SocketConnection.ensureRead(is, 2, null);
            if (logger != null) {
                logger.append("<-BOUND Domain:" + new String(connectedDomain, ISO_8859_1) + ":" + (ByteBuffer.wrap(connectedPort).getShort() & 0xFFFF) + "\r\n");
            }
        } else if (resp[3] == 4) {
            byte[] connectedIP = SocketConnection.ensureRead(is, 16, null);
            byte[] connectedPort = SocketConnection.ensureRead(is, 2, null);
            if (logger != null) {
                logger.append("<-BOUND IPv6:" + InetAddress.getByAddress(connectedIP) + ":" + (ByteBuffer.wrap(connectedPort).getShort() & 0xFFFF) + "\r\n");
            }
        } else {
            throw new Socks5EndpointConnectException(CONNECT_ERROR.ADDRESS_TYPE_NOT_SUPPORTED, usedDestType, String.valueOf(resp[3]));
        }
        return proxySocket;
    }

    protected void authPlain(SocketStreamInterface proxySocket, String userName, String passWord, StringBuffer logger) throws IOException {
        String pass;
        String user = userName == null ? "" : userName;
        String string = pass = passWord == null ? "" : passWord;
        if (logger != null) {
            logger.append("->AUTH user:pass\r\n");
        }
        byte[] userNameBytes = user.getBytes(ISO_8859_1);
        byte[] passWordBytes = pass.getBytes(ISO_8859_1);
        OutputStream os = proxySocket.getOutputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(1);
        bos.write((byte)userNameBytes.length & 0xFF);
        if (userNameBytes.length > 0) {
            bos.write(userNameBytes);
        }
        bos.write((byte)passWordBytes.length & 0xFF);
        if (passWordBytes.length > 0) {
            bos.write(passWordBytes);
        }
        bos.writeTo(os);
        os.flush();
        InputStream is = proxySocket.getInputStream();
        byte[] read = SocketConnection.ensureRead(is, 2, null);
        int[] resp = SocketConnection.byteArrayToIntArray(read);
        if (resp[0] != 1) {
            throw new IOException("Invalid response:" + resp[0]);
        }
        if (resp[1] != 0) {
            if (logger != null) {
                logger.append("<-AUTH Invalid!:" + resp[1] + "\r\n");
            }
            throw new Socks5AuthException(AUTH_ERROR.ERROR, String.valueOf(resp[1]));
        }
        if (logger != null) {
            logger.append("<-AUTH Valid!\r\n");
        }
    }

    protected SocksSocketConnection.AUTH sayHello(SocketStreamInterface proxySocket, SocksSocketConnection.AUTH auth, StringBuffer logger) throws IOException {
        OutputStream os = proxySocket.getOutputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (logger != null) {
            logger.append("->SOCKS5 Hello to:" + SocketConnection.getRootEndPointSocketAddress(proxySocket) + "\r\n");
        }
        bos.write(5);
        boolean plainAuthPossible = SocksSocketConnection.AUTH.PLAIN.equals((Object)auth);
        if (plainAuthPossible) {
            bos.write(1);
            if (logger != null) {
                logger.append("->SOCKS5 Offer Plain Authentication\r\n");
            }
            bos.write(2);
        } else {
            bos.write(1);
            if (logger != null) {
                logger.append("->SOCKS5 Offer None Authentication\r\n");
            }
            bos.write(0);
        }
        bos.writeTo(os);
        os.flush();
        InputStream is = proxySocket.getInputStream();
        byte[] read = SocketConnection.ensureRead(is, 2, null);
        int[] resp = SocketConnection.byteArrayToIntArray(read);
        if (resp[0] != 5) {
            throw new IOException("Invalid response:" + resp[0]);
        }
        if (resp[1] == 255) {
            if (logger != null) {
                logger.append("<-SOCKS5 Authentication Denied\r\n");
            }
            throw new Socks5AuthException(AUTH_ERROR.DENIED);
        }
        if (resp[1] == 2) {
            if (!plainAuthPossible && logger != null) {
                logger.append("->SOCKS5 Plain auth required but not offered!\r\n");
            }
            return SocksSocketConnection.AUTH.PLAIN;
        }
        if (resp[1] == 0) {
            return SocksSocketConnection.AUTH.NONE;
        }
        throw new Socks5AuthException(AUTH_ERROR.UNSUPPORTED, String.valueOf(resp[1]));
    }

    public class Socks5EndpointConnectException
    extends ConnectException {
        private static final long serialVersionUID = -1993301003920927143L;
        private final CONNECT_ERROR error;
        private final SocksSocketConnection.DESTTYPE destType;

        private Socks5EndpointConnectException(CONNECT_ERROR error) {
            this(error, (SocksSocketConnection.DESTTYPE)null);
        }

        private Socks5EndpointConnectException(CONNECT_ERROR error, SocksSocketConnection.DESTTYPE destType) {
            super(error.msg);
            this.error = error;
            this.destType = destType;
        }

        private Socks5EndpointConnectException(CONNECT_ERROR error, SocksSocketConnection.DESTTYPE destType, String msg) {
            super(error.msg + ":" + msg);
            this.error = error;
            this.destType = destType;
        }

        public CONNECT_ERROR getError() {
            return this.error;
        }

        public HTTPProxy getProxy() {
            return Socks5SocketConnection.this.getProxy();
        }

        public SocksSocketConnection.DESTTYPE getDestType() {
            return this.destType;
        }
    }

    public class Socks5AuthException
    extends IOException {
        private static final long serialVersionUID = -6926931806394311910L;
        private final AUTH_ERROR error;

        private Socks5AuthException(AUTH_ERROR error) {
            super(error.name());
            this.error = error;
        }

        private Socks5AuthException(AUTH_ERROR error, String msg) {
            super(error.name() + ":" + msg);
            this.error = error;
        }

        public AUTH_ERROR getError() {
            return this.error;
        }

        public HTTPProxy getProxy() {
            return Socks5SocketConnection.this.getProxy();
        }
    }

    public static enum AUTH_ERROR {
        ERROR,
        MISSING_PLAIN,
        DENIED,
        UNSUPPORTED;

    }

    public static enum CONNECT_ERROR {
        GENERAL_SERVER_FAILURE("Socks5 general server failure"),
        NOT_ALLOWED_BY_RULESET("Socks5 connection not allowed by ruleset"),
        NETWORK_UNREACHABLE("Network is unreachable"),
        HOST_UNREACHABLE("Host is unreachable"),
        CONNECTION_REFUSED("Connection refused"),
        TTL_EXPIRED("TTL expired"),
        COMMMAND_NOT_SUPPORTED("Command not supported"),
        ADDRESS_TYPE_NOT_SUPPORTED("Address type not supported"),
        ADDRESS_TYPE_NOT_SUPPORTED_IPV4("Address type not supported: IPv4"),
        ADDRESS_TYPE_NOT_SUPPORTED_IPV6("Address type not supported: IPv6"),
        ADDRESS_TYPE_NOT_SUPPORTED_DOMAIN("Address type not supported: Domain"),
        UNKNOWN("Unknown");

        private final String msg;

        private CONNECT_ERROR(String msg) {
            this.msg = msg;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

