/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.socketconnection;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.net.SocketFactory;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.ProxyAuthException;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;

public abstract class SocketConnection
extends Socket {
    protected SocketAddress endPointSocketAddress;
    private SocketAddress bindPoint = null;
    private Boolean keepAlive = null;
    private Boolean oobInline = null;
    private final HTTPProxy proxy;
    protected SocketStreamInterface proxySocket = null;
    private Integer receiveBufferSize = null;
    private Boolean reuseAddress = null;
    private Integer sendBufferSize = null;
    private Integer soLinger = null;
    private Integer soTimeout = null;
    private Boolean tcpNoDelay = null;
    private Integer trafficClass = null;
    private final AtomicReference<SocketStreamInterface> pendingConnectSocket = new AtomicReference<Object>(null);
    protected static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    protected HTTPConnectionUtils.IPVERSION ipVersion = null;
    protected volatile InetAddress[] remoteIPs = null;

    public static SocketAddress getRootEndPointSocketAddress(SocketStreamInterface socketStream) {
        if (socketStream != null) {
            Socket socket = socketStream.getSocket();
            SocketAddress ret = SocketConnection.getRootEndPointSocketAddress(socket);
            if (ret == null && socket instanceof SocketConnection) {
                ret = ((SocketConnection)socket).getEndPointSocketAddress();
            }
            return ret;
        }
        return null;
    }

    public static SocketAddress getRootEndPointSocketAddress(Socket socket) {
        SocketAddress ret = null;
        Socket nextSocket = socket;
        while (nextSocket != null) {
            ret = nextSocket.getRemoteSocketAddress();
            if (!(nextSocket instanceof SocketConnection)) break;
            nextSocket = ((SocketConnection)nextSocket).getProxySocket();
        }
        return ret;
    }

    public SocketAddress getEndPointSocketAddress() {
        return this.endPointSocketAddress;
    }

    protected SocketAddress setEndPointSocketAddress(SocketAddress endPointSocketAddress) throws IOException {
        this.endPointSocketAddress = endPointSocketAddress;
        return endPointSocketAddress;
    }

    protected static int ensureRead(InputStream is) throws IOException {
        int read = is.read();
        if (read == -1) {
            throw new EOFException();
        }
        return read;
    }

    protected static byte[] ensureRead(InputStream is, int size, byte[] buffer) throws IOException {
        int done;
        if (size <= 0) {
            throw new IllegalArgumentException("size <=0");
        }
        byte[] buf = buffer == null ? new byte[size] : buffer;
        if (size > buf.length) {
            throw new IOException("buffer too small");
        }
        int read = 0;
        for (done = 0; done < size && (read = is.read(buf, done, size - done)) != -1; done += read) {
        }
        if (done != size) {
            throw new EOFException();
        }
        return buf;
    }

    protected static final int byteToInt(byte b) {
        return b & 0xFF;
    }

    protected static final int[] byteArrayToIntArray(byte[] b) {
        int[] ret = new int[b.length];
        for (int index = 0; index < b.length; ++index) {
            ret[index] = SocketConnection.byteToInt(b[index]);
        }
        return ret;
    }

    public HTTPConnectionUtils.IPVERSION getIPVersion() {
        return this.ipVersion;
    }

    public void setIPVersion(HTTPConnectionUtils.IPVERSION ipVersion) {
        this.ipVersion = ipVersion;
    }

    public SocketConnection(HTTPProxy proxy) {
        this.proxy = this.isProxySupported(proxy);
    }

    protected abstract HTTPProxy isProxySupported(HTTPProxy var1);

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        if (this.proxySocket != null && this.proxySocket.getSocket() != null) {
            this.proxySocket.getSocket().bind(bindpoint);
        } else {
            this.bindPoint = bindpoint;
        }
    }

    public static String getHostName(SocketAddress endpoint) {
        if (endpoint != null && endpoint instanceof InetSocketAddress) {
            InetSocketAddress endPointAddress = (InetSocketAddress)endpoint;
            if (Application.getJavaVersion() >= Application.JAVA17) {
                return endPointAddress.getHostString();
            }
            InetAddress address = endPointAddress.getAddress();
            if (address != null) {
                if (address.getHostName() != null) {
                    return address.getHostName();
                }
                return address.getHostAddress();
            }
            return endPointAddress.getHostName();
        }
        return null;
    }

    @Override
    public synchronized void close() throws IOException {
        SocketStreamInterface socketStream = this.getProxySocketStream();
        if (socketStream != null) {
            socketStream.close();
        } else {
            this.closeConnectSocket();
        }
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    protected SocketStreamInterface createConnectSocket(SocketAddress endPoint, int connectTimeout) throws IOException {
        this.closeConnectSocket();
        final Socket connectSocket = SocketFactory.get().create(this);
        SocketStreamInterface ret = new SocketStreamInterface(){

            @Override
            public Socket getSocket() {
                return connectSocket;
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return connectSocket.getOutputStream();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return connectSocket.getInputStream();
            }

            @Override
            public void close() throws IOException {
                connectSocket.close();
            }
        };
        try {
            this.pendingConnectSocket.set(ret);
            this.setSocketOptions(connectSocket);
        }
        catch (IOException e) {
            connectSocket.close();
            throw e;
        }
        return ret;
    }

    protected boolean closeConnectSocket() throws IOException {
        SocketStreamInterface socket = this.pendingConnectSocket.getAndSet(null);
        if (socket != null) {
            socket.close();
            return true;
        }
        return false;
    }

    protected SocketStreamInterface getConnectSocket() throws IOException {
        SocketStreamInterface socket = this.pendingConnectSocket.get();
        if (socket == null) {
            throw new SocketException("Socket is not connecting");
        }
        return socket;
    }

    @Override
    public void connect(SocketAddress endpoint, int connectTimeout) throws IOException {
        this.connect(endpoint, connectTimeout, null);
    }

    protected InetAddress[] resolvHostIP(HTTPProxy host) throws IOException {
        return HTTPConnectionUtils.resolvHostIP(host.getHost(), this.getIPVersion());
    }

    protected InetAddress[] getRemoteIPs(HTTPProxy proxy, boolean resolve) throws IOException {
        if (this.remoteIPs == null && resolve) {
            this.remoteIPs = this.resolvHostIP(proxy);
        }
        if (resolve && (this.remoteIPs == null || this.remoteIPs.length == 0)) {
            throw new UnknownHostException("Could not resolve(" + (Object)((Object)this.getIPVersion()) + "):" + proxy.getHost());
        }
        return this.remoteIPs;
    }

    protected void setRemoteIPs(InetAddress[] remoteIPs) {
        this.remoteIPs = remoteIPs;
    }

    protected void connect(SocketStreamInterface socketStreamInterface, SocketAddress connectSocketAddress, int connectTimeout) throws IOException {
        if (socketStreamInterface.getSocket() == null) {
            throw new IOException("SocketStreamInterface does not provide a connectable socket");
        }
        this.setEndPointSocketAddress(connectSocketAddress);
        socketStreamInterface.getSocket().connect(connectSocketAddress, connectTimeout);
    }

    public void connect(SocketAddress endpoint, int connectTimeout, StringBuffer logger) throws IOException {
        try {
            int port = this.getProxy().getPort();
            InetAddress[] socksIPs = this.getRemoteIPs(this.getProxy(), true);
            boolean retryFlag = true;
            while (retryFlag) {
                SocketStreamInterface connectedSocket;
                IOException ioE = null;
                retryFlag = false;
                for (InetAddress connectAddress : socksIPs) {
                    InetSocketAddress connectSocketAddress = new InetSocketAddress(connectAddress, port);
                    try {
                        if (connectTimeout == 0) {
                            SocketStreamInterface connectSocket = this.createConnectSocket(endpoint, connectTimeout);
                            this.connect(connectSocket, connectSocketAddress, connectTimeout);
                        } else {
                            int remainingConnectTimeout = connectTimeout;
                            while (true) {
                                long beforeConnectMS = Time.systemIndependentCurrentJVMTimeMillis();
                                try {
                                    SocketStreamInterface connectSocket = this.createConnectSocket(endpoint, connectTimeout);
                                    this.connect(connectSocket, connectSocketAddress, connectTimeout);
                                }
                                catch (IOException e) {
                                    this.closeConnectSocket();
                                    if (Exceptions.containsInstanceOf(e, ConnectException.class, SocketTimeoutException.class) && StringUtils.containsIgnoreCase(e.getMessage(), "timed out")) {
                                        long timeout = Time.systemIndependentCurrentJVMTimeMillis() - beforeConnectMS;
                                        if (timeout < 1000L) {
                                            int sleep = Math.max(100, (int)(2000L - timeout));
                                            System.out.println("Too Fast ConnectTimeout(Normal): " + timeout + "->Wait " + sleep);
                                            try {
                                                Thread.sleep(sleep);
                                                timeout = Time.systemIndependentCurrentJVMTimeMillis() - beforeConnectMS;
                                            }
                                            catch (InterruptedException ie) {
                                                throw Exceptions.addSuppressed(e, ie);
                                            }
                                        }
                                        int lastConnectTimeout = remainingConnectTimeout;
                                        if ((remainingConnectTimeout = (int)Math.max(0L, (long)remainingConnectTimeout - timeout)) == 0) {
                                            throw e;
                                        }
                                        if (Thread.currentThread().isInterrupted()) {
                                            throw e;
                                        }
                                        System.out.println("Workaround for ConnectTimeout(Normal): " + lastConnectTimeout + ">" + timeout);
                                        continue;
                                    }
                                    throw e;
                                }
                                break;
                            }
                        }
                        ioE = null;
                        break;
                    }
                    catch (IOException e) {
                        if (logger != null) {
                            logger.append("->" + e.getMessage() + ":" + connectSocketAddress + "\r\n");
                        }
                        ioE = e;
                        this.closeConnectSocket();
                    }
                }
                if (ioE != null) {
                    throw ioE;
                }
                SocketStreamInterface connectSocket = this.getConnectSocket();
                try {
                    connectedSocket = this.connectProxySocket(connectSocket, endpoint, logger);
                }
                catch (IOException e) {
                    if (this.retryConnectProxySocket(e, connectSocket, endpoint)) {
                        this.closeConnectSocket();
                        if (logger != null) {
                            logger.append("->" + e.getMessage() + "\r\n");
                        }
                        retryFlag = true;
                        continue;
                    }
                    throw e;
                }
                if (connectedSocket != null) {
                    this.proxySocket = connectedSocket;
                    return;
                }
                throw new ProxyConnectException(this.getProxy());
            }
        }
        catch (ProxyAuthException e) {
            throw e;
        }
        catch (ProxyConnectException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ProxyConnectException(e, this.getProxy());
        }
        finally {
            if (this.proxySocket == null) {
                this.closeConnectSocket();
            }
        }
    }

    protected boolean retryConnectProxySocket(IOException e, SocketStreamInterface connectSocket, SocketAddress endpoint) {
        return false;
    }

    protected abstract SocketStreamInterface connectProxySocket(SocketStreamInterface var1, SocketAddress var2, StringBuffer var3) throws IOException;

    public SocketStreamInterface getProxySocketStream() {
        return this.proxySocket;
    }

    protected Socket getProxySocket() {
        SocketStreamInterface lProxySocket = this.getProxySocketStream();
        if (lProxySocket != null) {
            return lProxySocket.getSocket();
        }
        return null;
    }

    @Override
    public SocketChannel getChannel() {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getChannel();
        }
        return null;
    }

    @Override
    public InetAddress getInetAddress() {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getInetAddress();
        }
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        SocketStreamInterface socketStream = this.getProxySocketStream();
        if (socketStream != null) {
            return socketStream.getInputStream();
        }
        throw new SocketException("Socket is not connected");
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getKeepAlive();
        }
        if (this.keepAlive != null) {
            return this.keepAlive;
        }
        throw new SocketException("Socket is not connected");
    }

    @Override
    public InetAddress getLocalAddress() {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getLocalAddress();
        }
        return new InetSocketAddress(0).getAddress();
    }

    @Override
    public int getLocalPort() {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getLocalPort();
        }
        return -1;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getLocalSocketAddress();
        }
        return null;
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getOOBInline();
        }
        if (this.oobInline != null) {
            return this.oobInline;
        }
        throw new SocketException("Socket is not connected");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        SocketStreamInterface socketStream = this.getProxySocketStream();
        if (socketStream != null) {
            return socketStream.getOutputStream();
        }
        throw new SocketException("Socket is not connected");
    }

    @Override
    public int getPort() {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getPort();
        }
        return -1;
    }

    public HTTPProxy getProxy() {
        return this.proxy;
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getReceiveBufferSize();
        }
        if (this.receiveBufferSize != null) {
            return this.receiveBufferSize;
        }
        throw new SocketException("Socket is not connected");
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getRemoteSocketAddress();
        }
        return null;
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getReuseAddress();
        }
        if (this.reuseAddress != null) {
            return this.reuseAddress;
        }
        throw new SocketException("Socket is not connected");
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getSendBufferSize();
        }
        if (this.sendBufferSize != null) {
            return this.sendBufferSize;
        }
        throw new SocketException("Socket is not connected");
    }

    @Override
    public int getSoLinger() throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getSoLinger();
        }
        return this.soLinger == null ? -1 : this.soLinger;
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getSoTimeout();
        }
        if (this.soTimeout != null) {
            return this.soTimeout;
        }
        throw new SocketException("Socket is not connected");
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getTcpNoDelay();
        }
        if (this.tcpNoDelay != null) {
            return this.tcpNoDelay;
        }
        throw new SocketException("Socket is not connected");
    }

    @Override
    public int getTrafficClass() throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.getTrafficClass();
        }
        if (this.trafficClass != null) {
            return this.trafficClass;
        }
        throw new SocketException("Socket is not connected");
    }

    @Override
    public boolean isBound() {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.isBound();
        }
        return this.bindPoint != null;
    }

    @Override
    public boolean isClosed() {
        Socket socket = this.getProxySocket();
        return socket != null && socket.isClosed();
    }

    @Override
    public boolean isConnected() {
        Socket socket = this.getProxySocket();
        return socket != null && socket.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        Socket socket = this.getProxySocket();
        return socket != null && socket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        Socket socket = this.getProxySocket();
        return socket != null && socket.isOutputShutdown();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            socket.sendUrgentData(data);
        }
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            socket.setKeepAlive(on);
        } else {
            this.keepAlive = on;
        }
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            socket.setOOBInline(on);
        } else {
            this.oobInline = on;
        }
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            socket.setPerformancePreferences(connectionTime, latency, bandwidth);
        }
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            socket.setReceiveBufferSize(size);
        } else {
            this.receiveBufferSize = size;
        }
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            socket.setReuseAddress(on);
        } else {
            this.reuseAddress = on;
        }
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            socket.setSendBufferSize(size);
        } else {
            this.sendBufferSize = size;
        }
    }

    @Override
    public String toString() {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            return socket.toString();
        }
        return super.toString();
    }

    private void setSocketOptions(Socket connectSocket) throws IOException {
        if (connectSocket != null) {
            if (this.bindPoint != null) {
                connectSocket.bind(this.bindPoint);
            }
            if (this.keepAlive != null) {
                connectSocket.setKeepAlive(this.keepAlive);
            }
            if (this.receiveBufferSize != null) {
                connectSocket.setReceiveBufferSize(this.receiveBufferSize);
            }
            if (this.reuseAddress != null) {
                connectSocket.setReuseAddress(this.reuseAddress);
            }
            if (this.sendBufferSize != null) {
                connectSocket.setSendBufferSize(this.sendBufferSize);
            }
            if (this.soLinger != null) {
                connectSocket.setSoLinger(true, this.soLinger);
            }
            if (this.tcpNoDelay != null) {
                connectSocket.setTcpNoDelay(this.tcpNoDelay);
            }
            if (this.trafficClass != null) {
                connectSocket.setTrafficClass(this.trafficClass);
            }
            if (this.oobInline != null) {
                connectSocket.setOOBInline(this.oobInline);
            }
            if (this.soTimeout != null) {
                connectSocket.setSoTimeout(this.soTimeout);
            }
        }
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            socket.setSoLinger(on, linger);
        } else {
            this.soLinger = on ? Integer.valueOf(linger) : null;
        }
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            socket.setSoTimeout(timeout);
        } else {
            this.soTimeout = timeout;
        }
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            socket.setTcpNoDelay(on);
        } else {
            this.tcpNoDelay = on;
        }
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        Socket socket = this.getProxySocket();
        if (socket != null) {
            socket.setTrafficClass(tc);
        } else {
            this.trafficClass = tc;
        }
    }

    @Override
    public void shutdownInput() throws IOException {
        Socket socket = this.getProxySocket();
        if (socket == null) {
            throw new SocketException("Socket is not connected");
        }
        socket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        Socket socket = this.getProxySocket();
        if (socket == null) {
            throw new SocketException("Socket is not connected");
        }
        socket.shutdownOutput();
    }
}

