/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpserver.session;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.SessionRemoteAPIRequest;
import org.appwork.remoteapi.exceptions.ApiCommandNotAvailable;
import org.appwork.remoteapi.exceptions.AuthException;
import org.appwork.remoteapi.exceptions.BasicRemoteAPIException;
import org.appwork.utils.net.httpserver.handler.HttpRequestHandler;
import org.appwork.utils.net.httpserver.handler.HttpSessionRequestHandler;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.net.httpserver.session.HttpSession;
import org.appwork.utils.net.httpserver.session.LoginAPIInterface;

public abstract class HttpSessionController<T extends HttpSession>
implements HttpRequestHandler,
LoginAPIInterface {
    private List<HttpSessionRequestHandler<T>> handler = new ArrayList<HttpSessionRequestHandler<T>>();

    @Override
    public boolean disconnect(RemoteAPIRequest request) {
        SessionRemoteAPIRequest req = (SessionRemoteAPIRequest)request;
        Object session = req.getSession();
        if (session != null) {
            return this.removeSession(session);
        }
        return false;
    }

    protected String extractSessionID(HttpRequest request) {
        Iterator<KeyValuePair> it = request.getRequestedURLParameters().iterator();
        while (it.hasNext()) {
            KeyValuePair next = it.next();
            if (!"token".equalsIgnoreCase(next.key)) continue;
            it.remove();
            return next.value;
        }
        return null;
    }

    protected abstract T getSession(HttpRequest var1, String var2);

    @Override
    public String handshake(RemoteAPIRequest request, String user, String password) throws AuthException {
        T session = this.newSession(request, user, password);
        if (session == null) {
            throw new AuthException();
        }
        return session.getSessionID();
    }

    protected abstract T newSession(RemoteAPIRequest var1, String var2, String var3);

    @Override
    public boolean onGetRequest(GetRequest request, HttpResponse response) throws BasicRemoteAPIException {
        List<HttpSessionRequestHandler<T>> handlers = this.handler;
        T session = this.getSession(request, this.extractSessionID(request));
        ApiCommandNotAvailable notFound = null;
        for (HttpSessionRequestHandler<T> handler : handlers) {
            try {
                if (!handler.onGetSessionRequest(session, request, response)) continue;
                return true;
            }
            catch (ApiCommandNotAvailable e) {
                notFound = e;
            }
        }
        if (notFound != null) {
            throw notFound;
        }
        return false;
    }

    @Override
    public boolean onPostRequest(PostRequest request, HttpResponse response) throws BasicRemoteAPIException {
        List<HttpSessionRequestHandler<T>> handlers = this.handler;
        T session = this.getSession(request, this.extractSessionID(request));
        ApiCommandNotAvailable notFound = null;
        for (HttpSessionRequestHandler<T> handler : handlers) {
            try {
                if (!handler.onPostSessionRequest(session, request, response)) continue;
                return true;
            }
            catch (ApiCommandNotAvailable e) {
                notFound = e;
            }
        }
        if (notFound != null) {
            throw notFound;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSessionRequestHandler(HttpSessionRequestHandler<T> handler) {
        HttpSessionController httpSessionController = this;
        synchronized (httpSessionController) {
            if (!this.handler.contains(handler)) {
                ArrayList<HttpSessionRequestHandler<T>> newhandler = new ArrayList<HttpSessionRequestHandler<T>>(this.handler);
                newhandler.add(handler);
                this.handler = newhandler;
            }
        }
    }

    protected abstract boolean removeSession(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSessionRequestHandler(HttpSessionRequestHandler<T> handler) {
        HttpSessionController httpSessionController = this;
        synchronized (httpSessionController) {
            ArrayList<HttpSessionRequestHandler<T>> newhandler = new ArrayList<HttpSessionRequestHandler<T>>(this.handler);
            newhandler.remove(handler);
            this.handler = newhandler;
        }
    }
}

