/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpserver.requests;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.appwork.utils.net.HeaderCollection;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.RawHttpConnectionInterface;
import org.appwork.utils.net.httpserver.requests.HTTPBridge;
import org.appwork.utils.net.httpserver.requests.HttpRequestInterface;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;

public abstract class HttpRequest
implements HttpRequestInterface {
    protected String requestedURL = null;
    protected HeaderCollection requestHeaders = null;
    protected String requestedPath = null;
    protected boolean https = false;
    protected List<KeyValuePair> requestedURLParameters = null;
    private List<String> remoteAddress = new ArrayList<String>();
    protected final RawHttpConnectionInterface connection;
    private HTTPBridge bridge;
    private final long id;
    private static AtomicLong REQUEST_ID_COUNTER = new AtomicLong(0L);

    public abstract HttpConnection.HttpConnectionType getHttpConnectionType();

    public boolean isHttps() {
        return this.https;
    }

    public void setHttps(boolean https) {
        this.https = https;
    }

    public RawHttpConnectionInterface getConnection() {
        return this.connection;
    }

    public HttpRequest(RawHttpConnectionInterface connection) {
        this.connection = connection;
        this.id = REQUEST_ID_COUNTER.incrementAndGet();
    }

    @Override
    public long getId() {
        return this.id;
    }

    public List<String> getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public String getRequestedPath() {
        return this.requestedPath;
    }

    @Override
    public String getRequestedURL() {
        return this.requestedURL;
    }

    @Override
    public List<KeyValuePair> getRequestedURLParameters() {
        return this.requestedURLParameters;
    }

    @Override
    public HeaderCollection getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRemoteAddress(List<String> remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setRequestedPath(String requestedPath) {
        this.requestedPath = requestedPath;
    }

    public void setRequestedURL(String requestedURL) {
        this.requestedURL = requestedURL;
    }

    public void setRequestedURLParameters(List<KeyValuePair> requestedURLParameters) {
        this.requestedURLParameters = requestedURLParameters;
    }

    public void setRequestHeaders(HeaderCollection requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public String getActuallRemoteAddress() {
        List<String> addresses = this.getRemoteAddress();
        if (addresses == null || addresses.size() == 0) {
            return null;
        }
        if (addresses.size() == 1) {
            return addresses.get(0);
        }
        return addresses.get(1);
    }

    public void setBridge(HTTPBridge bridge) {
        this.bridge = bridge;
    }

    public HTTPBridge getBridge() {
        return this.bridge;
    }
}

