/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpserver.requests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.RawHttpConnectionInterface;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;

public class GetRequest
extends HttpRequest {
    public GetRequest(RawHttpConnectionInterface connection) {
        super(connection);
    }

    @Override
    public String getParameterbyKey(String key) throws IOException {
        List<KeyValuePair> params = this.getRequestedURLParameters();
        if (params != null) {
            for (KeyValuePair param : params) {
                if (!StringUtils.equalsIgnoreCase(key, param.key)) continue;
                return param.value;
            }
        }
        return null;
    }

    @Override
    public String[] getParametersbyKey(String key) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        List<KeyValuePair> params = this.getRequestedURLParameters();
        if (params != null) {
            for (KeyValuePair param : params) {
                if (!StringUtils.equalsIgnoreCase(key, param.key)) continue;
                ret.add(param.value);
            }
            if (ret.size() > 0) {
                return ret.toArray(new String[0]);
            }
        }
        return null;
    }

    @Override
    public HttpConnection.HttpConnectionType getHttpConnectionType() {
        return HttpConnection.HttpConnectionType.GET;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n----------------Request " + this.getId() + "-------------------------\r\n");
        sb.append("GET ").append(this.getRequestedURL()).append(" HTTP/1.1\r\n");
        for (HTTPHeader key : this.getRequestHeaders()) {
            sb.append(key.getKey());
            sb.append(": ");
            sb.append(key.getValue());
            sb.append("\r\n");
        }
        return sb.toString();
    }
}

