/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.appwork.utils.net.httpserver.HttpHandlerInfo;
import org.appwork.utils.net.httpserver.HttpServer;
import org.appwork.utils.net.httpserver.handler.HttpRequestHandler;

public class HttpServerController {
    private final List<HttpServer> servers = new ArrayList<HttpServer>();

    public synchronized HttpServer getServer(int port) {
        for (HttpServer s : this.servers) {
            if ((port != 0 || s.getWishedPort() != port) && s.getPort() != port) continue;
            return s;
        }
        return null;
    }

    public synchronized HttpHandlerInfo registerRequestHandler(int port, boolean localhost, HttpRequestHandler handler) throws IOException {
        HttpServer server = null;
        for (HttpServer s : this.servers) {
            if ((port != 0 || s.getWishedPort() != port) && s.getPort() != port) continue;
            server = s;
            break;
        }
        if (server == null) {
            server = this.createServer(port);
            server.setLocalhostOnly(localhost);
            server.start();
            this.servers.add(server);
        }
        if (!localhost && server.isLocalhostOnly()) {
            server.shutdown();
            server.setLocalhostOnly(false);
            server.start();
        }
        return server.registerRequestHandler(handler);
    }

    protected HttpServer createServer(int port) {
        return new HttpServer(port);
    }

    public synchronized void unregisterRequestHandler(HttpHandlerInfo handlerInfo) {
        if (this.servers.contains(handlerInfo.getHttpServer())) {
            handlerInfo.getHttpServer().unregisterRequestHandler(handlerInfo.getHttpHandler());
            if (handlerInfo.getHttpServer().getHandler().isEmpty()) {
                this.servers.remove(handlerInfo.getHttpServer());
                handlerInfo.getHttpServer().shutdown();
            }
        }
    }
}

