/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection.proxy;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.processes.ProcessBuilderFactory;

public class WindowsProxyUtils {
    public static List<HTTPProxy> getWindowsRegistryProxies() {
        ArrayList<HTTPProxy> ret;
        block14: {
            ret = new ArrayList<HTTPProxy>();
            try {
                ProcessBuilder pb = ProcessBuilderFactory.create("reg", "query", "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings");
                Process process = pb.start();
                String result = IO.readInputStreamToString(process.getInputStream());
                process.destroy();
                try {
                    String autoProxy = new Regex(result, "AutoConfigURL\\s+REG_SZ\\s+([^\r\n]+)").getMatch(0);
                    if (!StringUtils.isEmpty(autoProxy)) {
                        LogV3.info("AutoProxy.pac Script found: " + autoProxy);
                    }
                }
                catch (Exception autoProxy) {
                    // empty catch block
                }
                String enabledString = new Regex(result, "ProxyEnable\\s+REG_DWORD\\s+(\\d+x\\d+)").getMatch(0);
                if ("0x0".equals(enabledString)) {
                    return ret;
                }
                String val = new Regex(result, " ProxyServer\\s+REG_SZ\\s+([^\r\n]+)").getMatch(0);
                if (val == null) break block14;
                LogV3.info("Registry Result:\r\n" + result);
                for (String vals : val.split(";")) {
                    HTTPProxy pd;
                    int rPOrt;
                    String lowerCaseVals = vals.toLowerCase(Locale.ENGLISH);
                    if (lowerCaseVals.startsWith("ftp=")) continue;
                    String proxyurl = new Regex(vals = vals.replaceAll("^.*=", ""), "(\\d+\\.\\d+\\.\\d+\\.\\d+)").getMatch(0);
                    if (proxyurl == null) {
                        try {
                            URL url = new URL(vals);
                            proxyurl = url.getHost();
                        }
                        catch (MalformedURLException url) {
                            // empty catch block
                        }
                        if (proxyurl == null && (proxyurl = new Regex(vals, ".+=(.*?)(:\\d+$|:\\d+/|/|$)").getMatch(0)) == null) {
                            proxyurl = new Regex(vals, "=?(.*?)(:\\d+$|:\\d+/|/|$)").getMatch(0);
                        }
                    }
                    String port = new Regex(vals, ":(\\d+)(/|$)").getMatch(0);
                    if (proxyurl == null) continue;
                    if (lowerCaseVals.startsWith("socks")) {
                        rPOrt = port != null ? Integer.parseInt(port) : 1080;
                        pd = new HTTPProxy(HTTPProxy.TYPE.SOCKS5);
                        pd.setHost(proxyurl);
                        pd.setPort(rPOrt);
                        ret.add(pd);
                        continue;
                    }
                    if (lowerCaseVals.startsWith("https")) {
                        rPOrt = port != null ? Integer.parseInt(port) : 443;
                        pd = new HTTPProxy(HTTPProxy.TYPE.HTTPS);
                        pd.setHost(proxyurl);
                        pd.setPort(rPOrt);
                        ret.add(pd);
                        continue;
                    }
                    if (lowerCaseVals.startsWith("http")) {
                        rPOrt = port != null ? Integer.parseInt(port) : 8080;
                        pd = new HTTPProxy(HTTPProxy.TYPE.HTTP);
                        pd.setHost(proxyurl);
                        pd.setPort(rPOrt);
                        ret.add(pd);
                        continue;
                    }
                    rPOrt = port != null ? Integer.parseInt(port) : 8080;
                    pd = new HTTPProxy(HTTPProxy.TYPE.HTTP);
                    pd.setHost(proxyurl);
                    pd.setPort(rPOrt);
                    LogV3.info("Use HTTP as default Proxy Type " + pd);
                    ret.add(pd);
                }
            }
            catch (Throwable e) {
                LogV3.log(e);
            }
        }
        return ret;
    }
}

