/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.UnsupportedEncodingException;
import java.net.IDN;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import org.appwork.utils.Exceptions;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;
import org.appwork.utils.net.httpconnection.X509TrustManagerBridge;

public class SSLSocketStreamFactory18 {
    protected static X509TrustManagerBridge bridge(final X509ExtendedTrustManager trustMaster) {
        return new X509TrustManagerBridge(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return trustMaster.getAcceptedIssuers();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket, SSLEngine engine) throws CertificateException {
                if (socket != null) {
                    trustMaster.checkServerTrusted(chain, authType, socket);
                } else if (engine != null) {
                    trustMaster.checkServerTrusted(chain, authType, engine);
                } else {
                    trustMaster.checkServerTrusted(chain, authType);
                }
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket, SSLEngine engine) throws CertificateException {
                if (socket != null) {
                    trustMaster.checkClientTrusted(chain, authType, socket);
                } else if (engine != null) {
                    trustMaster.checkClientTrusted(chain, authType, engine);
                } else {
                    trustMaster.checkClientTrusted(chain, authType);
                }
            }

            @Override
            public X509ExtendedTrustManager getTrustManager() {
                return trustMaster;
            }
        };
    }

    protected static X509ExtendedTrustManager bridge(final X509TrustManagerBridge trustManagerBridge) throws SSLException {
        return new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                trustManagerBridge.checkClientTrusted(chain, authType, null, null);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                trustManagerBridge.checkServerTrusted(chain, authType, null, null);
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return trustManagerBridge.getAcceptedIssuers();
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                trustManagerBridge.checkClientTrusted(chain, authType, socket, null);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                trustManagerBridge.checkServerTrusted(chain, authType, socket, null);
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                trustManagerBridge.checkClientTrusted(chain, authType, null, engine);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                trustManagerBridge.checkServerTrusted(chain, authType, null, engine);
            }
        };
    }

    public static void setSNIServerName(SSLSocketStreamOptions options, SSLSocket sslSocket, String sniHostName) {
        if (options.isSNIEnabled() && StringUtils.isNotEmpty(sniHostName)) {
            SSLParameters sslParams = sslSocket.getSSLParameters();
            List<SNIServerName> serverNames = sslParams.getServerNames();
            if (serverNames == null || serverNames.size() == 0) {
                try {
                    SNIHostName sniServerName = null;
                    try {
                        sniServerName = new SNIHostName(sniHostName);
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            sniServerName = new SNIHostName(IDN.toASCII(sniHostName).getBytes("UTF-8"));
                        }
                        catch (UnsupportedEncodingException e2) {
                            throw Exceptions.addSuppressed(e, e2);
                        }
                    }
                    serverNames = Arrays.asList(sniServerName);
                    sslParams.setServerNames(serverNames);
                    sslSocket.setSSLParameters(sslParams);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else if (!options.isSNIEnabled()) {
            SSLParameters sslParams = sslSocket.getSSLParameters();
            sslParams.setServerNames(Arrays.asList(new SNIServerName[0]));
            sslSocket.setSSLParameters(sslParams);
        }
    }
}

