/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.KeepAliveSocketStreamException;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;

public class KeepAliveSocketStream
implements SocketStreamInterface {
    protected final SocketStreamInterface socket;
    protected final InetAddress boundIP;
    protected final String host;
    protected final InetAddress[] remoteIPs;
    protected final long keepAliveTimeout;
    protected final long maxRequests;
    protected final HTTPProxy proxy;
    protected volatile long keepAliveTimestamp = -1L;
    protected volatile long requests = 0L;
    protected final InputStream is;
    protected final OutputStream os;

    public InetAddress getBoundIP() {
        return this.boundIP;
    }

    public InetAddress[] getRemoteIPs() {
        return this.remoteIPs;
    }

    public boolean sameBoundIP(InetAddress[] bindIP) {
        InetAddress boundIP = this.getBoundIP();
        if (bindIP == null && boundIP == null) {
            return true;
        }
        if (bindIP != null && boundIP != null) {
            for (InetAddress bind : bindIP) {
                if (!bind.equals(boundIP)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean sameHost(String otherHost) {
        return StringUtils.equalsIgnoreCase(this.getHost(), otherHost);
    }

    public boolean sameRemoteIPs(InetAddress[] remoteIPs) {
        if (remoteIPs != null && remoteIPs.length > 0) {
            InetAddress socketRemoteIP = this.socket.getSocket().getInetAddress();
            for (InetAddress remoteIP : remoteIPs) {
                if (!socketRemoteIP.equals(remoteIP)) continue;
                return true;
            }
            if (this.getRemoteIPs() != null) {
                for (InetAddress knownRemoteIP : this.getRemoteIPs()) {
                    for (InetAddress remoteIP : remoteIPs) {
                        if (!knownRemoteIP.equals(remoteIP)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public long getRequestsLeft() {
        return Math.max(0L, this.getRequestsMax() - this.requests);
    }

    public long getRequestsMax() {
        return this.maxRequests;
    }

    public void increaseRequests() {
        ++this.requests;
    }

    public boolean isSsl() {
        return false;
    }

    public boolean isTimedOut() {
        return Time.systemIndependentCurrentJVMTimeMillis() >= this.keepAliveTimestamp;
    }

    public void keepAlive() {
        this.keepAliveTimestamp = Time.systemIndependentCurrentJVMTimeMillis() + this.getKeepAliveTimeout();
    }

    public KeepAliveSocketStream(HTTPProxy proxy, String host, final SocketStreamInterface socket, long keepAliveTimeout, long maxRequests, InetAddress boundIP, InetAddress[] remoteIPs) {
        this.proxy = proxy;
        this.host = host;
        this.socket = socket;
        this.boundIP = boundIP;
        this.remoteIPs = remoteIPs;
        this.keepAliveTimeout = Math.max(0L, keepAliveTimeout);
        this.maxRequests = Math.max(0L, maxRequests);
        this.os = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                try {
                    socket.getOutputStream().write(b);
                }
                catch (IOException e) {
                    throw new KeepAliveSocketStreamException(e, KeepAliveSocketStream.this);
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
                try {
                    socket.getOutputStream().write(b);
                }
                catch (IOException e) {
                    throw new KeepAliveSocketStreamException(e, KeepAliveSocketStream.this);
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                try {
                    socket.getOutputStream().write(b, off, len);
                }
                catch (IOException e) {
                    throw new KeepAliveSocketStreamException(e, KeepAliveSocketStream.this);
                }
            }

            @Override
            public void flush() throws IOException {
                try {
                    socket.getOutputStream().flush();
                }
                catch (IOException e) {
                    throw new KeepAliveSocketStreamException(e, KeepAliveSocketStream.this);
                }
            }

            @Override
            public void close() throws IOException {
            }
        };
        this.is = new InputStream(){

            @Override
            public int read() throws IOException {
                try {
                    return socket.getInputStream().read();
                }
                catch (IOException e) {
                    throw new KeepAliveSocketStreamException(e, KeepAliveSocketStream.this);
                }
            }

            @Override
            public int read(byte[] b) throws IOException {
                try {
                    return socket.getInputStream().read(b);
                }
                catch (IOException e) {
                    throw new KeepAliveSocketStreamException(e, KeepAliveSocketStream.this);
                }
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                try {
                    return socket.getInputStream().read(b, off, len);
                }
                catch (IOException e) {
                    throw new KeepAliveSocketStreamException(e, KeepAliveSocketStream.this);
                }
            }

            @Override
            public long skip(long n) throws IOException {
                try {
                    return socket.getInputStream().skip(n);
                }
                catch (IOException e) {
                    throw new KeepAliveSocketStreamException(e, KeepAliveSocketStream.this);
                }
            }

            @Override
            public int available() throws IOException {
                try {
                    return socket.getInputStream().available();
                }
                catch (IOException e) {
                    throw new KeepAliveSocketStreamException(e, KeepAliveSocketStream.this);
                }
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public String getHost() {
        return this.host;
    }

    @Override
    public Socket getSocket() {
        return this.socket.getSocket();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }
}

