/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.math.BigInteger;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Application;
import org.appwork.utils.JDK8BufferHelper;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.encoding.RFC2047;
import org.appwork.utils.net.CountingInputStreamInterface;
import org.appwork.utils.net.httpconnection.HTTPConnection;

public class HTTPConnectionUtils {
    private static final AtomicReference<Object[]> lastIPv6EnvironmentResult = new AtomicReference();
    private static Map<InetAddress, Integer> GUA = new HashMap<InetAddress, Integer>();
    private static Map<InetAddress, Integer> RESERVED_GUA = new HashMap<InetAddress, Integer>();
    private static final String preferIPv6Addresses;
    private static final String preferIPv4Stack;
    public static final byte R = 13;
    public static final byte N = 10;
    private static Boolean LOCALHOST_RESOLVE;

    public static InetSocketAddress removeHostName(InetSocketAddress addr) {
        if (addr == null || addr.getAddress() == null) {
            return addr;
        }
        return new InetSocketAddress(addr.getAddress(), addr.getPort());
    }

    public static String debug(CountingInputStreamInterface countingInputStream) {
        if (countingInputStream == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        CountingInputStreamInterface next = countingInputStream;
        while (next != null) {
            sb.append(next.getClass().getName()).append("=").append(next.transferedBytes());
            InputStream parent = next.getParentInputStream();
            if (!(parent instanceof CountingInputStreamInterface)) break;
            next = (CountingInputStreamInterface)((Object)parent);
            sb.append("->");
        }
        return sb.toString();
    }

    public static Boolean verifySSLHostname(HostnameVerifier hostNameVerifier, SSLSession sslSession, String host) throws IOException {
        try {
            Certificate certificate;
            Boolean hostNameVerifierResult;
            if (hostNameVerifier == null) {
                hostNameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            }
            Boolean bl = hostNameVerifierResult = hostNameVerifier != null ? Boolean.valueOf(hostNameVerifier.verify(host, sslSession)) : null;
            if (sslSession != null && sslSession.getPeerCertificates().length > 0 && (certificate = sslSession.getPeerCertificates()[0]) instanceof X509Certificate) {
                String hostname = host.toLowerCase(Locale.ENGLISH);
                HashSet<String> subjects = new HashSet<String>();
                X509Certificate x509 = (X509Certificate)certificate;
                subjects.add(new Regex(x509.getSubjectX500Principal().getName(), "CN\\s*=\\s*(.*?)(,| |$)").getMatch(0));
                try {
                    Collection<List<?>> subjectAlternativeNames = x509.getSubjectAlternativeNames();
                    if (subjectAlternativeNames != null) {
                        for (List<?> subjectAlternativeName : subjectAlternativeNames) {
                            Integer generalNameType = (Integer)subjectAlternativeName.get(0);
                            switch (generalNameType) {
                                case 1: 
                                case 2: {
                                    subjects.add(subjectAlternativeName.get(1).toString());
                                }
                            }
                        }
                    }
                }
                catch (CertificateParsingException e) {
                    e.printStackTrace();
                }
                subjects.remove(null);
                boolean result = false;
                for (String subject : subjects) {
                    if (StringUtils.equals(subject = subject.toLowerCase(Locale.ENGLISH), hostname)) {
                        result = true;
                        break;
                    }
                    if (!subject.startsWith("*.") || hostname.length() <= subject.length() - 1 || !hostname.endsWith(subject.substring(1)) || hostname.substring(0, hostname.length() - subject.length() + 1).indexOf(46) >= 0) continue;
                    result = true;
                    break;
                }
                if (hostNameVerifierResult != null && hostNameVerifierResult != result) {
                    LogV3.severe("Please check NativeSSLSocketStreamFactory.verifySSLHostname for " + host + "|HostnameVerifier<" + hostNameVerifierResult + "> != verifySSLHostname<" + result + ">");
                }
                if (!result) {
                    throw new IOException("HTTPS hostname wrong:  should be <" + host + "> != " + subjects);
                }
                return true;
            }
            if (hostNameVerifierResult != null) {
                return (boolean)hostNameVerifierResult;
            }
            return null;
        }
        catch (SSLPeerUnverifiedException e) {
            return null;
        }
    }

    public static boolean is6to4Address(Inet6Address ip) {
        byte[] raw = ip != null ? ip.getAddress() : null;
        return raw != null && raw.length == 16 && raw[0] == 32 && raw[1] == 2;
    }

    public static boolean isUniqueLocalUnicast(Inet6Address ip) {
        byte[] raw = ip != null ? ip.getAddress() : null;
        return raw != null && raw.length == 16 && raw[0] == -3;
    }

    public static boolean isGlobalUnicast(Inet6Address ip) {
        byte[] raw;
        byte[] byArray = raw = ip != null ? ip.getAddress() : null;
        if (raw != null && raw.length == 16) {
            try {
                for (Map.Entry<InetAddress, Integer> gua : RESERVED_GUA.entrySet()) {
                    if (!HTTPConnectionUtils.contains(gua.getKey(), gua.getValue(), ip)) continue;
                    return false;
                }
                for (Map.Entry<InetAddress, Integer> gua : GUA.entrySet()) {
                    if (!HTTPConnectionUtils.contains(gua.getKey(), gua.getValue(), ip)) continue;
                    return true;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static boolean contains(InetAddress network, int prefixLength, InetAddress address) {
        if (network == null || network.getAddress() == null) {
            return false;
        }
        if (address == null || address.getAddress() == null) {
            return false;
        }
        if (network.getAddress().length != address.getAddress().length) {
            return false;
        }
        if (network.getAddress().length != 4 && network.getAddress().length != 16) {
            return false;
        }
        int bits = 8 * network.getAddress().length;
        if (prefixLength < 1 || prefixLength > bits) {
            return false;
        }
        BigInteger n = new BigInteger(1, network.getAddress());
        BigInteger a = new BigInteger(1, address.getAddress());
        return n.shiftRight(bits - prefixLength).compareTo(a.shiftRight(bits - prefixLength)) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean isGlobalIPv6Available(int verifyTimeout, int searchTimeout, long cacheTimeout) {
        AtomicReference<Object[]> atomicReference = lastIPv6EnvironmentResult;
        synchronized (atomicReference) {
            Thread thread;
            Object[] current = lastIPv6EnvironmentResult.get();
            if (current != null) {
                if (Time.systemIndependentCurrentJVMTimeMillis() - (Long)current[1] < cacheTimeout) {
                    return current[0] != null ? Boolean.TRUE : Boolean.FALSE;
                }
                if (current[0] != null) {
                    final Object[] verify = current;
                    thread = new Thread("isGlobalIPv6Available:verify:" + verify[0]){

                        @Override
                        public void run() {
                            try {
                                NetworkInterface netif = NetworkInterface.getByInetAddress((InetAddress)verify[0]);
                                if (netif != null && netif.isUp()) {
                                    Object[] globalIPv6 = new Object[]{verify[0], Time.systemIndependentCurrentJVMTimeMillis()};
                                    lastIPv6EnvironmentResult.set(globalIPv6);
                                }
                            }
                            catch (IOException iOException) {
                            }
                            finally {
                                lastIPv6EnvironmentResult.compareAndSet(verify, null);
                            }
                        }
                    };
                    thread.setDaemon(true);
                    thread.start();
                    if (verifyTimeout >= 0) {
                        try {
                            thread.join(verifyTimeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if ((current = lastIPv6EnvironmentResult.get()) != null && current != verify && current[0] != null) {
                        return Boolean.TRUE;
                    }
                }
            }
            final Object[] search = current;
            thread = new Thread("isGlobalIPv6Available:search"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                        while (networkInterfaces.hasMoreElements()) {
                            if (lastIPv6EnvironmentResult.get() != search) {
                                return;
                            }
                            NetworkInterface networkInterface = networkInterfaces.nextElement();
                            try {
                                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                                Enumeration<InetAddress> inetAddress = networkInterface.getInetAddresses();
                                while (inetAddress.hasMoreElements()) {
                                    Inet6Address ipv6;
                                    InetAddress next = inetAddress.nextElement();
                                    if (!(next instanceof Inet6Address) || (ipv6 = (Inet6Address)next).isLinkLocalAddress() || ipv6.isSiteLocalAddress() || HTTPConnectionUtils.is6to4Address(ipv6) || HTTPConnectionUtils.isUniqueLocalUnicast(ipv6) || !HTTPConnectionUtils.isGlobalUnicast(ipv6)) continue;
                                    Object[] globalIPv6 = new Object[]{ipv6, Time.systemIndependentCurrentJVMTimeMillis()};
                                    lastIPv6EnvironmentResult.set(globalIPv6);
                                    return;
                                }
                            }
                            catch (IOException iOException) {
                            }
                        }
                        Object[] noGlobalIPv6 = new Object[]{null, Time.systemIndependentCurrentJVMTimeMillis()};
                        lastIPv6EnvironmentResult.compareAndSet(search, noGlobalIPv6);
                        return;
                    }
                    catch (IOException iOException) {
                        return;
                    }
                    finally {
                        lastIPv6EnvironmentResult.compareAndSet(search, null);
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            if (searchTimeout >= 0) {
                try {
                    thread.join(searchTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (thread.isAlive()) {
                Object[] noGlobalIPv6 = new Object[]{null, Time.systemIndependentCurrentJVMTimeMillis()};
                lastIPv6EnvironmentResult.compareAndSet(search, noGlobalIPv6);
            }
            if ((current = lastIPv6EnvironmentResult.get()) != null && search != current) {
                return current[0] != null ? Boolean.TRUE : Boolean.FALSE;
            }
            return null;
        }
    }

    public static IPVERSION selectIPVersion(IPVERSION ipVersion) {
        if (ipVersion == null) {
            ipVersion = IPVERSION.SYSTEM;
        }
        switch (ipVersion) {
            case IPV4_ONLY: 
            case IPV4_IPV6: 
            case IPV6_IPV4: {
                return ipVersion;
            }
        }
        if ("true".equals(preferIPv4Stack)) {
            return IPVERSION.IPV4_ONLY;
        }
        if (JVMVersion.isMinimum(JVMVersion.JAVA_9) && "system".equals(preferIPv6Addresses)) {
            return IPVERSION.SYSTEM;
        }
        if ("true".equals(preferIPv6Addresses)) {
            return IPVERSION.IPV6_IPV4;
        }
        if ("false".equals(preferIPv6Addresses)) {
            return IPVERSION.IPV4_IPV6;
        }
        if (Boolean.TRUE.equals(HTTPConnectionUtils.isGlobalIPv6Available(1000, 1000, 60000L))) {
            return IPVERSION.IPV6_IPV4;
        }
        return ipVersion;
    }

    public static InetAddress[] sortAndFilter(InetAddress[] inetAddresses, IPVERSION ipVersion) {
        if (inetAddresses != null && ipVersion != null) {
            InetAddress[] ret;
            switch (ipVersion) {
                case IPV4_ONLY: {
                    ArrayList<InetAddress> ipv4Only = new ArrayList<InetAddress>();
                    for (InetAddress ip : inetAddresses) {
                        if (!(ip instanceof Inet4Address)) continue;
                        ipv4Only.add(ip);
                    }
                    ret = ipv4Only.toArray(new InetAddress[0]);
                    break;
                }
                case IPV4_IPV6: {
                    ret = (InetAddress[])inetAddresses.clone();
                    Arrays.sort(ret, new Comparator<InetAddress>(){

                        @Override
                        private final int compare(boolean x, boolean y) {
                            return x == y ? 0 : (x ? 1 : -1);
                        }

                        @Override
                        public int compare(InetAddress o1, InetAddress o2) {
                            boolean x = o1 instanceof Inet6Address;
                            boolean y = o2 instanceof Inet6Address;
                            return this.compare(x, y);
                        }
                    });
                    break;
                }
                case IPV6_IPV4: {
                    ret = (InetAddress[])inetAddresses.clone();
                    Arrays.sort(ret, new Comparator<InetAddress>(){

                        @Override
                        private final int compare(boolean x, boolean y) {
                            return x == y ? 0 : (x ? 1 : -1);
                        }

                        @Override
                        public int compare(InetAddress o1, InetAddress o2) {
                            boolean x = o1 instanceof Inet4Address;
                            boolean y = o2 instanceof Inet4Address;
                            return this.compare(x, y);
                        }
                    });
                    break;
                }
                default: {
                    ret = inetAddresses;
                }
            }
            return ret;
        }
        return inetAddresses;
    }

    public static InetAddress[] resolvHostIP(String host, IPVERSION ipVersion) throws UnknownHostException {
        ipVersion = HTTPConnectionUtils.selectIPVersion(ipVersion);
        InetAddress[] ret = HTTPConnectionUtils.resolvHostIP(host);
        if ((ret = HTTPConnectionUtils.sortAndFilter(ret, ipVersion)) != null && ret.length > 0) {
            return ret;
        }
        throw new UnknownHostException("Could not resolve(" + (Object)((Object)ipVersion) + "):" + host);
    }

    public static String getFileNameFromDispositionHeader(String contentdisposition) {
        DispositionHeader ret = HTTPConnectionUtils.parseDispositionHeader(contentdisposition);
        if (ret != null) {
            return ret.getFilename();
        }
        return null;
    }

    public static DispositionHeader parseDispositionHeader(String contentdisposition) {
        if (!StringUtils.isEmpty(contentdisposition)) {
            if (contentdisposition.matches("(?i)^\\s*(attachment|inline)\\s*;?\\s*$")) {
                return null;
            }
            if (contentdisposition.matches("(?i)^\\s*(attachment|inline)\\s*;?\\s*filename\\s*=\\s*$")) {
                return null;
            }
            if (contentdisposition.matches("(?i).*(;| |^)filename\\*\\s*=\\s*[\\w\\-]*'[\\w\\-]*'.+")) {
                String[] rfc2231 = new Regex(contentdisposition, "(?:;| |^)filename\\*\\s*=\\s*([\\w\\-]*)'([\\w\\-]*)'(.*?)($|;\\s*|;$)").getRow(0);
                String encoding = rfc2231[0];
                String language = rfc2231[1];
                String raw = rfc2231[2];
                if (StringUtils.isEmpty(encoding)) {
                    LogV3.severe("Missing encoding: " + contentdisposition);
                    return null;
                }
                if (raw == null) {
                    LogV3.severe("Broken/Unsupported: " + contentdisposition);
                    return null;
                }
                try {
                    Charset charSet = Charset.forName(encoding.trim());
                    String fileName = URLDecoder.decode(raw.trim(), charSet.name()).trim();
                    fileName = fileName.replaceFirst("^" + Matcher.quoteReplacement("\\") + "+", Matcher.quoteReplacement("_"));
                    if (StringUtils.isNotEmpty(fileName)) {
                        CharSequence rfc2047 = new RFC2047().decode(fileName);
                        if (rfc2047 != null && rfc2047 != fileName) {
                            return new DispositionHeader(contentdisposition, raw, rfc2047.toString(), charSet);
                        }
                        return new DispositionHeader(contentdisposition, raw, fileName, charSet);
                    }
                    return null;
                }
                catch (Exception e) {
                    if (encoding.startsWith("\"")) {
                        String fixedQuotes = contentdisposition.replaceFirst(Pattern.quote(encoding), Matcher.quoteReplacement(encoding.substring(1)));
                        if (fixedQuotes.endsWith("\"")) {
                            fixedQuotes = fixedQuotes.substring(0, fixedQuotes.length() - 1);
                        }
                        return HTTPConnectionUtils.parseDispositionHeader(fixedQuotes);
                    }
                    LogV3.severe("Decoding Error: " + raw + "|" + encoding + "|" + contentdisposition + "|" + e.getMessage());
                    return null;
                }
            }
            if (contentdisposition.matches("(?i).*(;| |^)(filename|file_name|name)\\s*=.+")) {
                String raw = new Regex(contentdisposition, "(?:;| |^)(filename|file_name|name)\\s*=\\s*(\"|'|)(.*?)(\\2$|\\2;$|\\2;.)").getMatch(2);
                if (raw == null) {
                    LogV3.severe("Broken/Unsupported: " + contentdisposition);
                    return null;
                }
                String fileName = raw.trim();
                CharSequence rfc2047 = new RFC2047().decode(fileName);
                if (rfc2047 != null && rfc2047 != fileName) {
                    return new DispositionHeader(contentdisposition, raw, rfc2047.toString(), null);
                }
                if (StringUtils.isNotEmpty(fileName = fileName.replaceFirst("^" + Matcher.quoteReplacement("\\") + "+", Matcher.quoteReplacement("_")))) {
                    return new DispositionHeader(contentdisposition, raw, fileName, null);
                }
                return null;
            }
            if (contentdisposition.matches("(?i).*(;| |^)filename\\*\\s*=.+")) {
                String[] rfc2231 = new Regex(contentdisposition, "(?:;| |^)filename\\*\\s*=\\s*(\"|)(.*?)(\\1$|\\1;\\s*|\\1;$)").getRow(0);
                if (rfc2231 == null) {
                    LogV3.severe("Broken/Unsupported: " + contentdisposition);
                    return null;
                }
                String raw = rfc2231[1];
                if ("\"".equals(rfc2231[0]) && "\"".equals(rfc2231[2]) && raw.matches("(?i)\\s*[\\w\\-]*'[\\w\\-]*'.+")) {
                    return HTTPConnectionUtils.parseDispositionHeader("attachment; filename*=" + raw);
                }
                String fileName = raw.trim();
                if (StringUtils.isNotEmpty(fileName)) {
                    return new DispositionHeader(contentdisposition, raw, fileName, null);
                }
                return null;
            }
            if (contentdisposition.matches("(?i).*xfilename.*")) {
                return null;
            }
            LogV3.severe("Broken/Unsupported: " + contentdisposition);
            return null;
        }
        return null;
    }

    public static ByteBuffer readheader(InputStream in, boolean readSingleLine) throws IOException {
        ByteBuffer bigbuffer = ByteBuffer.wrap(new byte[4096]);
        byte[] minibuffer = new byte[1];
        while (in.read(minibuffer) >= 0) {
            int position;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            if (bigbuffer.remaining() < 1) {
                ByteBuffer newbuffer = ByteBuffer.wrap(new byte[bigbuffer.capacity() * 2]);
                JDK8BufferHelper.flip(bigbuffer);
                newbuffer.put(bigbuffer);
                bigbuffer = newbuffer;
            }
            bigbuffer.put(minibuffer);
            if (!(readSingleLine ? bigbuffer.position() >= 1 && (bigbuffer.get((position = bigbuffer.position()) - 1) == 10 || bigbuffer.position() >= 2 && bigbuffer.get(position - 2) == 13 && bigbuffer.get(position - 1) == 10) : bigbuffer.position() >= 2 && (bigbuffer.get((position = bigbuffer.position()) - 2) == 10 && bigbuffer.get(position - 1) == 10 || bigbuffer.position() >= 4 && (bigbuffer.get(position - 4) == 13 && bigbuffer.get(position - 3) == 10 && bigbuffer.get(position - 2) == 13 && bigbuffer.get(position - 1) == 10 || bigbuffer.get(position - 4) != 13 && bigbuffer.get(position - 3) == 10 && bigbuffer.get(position - 2) == 13 && bigbuffer.get(position - 1) == 10)))) continue;
        }
        JDK8BufferHelper.flip(bigbuffer);
        return bigbuffer;
    }

    public static long[] parseRequestRange(HTTPConnection connection) {
        String requestRange = connection != null ? connection.getRequestProperty("Range") : null;
        return HTTPConnectionUtils.parseRequestRange(requestRange);
    }

    public static long[] parseRequestRange(String requestRange) {
        String from = new Regex(requestRange, "bytes\\s*=\\s*(\\d*)\\s*-").getMatch(0);
        String to = new Regex(requestRange, "bytes\\s*=\\s*.*?-\\s*(\\d*)").getMatch(0);
        long[] ret = new long[]{-1L, -1L};
        if (StringUtils.isNotEmpty(from)) {
            ret[0] = Long.parseLong(from);
        }
        if (StringUtils.isNotEmpty(to)) {
            ret[1] = Long.parseLong(to);
        }
        return ret;
    }

    public static long[] parseContentRange(HTTPConnection httpConnection) {
        String contentRange;
        String string = contentRange = httpConnection != null ? httpConnection.getHeaderField("Content-Range") : null;
        if (contentRange != null) {
            String[] range = null;
            range = new Regex(contentRange, "\\s*(\\d+)\\s*-\\s*(\\d+)\\s*/\\s*(?:\\{\\s*)?(\\d+|\\*)").getRow(0);
            if (range != null) {
                long gotSB = Long.parseLong(range[0]);
                long gotEB = Long.parseLong(range[1]);
                long gotS = "*".equals(range[2]) ? -1L : Long.parseLong(range[2]);
                return new long[]{gotSB, gotEB, gotS};
            }
            range = new Regex(contentRange, "\\s*(\\d+)\\s*-\\s*/\\s*(?:\\{\\s*)?(\\d+|\\*)").getRow(0);
            if (range != null && (httpConnection == null || httpConnection.getResponseCode() != 416)) {
                long gotSB = Long.parseLong(range[0]);
                if ("*".equals(range[1])) {
                    return new long[]{gotSB, -1L, -1L};
                }
                long gotS = Long.parseLong(range[1]);
                return new long[]{gotSB, gotS - 1L, gotS};
            }
            if ((httpConnection == null || httpConnection.getResponseCode() == 416) && (range = new Regex(contentRange, ".\\s*\\*\\s*/\\s*(?:\\{\\s*)?(\\d+|\\*)").getRow(0)) != null) {
                return new long[]{-1L, -1L, "*".equals(range[0]) ? -1L : Long.parseLong(range[0])};
            }
            if ((httpConnection == null || httpConnection.getResponseCode() == 206) && (range = new Regex(contentRange, "[ \\*]+/\\s*(?:\\{\\s*)?(\\d+)").getRow(0)) != null) {
                return new long[]{-1L, Long.parseLong(range[0]), Long.parseLong(range[0])};
            }
            range = new Regex(contentRange, "\\s*bytes\\s*-\\s*(\\d+)/\\s*(?:\\{\\s*)?(\\d+)").getRow(0);
            if (range != null) {
                return new long[]{0L, Long.parseLong(range[0]), Long.parseLong(range[1])};
            }
            LogV3.info("parseContentRange: format is unknown: " + contentRange);
            return null;
        }
        return null;
    }

    public static InetAddress[] getLoopback(IPVERSION ipVersion) throws UnknownHostException {
        final CopyOnWriteArrayList<InetAddress> loInetAddresses = new CopyOnWriteArrayList<InetAddress>();
        Thread lookup = new Thread("getLoopback"){

            @Override
            public void run() {
                NetworkInterface lo = null;
                try {
                    Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                    while (networkInterfaces.hasMoreElements()) {
                        NetworkInterface networkInterface = networkInterfaces.nextElement();
                        if (!networkInterface.isUp() || !networkInterface.isLoopback()) continue;
                        if (lo == null && "lo".equals(networkInterface.getName())) {
                            lo = networkInterface;
                        }
                        Enumeration<InetAddress> inetAddress = networkInterface.getInetAddresses();
                        while (inetAddress.hasMoreElements()) {
                            InetAddress next = inetAddress.nextElement();
                            loInetAddresses.addIfAbsent(next);
                        }
                    }
                }
                catch (IOException networkInterfaces) {
                    // empty catch block
                }
                if (lo == null) {
                    try {
                        lo = NetworkInterface.getByName("lo");
                        if (lo != null && lo.isUp() && lo.isLoopback()) {
                            Enumeration<InetAddress> inetAddress = lo.getInetAddresses();
                            while (inetAddress.hasMoreElements()) {
                                InetAddress next = inetAddress.nextElement();
                                loInetAddresses.addIfAbsent(next);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        lookup.setDaemon(true);
        lookup.start();
        try {
            lookup.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (loInetAddresses.isEmpty()) {
            if (!Boolean.FALSE.equals(LOCALHOST_RESOLVE)) {
                try {
                    loInetAddresses.addAllAbsent(Arrays.asList(InetAddress.getAllByName("localhost")));
                    LOCALHOST_RESOLVE = Boolean.TRUE;
                }
                catch (UnknownHostException ignore) {
                    LOCALHOST_RESOLVE = Boolean.FALSE;
                }
            }
            try {
                loInetAddresses.addIfAbsent(InetAddress.getByName("127.0.0.1"));
            }
            catch (UnknownHostException ignore) {
                // empty catch block
            }
            try {
                loInetAddresses.addIfAbsent(InetAddress.getByName("::1"));
            }
            catch (UnknownHostException ignore) {
                // empty catch block
            }
        }
        ipVersion = HTTPConnectionUtils.selectIPVersion(ipVersion);
        InetAddress[] ret = loInetAddresses.toArray(new InetAddress[0]);
        if ((ret = HTTPConnectionUtils.sortAndFilter(ret, ipVersion)) != null && ret.length > 0) {
            return ret;
        }
        throw new UnknownHostException("Could not resolve(" + (Object)((Object)ipVersion) + ") loopback");
    }

    public static InetAddress[] resolvHostIP(String host) throws UnknownHostException {
        if (StringUtils.isEmpty(host)) {
            throw new UnknownHostException("Could not resolve: -empty host-");
        }
        String resolvHost = !host.matches("^[a-zA-Z0-9\\-\\.]+$") && Application.getJavaVersion() >= Application.JAVA16 ? IDN.toASCII(host.trim()) : host.trim();
        for (int resolvTry = 0; resolvTry < 2; ++resolvTry) {
            try {
                return InetAddress.getAllByName(resolvHost);
            }
            catch (UnknownHostException e) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        throw new UnknownHostException("Could not resolve: -" + host + "<->" + resolvHost + "-");
    }

    static {
        try {
            GUA.put(InetAddress.getByName("2001:0200::"), 23);
            GUA.put(InetAddress.getByName("2001:0400::"), 23);
            GUA.put(InetAddress.getByName("2001:0600::"), 23);
            GUA.put(InetAddress.getByName("2001:0800::"), 22);
            GUA.put(InetAddress.getByName("2001:0c00::"), 23);
            RESERVED_GUA.put(InetAddress.getByName("2001:db8::"), 32);
            GUA.put(InetAddress.getByName("2001:0e00::"), 23);
            GUA.put(InetAddress.getByName("2001:1200::"), 23);
            GUA.put(InetAddress.getByName("2001:1400::"), 22);
            GUA.put(InetAddress.getByName("2001:1800::"), 23);
            GUA.put(InetAddress.getByName("2001:1a00::"), 23);
            GUA.put(InetAddress.getByName("2001:1c00::"), 22);
            GUA.put(InetAddress.getByName("2001:2000::"), 19);
            GUA.put(InetAddress.getByName("2001:4000::"), 23);
            GUA.put(InetAddress.getByName("2001:4200::"), 23);
            GUA.put(InetAddress.getByName("2001:4400::"), 23);
            GUA.put(InetAddress.getByName("2001:4600::"), 23);
            GUA.put(InetAddress.getByName("2001:4800::"), 23);
            GUA.put(InetAddress.getByName("2001:4a00::"), 23);
            GUA.put(InetAddress.getByName("2001:4c00::"), 23);
            GUA.put(InetAddress.getByName("2001:5000::"), 23);
            GUA.put(InetAddress.getByName("2001:8000::"), 19);
            GUA.put(InetAddress.getByName("2001:a000::"), 20);
            GUA.put(InetAddress.getByName("2001:b000::"), 20);
            GUA.put(InetAddress.getByName("2003:0000::"), 18);
            GUA.put(InetAddress.getByName("2400:0000::"), 12);
            GUA.put(InetAddress.getByName("2600:0000::"), 12);
            GUA.put(InetAddress.getByName("2610:0000::"), 23);
            GUA.put(InetAddress.getByName("2620:0000::"), 23);
            GUA.put(InetAddress.getByName("2630:0000::"), 23);
            GUA.put(InetAddress.getByName("2800:0000::"), 12);
            GUA.put(InetAddress.getByName("2a00:0000::"), 12);
            GUA.put(InetAddress.getByName("2a10:0000::"), 12);
            GUA.put(InetAddress.getByName("2c00:0000::"), 12);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        preferIPv6Addresses = System.getProperty("java.net.preferIPv6Addresses");
        preferIPv4Stack = System.getProperty("java.net.preferIPv4Stack");
        LOCALHOST_RESOLVE = null;
    }

    public static class DispositionHeader {
        private final String header;
        private final String raw;
        private final String filename;
        private final Charset encoding;

        public String getHeader() {
            return this.header;
        }

        public final String getRaw() {
            return this.raw;
        }

        public final String getFilename() {
            return this.filename;
        }

        public final Charset getEncoding() {
            return this.encoding;
        }

        public String toString() {
            return "RAW:" + this.getRaw() + "|Decoded:" + this.getFilename() + "|Encoding:" + this.getEncoding();
        }

        protected DispositionHeader(String header, String raw, String filename, Charset encoding) {
            this.raw = raw;
            this.filename = filename;
            this.encoding = encoding;
            this.header = header;
        }
    }

    public static enum IPVERSION {
        IPV4_ONLY,
        IPV4_IPV6,
        IPV6_IPV4,
        SYSTEM;

    }
}

