/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpclient;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.IO;
import org.appwork.utils.Interruptible;
import org.appwork.utils.InterruptibleThread;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.BasicHTTP.ReadIOException;
import org.appwork.utils.net.BasicHTTP.WriteIOException;
import org.appwork.utils.net.ChunkedOutputStream;
import org.appwork.utils.net.CountingConnection;
import org.appwork.utils.net.CountingInputStream;
import org.appwork.utils.net.DownloadProgress;
import org.appwork.utils.net.URLHelper;
import org.appwork.utils.net.httpclient.BadRangeResponse;
import org.appwork.utils.net.httpclient.HttpClientException;
import org.appwork.utils.net.httpclient.InvalidRedirectException;
import org.appwork.utils.net.httpclient.InvalidResponseCode;
import org.appwork.utils.net.httpclient.RedirectTimeoutException;
import org.appwork.utils.net.httpclient.TooManyRedirectsException;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionFactory;
import org.appwork.utils.net.httpconnection.HTTPConnectionProfilerAdapter;
import org.appwork.utils.net.httpconnection.HTTPOutputStream;
import org.appwork.utils.net.httpconnection.HTTPProxy;

public class HttpClient {
    private static final HttpClient DEFAULT_HTTP_CLIENT = new HttpClient();
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected HashSet<Integer> allowedResponseCodes = new HashSet<Integer>(Arrays.asList(-1));
    protected int connectTimeout = 15000;
    protected LogInterface logger = null;
    protected HTTPProxy proxy = HTTPProxy.NONE;
    protected int readTimeout = 30000;
    protected final HashMap<String, String> requestHeader;
    private final List<RequestContext> requests = new CopyOnWriteArrayList<RequestContext>();

    public HttpClient() {
        this.requestHeader = new HashMap();
    }

    protected void checkResponseCode(RequestContext context) throws InvalidResponseCode {
        HashSet<Integer> allowedResponseCodes = this.getAllowedResponseCodes();
        if (allowedResponseCodes != null) {
            if (allowedResponseCodes.contains(-1)) {
                return;
            }
            if (!allowedResponseCodes.contains(context.getConnection().getResponseCode())) {
                throw new InvalidResponseCode(context);
            }
        }
    }

    public void clearRequestHeader() {
        this.getRequestHeader().clear();
    }

    protected HTTPOutputStream connect(RequestContext context, boolean returnOutputStream) throws IOException, InterruptedException, UnknownHostException {
        int lookupTry = 0;
        try {
            while (true) {
                try {
                    context.getConnection().connect();
                    context.onConnected();
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                }
                catch (UnknownHostException e) {
                    if (++lookupTry > 3) {
                        throw e;
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Thread.sleep(200L);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new HttpClientException(context, (Throwable)new ReadIOException(e));
        }
        if (!returnOutputStream) {
            return null;
        }
        HTTPOutputStream raw = context.getConnection().getOutputStream();
        return raw;
    }

    protected HTTPConnection createHTTPConnection(RequestContext context) throws HttpClientException {
        HTTPConnection connection;
        try {
            connection = HTTPConnectionFactory.createHTTPConnection(context.redirectTo != null ? context.redirectTo : new URL(context.getUrl()), this.getProxy());
        }
        catch (MalformedURLException e) {
            throw new HttpClientException(null, (Throwable)e);
        }
        context.setConnection(connection);
        return connection;
    }

    public RequestContext delete(String url) throws IOException, InterruptedException {
        return this.execute(new RequestContext().setMethod(HTTPConnection.RequestMethod.DELETE).setUrl(url));
    }

    public boolean followRedirect(RequestContext context) throws IOException, InterruptedException {
        if (context.connection.getResponseCode() == 301 || context.connection.getResponseCode() == 302 || context.connection.getResponseCode() == 303 || context.connection.getResponseCode() == 307) {
            String red = context.connection.getHeaderField("Location");
            if (red != null) {
                if (context.connection.getResponseCode() == 302) {
                    Thread.sleep(125L);
                } else {
                    Thread.sleep(250L);
                }
                context.redirectTo = new URL(URLHelper.parseLocation(context.redirectTo == null ? new URL(context.getUrl()) : context.redirectTo, red));
                if (context.redirectsStarted <= 0L) {
                    context.redirectsStarted = Time.systemIndependentCurrentJVMTimeMillis();
                }
                context.redirectCounter++;
                return true;
            }
            throw new InvalidRedirectException(context);
        }
        return false;
    }

    public RequestContext get(String url) throws IOException, InterruptedException {
        return this.execute(new RequestContext().setMethod(HTTPConnection.RequestMethod.GET).setUrl(url));
    }

    public HashSet<Integer> getAllowedResponseCodes() {
        return this.allowedResponseCodes;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    public HTTPProxy getProxy() {
        return this.proxy;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    protected long getRedirectTimeout(RequestContext context) {
        return 3600000L;
    }

    public HashMap<String, String> getRequestHeader() {
        return this.requestHeader;
    }

    public String getRequestHeader(String key) {
        return this.getRequestHeader().get(key);
    }

    private <E extends Throwable> E handleInterrupt(E exception) throws InterruptedException, E {
        if (exception instanceof InterruptedException) {
            throw (InterruptedException)exception;
        }
        if (Thread.interrupted() || exception instanceof InterruptedIOException) {
            throw Exceptions.addSuppressed(new InterruptedException("Connection Closed by Interrupt"), exception);
        }
        return exception;
    }

    protected void log(HTTPConnection connection) {
        LogInterface logger = this.getLogger();
        if (logger != null && connection != null) {
            try {
                logger.info(connection.toString());
            }
            catch (Throwable e) {
                this.log(e);
            }
        }
    }

    protected void log(Throwable e) {
        LogInterface logger = this.getLogger();
        if (logger != null && e != null) {
            logger.log(e);
        }
    }

    protected void onBeforeConnect(HTTPConnection connection) {
    }

    public RequestContext post(String url, byte[] data) throws IOException, InterruptedException {
        return this.execute(new RequestContext().setMethod(HTTPConnection.RequestMethod.POST).setUrl(url).setPostDataStream(new ByteArrayInputStream(data)).setPostDataLength(data.length));
    }

    public RequestContext post(String url, String utf8STring) throws IOException, InterruptedException {
        return this.post(url, utf8STring.getBytes(UTF8));
    }

    protected void prepareConnection(RequestContext context) {
        this.setAllowedResponseCodes(context);
        context.connection.setConnectTimeout(this.getConnectTimeout());
        context.connection.setReadTimeout(context.getReadTimeout() < 0 ? this.getReadTimeout() : context.getReadTimeout());
        context.connection.setRequestMethod(context.method);
        context.connection.setRequestProperty("Accept-Language", TranslationFactory.getDesiredLanguage());
        context.connection.setRequestProperty("User-Agent", "AppWork " + Application.getApplication());
        context.connection.setRequestProperty("Accept-Charset", UTF8.name());
        context.connection.setRequestProperty("Connection", "Close");
        if (context.getPostDataLength() >= 0) {
            context.connection.setRequestProperty("Content-Length", String.valueOf(context.getPostDataLength()));
        }
        for (Map.Entry<String, String> next : this.getRequestHeader().entrySet()) {
            context.connection.setRequestProperty(next.getKey(), next.getValue());
        }
    }

    public void putRequestHeader(String key, String value) {
        this.getRequestHeader().put(key, value);
    }

    /*
     * Exception decompiling
     */
    protected void readInputStream(RequestContext context, CountingInputStream is) throws InterruptedException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RequestContext execute(RequestContext context) throws InterruptedException, HttpClientException {
        context.executed = true;
        context.client = this;
        this.requests.add(context);
        HTTPConnection connection = this.createHTTPConnection(context);
        boolean followRedirect = false;
        context.linkInterrupt();
        try {
            try {
                this.prepareConnection(context);
                boolean rangeRequest = false;
                long rp = context.getResumePosition();
                if (rp >= 0L) {
                    connection.setRequestProperty("Range", "bytes=" + rp + "-");
                    rangeRequest = true;
                }
                context.onConnect();
                if (context.getPostDataStream() != null) {
                    HTTPOutputStream directHTTPConnectionOutputStream = this.connect(context, true);
                    OutputStream outputStream = this.wrapPostOutputStream(connection, directHTTPConnectionOutputStream);
                    InputStream input = context.getPostDataStream();
                    context.onPostStart();
                    if (context.getPostDataLength() > 0) {
                        int len;
                        byte[] buffer = new byte[Short.MAX_VALUE];
                        while ((len = input.read(buffer)) != -1) {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new InterruptedException();
                            }
                            if (len <= 0) continue;
                            outputStream.write(buffer, 0, len);
                            context.onBytesPosted(buffer, 0, len);
                        }
                        input.close();
                    }
                    boolean before = directHTTPConnectionOutputStream.isClosingAllowed();
                    try {
                        directHTTPConnectionOutputStream.setClosingAllowed(false);
                        outputStream.flush();
                        outputStream.close();
                    }
                    catch (IOException e) {
                        throw new WriteIOException(e);
                    }
                    finally {
                        directHTTPConnectionOutputStream.setClosingAllowed(before);
                    }
                    connection.finalizeConnect();
                    context.onConnected();
                } else {
                    this.connect(context, false);
                }
                context.onConnected();
                if (rangeRequest && connection.getResponseCode() == 200) {
                    throw new BadRangeResponse(context);
                }
                if (connection.getCompleteContentLength() >= 0L) {
                    context.onContentLength(connection.getCompleteContentLength());
                }
                if (!(followRedirect = this.followRedirect(context))) {
                    this.checkResponseCode(context);
                    InputStream input = connection.getInputStream();
                    if (!(input instanceof CountingConnection)) {
                        input = new CountingInputStream(input);
                    }
                    this.readInputStream(context, (CountingInputStream)input);
                }
            }
            catch (ReadIOException e) {
                throw this.handleInterrupt(new HttpClientException(context, (Throwable)e));
            }
            catch (WriteIOException e) {
                throw this.handleInterrupt(new HttpClientException(context, (Throwable)e));
            }
            catch (HttpClientException e) {
                throw this.handleInterrupt(e);
            }
            catch (IOException e) {
                throw this.handleInterrupt(new HttpClientException(context, (Throwable)new ReadIOException(e)));
            }
            finally {
                this.log(connection);
            }
        }
        catch (InterruptedException e) {
            context.onException(e);
            throw e;
        }
        catch (HttpClientException e) {
            context.onException(e);
            throw e;
        }
        finally {
            context.unlinkInterrupt();
        }
        if (followRedirect) {
            if (context.redirectsStarted > 0L && Time.systemIndependentCurrentJVMTimeMillis() - context.redirectsStarted >= this.getRedirectTimeout(context)) {
                throw new RedirectTimeoutException(context, null);
            }
            if (context.redirectCounter > context.getMaxRedirects()) {
                throw new TooManyRedirectsException(context, null);
            }
            context.setPostDataStream(null);
            context.setPostDataLength(-1);
            context.method = HTTPConnection.RequestMethod.GET;
            return this.execute(context);
        }
        return context;
    }

    public void setAllowedResponseCodes(int ... codes) {
        HashSet<Integer> allowedResponseCodes = new HashSet<Integer>();
        for (int i : codes) {
            allowedResponseCodes.add(i);
        }
        this.allowedResponseCodes = allowedResponseCodes;
    }

    protected void setAllowedResponseCodes(RequestContext context) {
        HashSet<Integer> allowedResponseCodes = this.getAllowedResponseCodes();
        if (allowedResponseCodes != null) {
            int[] ret = new int[allowedResponseCodes.size()];
            int i = 0;
            for (Integer allowed : allowedResponseCodes) {
                ret[i++] = allowed;
            }
            context.connection.setAllowedResponseCodes(ret);
        }
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = Math.max(1000, connectTimeout);
    }

    public void setLogger(LogInterface logger) {
        this.logger = logger;
    }

    public void setProxy(HTTPProxy proxy) {
        this.proxy = proxy;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = Math.max(1000, readTimeout);
    }

    public String toString() {
        return super.toString();
    }

    protected OutputStream wrapPostOutputStream(HTTPConnection connection, OutputStream os) throws IOException {
        if (StringUtils.equalsIgnoreCase(connection.getRequestProperty("Transfer-Encoding"), "chunked")) {
            os = new ChunkedOutputStream(os);
        }
        return os;
    }

    public static class RequestContext
    implements Interruptible {
        private Boolean addedToInterruptible;
        private HttpClient client;
        private HTTPConnection connection;
        private DownloadProgress downloadProgress;
        private CountingInputStream inputStream;
        private HTTPConnection.RequestMethod method;
        private OutputStream target = new ByteArrayOutputStream();
        private int postDataLength;
        private InputStream postDataStream;
        private int readTimeout = 0;
        public URL redirectTo;
        private long resumePosition = -1L;
        private DownloadProgress uploadProgress;
        private String url;
        public long redirectsStarted;
        private volatile boolean executed = false;
        private int redirectCounter = 0;
        private int maxRedirects = 5;

        public int getRedirectCounter() {
            return this.redirectCounter;
        }

        public int getMaxRedirects() {
            return this.maxRedirects;
        }

        public void setMaxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
        }

        public static RequestContext get(String url) {
            return new RequestContext().setMethod(HTTPConnection.RequestMethod.GET).setUrl(url);
        }

        public int getCode() {
            return this.getConnection().getResponseCode();
        }

        public HTTPConnection getConnection() {
            return this.connection;
        }

        public DownloadProgress getDownloadProgress() {
            return this.downloadProgress;
        }

        public CountingInputStream getInputStream() throws HttpClientException, InterruptedException {
            this.ensureExecution();
            return this.inputStream;
        }

        public HTTPConnection.RequestMethod getMethod() {
            return this.method;
        }

        public OutputStream getTarget() {
            return this.target;
        }

        public int getPostDataLength() {
            return this.postDataLength;
        }

        public InputStream getPostDataStream() {
            return this.postDataStream;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public byte[] getResponseBytes() throws IOException, InterruptedException {
            CountingInputStream fromContext = this.getInputStream();
            if (fromContext != null) {
                this.target = new ByteArrayOutputStream();
                IO.readStreamToOutputStream(-1, fromContext, this.target, true);
            }
            if (this.target instanceof ByteArrayOutputStream) {
                return ((ByteArrayOutputStream)this.target).toByteArray();
            }
            return null;
        }

        public String getResponseString() throws IOException, InterruptedException {
            return this.getResponseString(null);
        }

        public String getResponseString(Charset charset) throws IOException, InterruptedException {
            CountingInputStream fromContext;
            this.ensureExecution();
            if (charset == null) {
                String ct = this.getConnection().getCharset();
                if (StringUtils.isEmpty(ct)) {
                    ct = "UTF-8";
                }
                charset = Charset.forName(ct);
            }
            if ((fromContext = this.getInputStream()) != null) {
                this.target = new ByteArrayOutputStream();
                IO.readStreamToOutputStream(-1, fromContext, this.target, true);
            }
            if (this.target instanceof ByteArrayOutputStream) {
                return ((ByteArrayOutputStream)this.target).toString(charset.displayName());
            }
            return null;
        }

        private void ensureExecution() throws HttpClientException, InterruptedException {
            if (!this.executed) {
                this.execute();
            }
        }

        public long getResumePosition() {
            return this.resumePosition;
        }

        public DownloadProgress getUploadProgress() {
            return this.uploadProgress;
        }

        public String getUrl() {
            return this.url;
        }

        @Override
        public void interrupt(Thread arg0) {
            HTTPConnection c = this.connection;
            if (c != null) {
                c.disconnect();
            }
        }

        public void linkInterrupt() {
            if (this.addedToInterruptible == Boolean.TRUE) {
                InterruptibleThread.remove(this);
            }
        }

        public RequestContext log() {
            LogV3.info(this + "");
            return this;
        }

        public void onBytesLoaded(byte[] bytes, int offset, int length) {
            DownloadProgress dl = this.getDownloadProgress();
            if (dl != null) {
                if (offset > 0) {
                    throw new WTFException("Unsupported");
                }
                dl.onBytesLoaded(bytes, length);
                dl.increaseLoaded(length);
            }
        }

        public void onConnect() throws IOException {
            DownloadProgress dl;
            DownloadProgress ul = this.getUploadProgress();
            if (ul != null) {
                ul.onConnect(this.getConnection());
            }
            if ((dl = this.getDownloadProgress()) != null) {
                dl.onConnect(this.getConnection());
            }
        }

        public void onConnected() throws IOException {
            DownloadProgress dl;
            DownloadProgress ul = this.getUploadProgress();
            if (ul != null) {
                ul.onConnected(this.getConnection());
            }
            if ((dl = this.getDownloadProgress()) != null) {
                dl.onConnected(this.getConnection());
            }
        }

        public void onContentLength(long completeContentLength) {
            DownloadProgress dl = this.getDownloadProgress();
            if (dl != null) {
                dl.setTotal(completeContentLength);
            }
        }

        public void onDisconnected() {
            DownloadProgress dl;
            DownloadProgress ul = this.getUploadProgress();
            if (ul != null) {
                ul.onDisconnected(this.getConnection());
            }
            if ((dl = this.getDownloadProgress()) != null) {
                dl.onDisconnected(this.getConnection());
            }
        }

        public void onReadingStreamStarted() {
            DownloadProgress dl = this.getDownloadProgress();
            if (dl != null) {
                dl.setLoaded(this.getResumePosition());
            }
        }

        private void setConnection(HTTPConnection connection) {
            this.connection = connection;
            connection.setProfiler(new HTTPConnectionProfilerAdapter(){

                @Override
                public void onDisconnected(HTTPConnection httpConnectionImp) {
                    RequestContext.this.client.requests.remove(RequestContext.this);
                }
            });
        }

        public RequestContext setDownloadProgress(DownloadProgress downloadProgress) {
            this.downloadProgress = downloadProgress;
            return this;
        }

        public RequestContext setMethod(HTTPConnection.RequestMethod method) {
            this.method = method;
            return this;
        }

        public RequestContext setTarget(OutputStream outputstream) {
            this.target = outputstream;
            return this;
        }

        public RequestContext setPostDataLength(int postDataLength) {
            this.postDataLength = postDataLength;
            return this;
        }

        public RequestContext setPostDataStream(InputStream postDataStream) {
            this.postDataStream = postDataStream;
            if (postDataStream instanceof ByteArrayInputStream && this.postDataLength <= 0) {
                this.postDataLength = ((ByteArrayInputStream)postDataStream).available();
            }
            return this;
        }

        public RequestContext setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public RequestContext setResumePosition(long resumePosition) {
            this.resumePosition = resumePosition;
            return this;
        }

        public RequestContext setUploadProgress(DownloadProgress uploadProgress) {
            this.uploadProgress = uploadProgress;
            return this;
        }

        public RequestContext setUrl(String url) {
            this.url = url;
            return this;
        }

        public String toString() {
            try {
                return this.connection + "\r\n\r\n" + this.getResponseString(Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                return this.connection + "";
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return "<INTERRUPTED>" + this.connection + "";
            }
        }

        public void unlinkInterrupt() {
            this.addedToInterruptible = InterruptibleThread.add(this);
        }

        public void onException(Throwable e) {
            DownloadProgress dl;
            DownloadProgress ul = this.getUploadProgress();
            if (ul != null) {
                ul.onException(this.connection, e);
            }
            if ((dl = this.getDownloadProgress()) != null) {
                ul.onException(this.connection, e);
            }
        }

        public void onPostStart() {
            DownloadProgress ul = this.getUploadProgress();
            if (ul != null) {
                ul.setTotal(this.getPostDataLength());
            }
        }

        public void onBytesPosted(byte[] bytes, int offset, int length) {
            DownloadProgress dl = this.getUploadProgress();
            if (dl != null) {
                if (offset > 0) {
                    throw new WTFException("Unsupported");
                }
                dl.onBytesLoaded(bytes, length);
                dl.increaseLoaded(length);
            }
        }

        public RequestContext setTarget(final File target) {
            return this.setTarget(new FilterOutputStream(null){
                private boolean opened;
                {
                    super(x0);
                    this.opened = false;
                }

                @Override
                public void write(int b) throws IOException {
                    this.open();
                    super.write(b);
                }

                private void open() throws FileNotFoundException {
                    if (!this.opened) {
                        this.opened = true;
                        System.out.println("Open " + target);
                        this.out = new BufferedOutputStream(new FileOutputStream(target));
                    }
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.open();
                    super.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    this.open();
                    super.write(b, off, len);
                }

                @Override
                public void flush() throws IOException {
                    if (this.out == null) {
                        return;
                    }
                    this.out.flush();
                    super.flush();
                }

                @Override
                public void close() throws IOException {
                    if (this.out == null) {
                        return;
                    }
                    System.out.println("Close " + target);
                    this.out.close();
                    super.close();
                }
            });
        }

        public RequestContext execute() throws HttpClientException, InterruptedException {
            HttpClient client = this.client;
            if (client == null) {
                client = DEFAULT_HTTP_CLIENT;
            }
            return client.execute(this);
        }

        public RequestContext target(File target) {
            return this.setTarget(target);
        }

        static /* synthetic */ CountingInputStream access$702(RequestContext x0, CountingInputStream x1) {
            x0.inputStream = x1;
            return x0.inputStream;
        }
    }
}

