/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.ftpserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.appwork.utils.net.ftpserver.FTPUser;
import org.appwork.utils.net.ftpserver.FtpCommandNotImplementedException;
import org.appwork.utils.net.ftpserver.FtpConnectionState;
import org.appwork.utils.net.ftpserver.FtpException;
import org.appwork.utils.net.ftpserver.FtpFile;

public abstract class FtpConnectionHandler<E extends FtpFile> {
    public FtpConnectionState createNewConnectionState() {
        return new FtpConnectionState();
    }

    public String formatFileList(List<? extends FtpFile> list) {
        String DEL = " ";
        StringBuilder sb = new StringBuilder();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(5, 1);
        cal.set(2, 0);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        SimpleDateFormat dfCur = new SimpleDateFormat("MMM dd HH:mm", Locale.ENGLISH);
        SimpleDateFormat dfHist = new SimpleDateFormat("MMM dd yyyy", Locale.ENGLISH);
        for (FtpFile ftpFile : list) {
            sb.append(ftpFile.isDirectory() ? "d" : "-");
            sb.append("rwxrwxrwx");
            sb.append(" ");
            sb.append("0");
            sb.append(" ");
            sb.append(ftpFile.getGroup());
            sb.append(" ");
            sb.append(ftpFile.getOwner());
            sb.append(" ");
            sb.append(ftpFile.getSize());
            sb.append(" ");
            if (ftpFile.getLastModified() > cal.getTimeInMillis()) {
                sb.append(dfCur.format(new Date(ftpFile.getLastModified())));
            } else {
                sb.append(dfHist.format(new Date(ftpFile.getLastModified())));
            }
            sb.append(" ");
            sb.append(ftpFile.getName());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public abstract List<E> getFileList(FtpConnectionState var1, String var2) throws UnsupportedEncodingException, IOException, FtpException;

    public abstract long getSize(FtpConnectionState var1, String var2) throws FtpException;

    public abstract FTPUser getUser(String var1);

    public abstract String getWelcomeMessage(FtpConnectionState var1);

    public abstract void makeDirectory(FtpConnectionState var1, String var2) throws FtpException;

    public abstract void onDirectoryUp(FtpConnectionState var1) throws FtpException;

    public abstract String onLoginFailedMessage(FtpConnectionState var1) throws FtpException;

    public abstract String onLoginSuccessRequest(FtpConnectionState var1) throws FtpException;

    public abstract String onLogoutRequest(FtpConnectionState var1) throws FtpException;

    public void onREST(FtpConnectionState connectionState, long position) throws FtpException {
        throw new FtpCommandNotImplementedException();
    }

    public abstract long onRETR(OutputStream var1, FtpConnectionState var2, String var3) throws IOException, FtpException;

    public abstract long onSTOR(InputStream var1, FtpConnectionState var2, boolean var3, String var4) throws FtpException, IOException;

    public abstract void removeDirectory(FtpConnectionState var1, String var2) throws FtpException;

    public abstract void removeFile(FtpConnectionState var1, String var2) throws FtpException;

    public abstract void renameFile(FtpConnectionState var1, String var2) throws FtpException;

    public abstract void setCurrentDirectory(FtpConnectionState var1, String var2) throws FtpException;
}

